/*
 File: o2_linker_opts.h
 Date and Time: Fri Jan 30 18:55:17 2015 
*/
#ifndef __o2_linker_opts_h__
#define __o2_linker_opts_h__ 1
#include "yacco2.h"
#include "yacco2_T_enumeration.h"
#include "yacco2_k_symbols.h"
#include "yacco2_err_symbols.h"
#include "yacco2_terminals.h"
#include "yacco2_characters.h"

#include "ws.h"
#include "eol.h"
#include "c_comments.h"
#include "xc_str.h"
#include "unq_str.h"
  
// monolithic grammar: no thread
extern yacco2::State S1_Co2_linker_opts;
namespace NS_o2_linker_opts {
using namespace NS_yacco2_T_enum;// enumerate
using namespace yacco2;
struct fsm_rules_reuse_table_type{
 fsm_rules_reuse_table_type();
 int no_rules_entries_;
 Per_rule_s_reuse_table* per_rule_s_table_[6];
};
class Co2_linker_opts: public yacco2::CAbs_fsm {
 public:
  enum rules_and_subrules{
   start_of_rule_list = NS_yacco2_T_enum::T_Enum::sum_total_T
   ,R_Ro2_lcl_opts_ = 569//start_of_rule_list + 0
    ,rhs1_Ro2_lcl_opts_ = 1
   ,R_Rextra_chaffe_ = 570//start_of_rule_list + 2
    ,rhs1_Rextra_chaffe_ = 2
    ,rhs2_Rextra_chaffe_ = 3
   ,R_Rws_k_ = 571//start_of_rule_list + 4
    ,rhs1_Rws_k_ = 4
    ,rhs2_Rws_k_ = 5
   ,R_Rws_k_s_ = 572//start_of_rule_list + 6
    ,rhs1_Rws_k_s_ = 6
    ,rhs2_Rws_k_s_ = 7
   ,R_Rws_ = 573//start_of_rule_list + 8
    ,rhs1_Rws_ = 8
    ,rhs2_Rws_ = 9
    ,rhs3_Rws_ = 10
    ,rhs4_Rws_ = 11
   ,R_Rfile_ = 574//start_of_rule_list + 10
    ,rhs1_Rfile_ = 12
    ,rhs2_Rfile_ = 13
    ,rhs3_Rfile_ = 14
    ,rhs4_Rfile_ = 15
  };
  //no of la sets = 3
  //no of states = 20
  Co2_linker_opts();
  ~Co2_linker_opts();
  void op();
  bool failed();
  void reduce_rhs_of_rule
      (yacco2::UINT Sub_rule_no,yacco2::Rule_s_reuse_entry** Recycled_rule);
  fsm_rules_reuse_table_type fsm_rules_reuse_table;
  static int rhs_to_rules_mapping_[16];
  
  public:
  std::string file_to_compile_;
  
 };
struct Ro2_lcl_opts;
struct Rextra_chaffe;
struct Rws_k;
struct Rws_k_s;
struct Rws;
struct Rfile;
struct Ro2_lcl_opts:public yacco2::CAbs_lr1_sym {
  Ro2_lcl_opts(yacco2::Parser* P);
  void op();
  public:
};

struct Rextra_chaffe:public yacco2::CAbs_lr1_sym {
  Rextra_chaffe(yacco2::Parser* P);
  public:
  void sr2();
};

struct Rws_k:public yacco2::CAbs_lr1_sym {
  Rws_k(yacco2::Parser* P);
  public:
};

struct Rws_k_s:public yacco2::CAbs_lr1_sym {
  Rws_k_s(yacco2::Parser* P);
  public:
};

struct Rws:public yacco2::CAbs_lr1_sym {
  Rws(yacco2::Parser* P);
  public:
  void sr2();
  void sr3();
  void sr4();
};

struct Rfile:public yacco2::CAbs_lr1_sym {
  Rfile(yacco2::Parser* P);

    public:
      void edit_file(CAbs_lr1_sym* Sym){
        using namespace NS_yacco2_err_symbols;
        using namespace NS_yacco2_k_symbols;
        Co2_linker_opts* fsm = (Co2_linker_opts*)rule_info__.parser__->fsm_tbl__;      
        std::ifstream ifile;
        ifile.open(fsm->file_to_compile_.c_str());
	    if (ifile.good()){
	      ifile.close(); 
	      return;
	    }
        CAbs_lr1_sym* sym = new Err_bad_filename(fsm->file_to_compile_);
        sym->set_rc(*Sym,__FILE__,__LINE__);
        ADD_TOKEN_TO_ERROR_QUEUE(*sym);
        rule_info__.parser__->set_stop_parse(true);
      };
  
  public:
  void sr1();
  void sr2();
  void sr3();
  void sr4();
};

} // end of namespace

#endif
