/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFStreamException;
import de.tu_darmstadt.sp.paul.filter.FilterMethodFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class StreamFilterFactory {
    static Map decoderMap = new HashMap();

    StreamFilterFactory() {
    }

    static InputStream createInputFilter(InputStream in, PDFName name, PDFObject options) {
        FilterMethodFactory factory = StreamFilterFactory.loadFactory(name.toString());
        try {
            return factory.createInputFilter(in, options);
        }
        catch (IOException e) {
            throw new PDFStreamException("Failed to create input filter for method " + name + ": " + e.getMessage());
        }
    }

    static OutputStream createOutputFilter(OutputStream out, PDFName name, PDFObject options) {
        FilterMethodFactory factory = StreamFilterFactory.loadFactory(name.toString());
        try {
            return factory.createOutputFilter(out, options);
        }
        catch (IOException e) {
            throw new PDFStreamException("Failed to create output filter for method " + name + ": " + e.getMessage());
        }
    }

    private static FilterMethodFactory loadFactory(String name) throws PDFStreamException {
        try {
            if (decoderMap.containsKey(name)) {
                return (FilterMethodFactory)decoderMap.get(name);
            }
            FilterMethodFactory decoder = (FilterMethodFactory)Class.forName("de.tu_darmstadt.sp.paul.filter." + name + "MethodFactory").newInstance();
            decoderMap.put(name, decoder);
            return decoder;
        }
        catch (Exception e) {
            throw new PDFStreamException("FilterMethodFactory not found!: " + e.toString());
        }
    }
}

