/*
 * Decompiled with CFR 0.152.
 */
package LogFilter;

import LogFilter.Entry;
import LogFilter.FileChangeObserver;
import LogFilter.Model;
import LogFilter.Parser;
import LogFilter.UserSettings;
import LogFilter.View;
import java.io.IOException;
import java.util.LinkedList;

class Controller {
    Model model;
    LinkedList windowContent = new LinkedList();
    Parser parser;
    UserSettings usersettings;
    FileChangeObserver fco;
    View view;
    int parsecounter = 0;

    Controller(Model model, UserSettings userSettings, View view) {
        this.model = model;
        this.view = view;
        this.usersettings = userSettings;
        this.parser = new Parser(this);
        this.fco = new FileChangeObserver(userSettings.logfilename, this);
        this.fco.start();
    }

    LinkedList getModel() {
        this.windowContent.clear();
        LinkedList linkedList = this.model.get();
        int n = 0;
        while (n < linkedList.size()) {
            Entry entry = (Entry)linkedList.get(n);
            switch (entry.type) {
                case 0: {
                    if (!this.usersettings.fonterror) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 1: {
                    if (!this.usersettings.fontwarning) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 2: {
                    if (!this.usersettings.underfull_hbox) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 3: {
                    if (!this.usersettings.overfull_hbox) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 4: {
                    if (!this.usersettings.vbox) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 5: {
                    if (!this.usersettings.float_warning) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 6: {
                    if (!this.usersettings.nofile_error) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 7: {
                    if (!this.usersettings.reference_error) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 8: {
                    if (!this.usersettings.latex_warning) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 30: {
                    if (!this.usersettings.fixme_note) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 31: {
                    if (!this.usersettings.fixme_warning) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 32: {
                    if (!this.usersettings.fixme_error) break;
                    this.windowContent.add(entry);
                    break;
                }
                case 100: {
                    this.windowContent.add(entry);
                    break;
                }
                case 101: {
                    this.windowContent.add(entry);
                    break;
                }
                default: {
                    this.view.messageDialog("entry '" + entry.type + "' is not CASED to GUI in the controller- please contact the author to get this fixed.." + entry, "error", 0);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.windowContent.size() - 1) {
            if (((Entry)this.windowContent.get((int)n2)).type == 100 && ((Entry)this.windowContent.get((int)(n2 + 1))).type == 100) {
                this.windowContent.remove(n2--);
            }
            ++n2;
        }
        if (this.windowContent.size() > 0 && ((Entry)this.windowContent.getLast()).type == 100) {
            this.windowContent.removeLast();
        }
        if (this.windowContent.size() == 0) {
            this.windowContent.add(new Entry(101, "There are no elements to display", "", -1));
        }
        return this.windowContent;
    }

    void launch(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > -1) {
            Entry entry = (Entry)this.windowContent.get(n);
            if (entry.type == 101) {
                return;
            }
            if (this.usersettings.editorexe.length() < 1) {
                this.view.messageDialog("You must first configure LogFilter to which editor to integrate with and tell where that editor is placed.\nCorrect this in the preferences it the menu and try again.", "LaTeXLogFilter: Alert!", 0);
                return;
            }
            if (this.usersettings.editorargs.length() < 1) {
                this.view.messageDialog("Missing argument for editor, atleast %f must be specified.\nCorrect this in the preferences it the menu and try again.", "LaTeXLogFilter: Alert!", 0);
                return;
            }
            String string = this.usersettings.editorexe + " " + this.usersettings.editorargs;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c != '%') {
                    stringBuffer.append(c);
                } else if (string.length() > ++n2) {
                    switch (string.charAt(n2)) {
                        case 'f': {
                            stringBuffer.append(entry.filename);
                            break;
                        }
                        case 'l': {
                            stringBuffer.append(entry.lineno);
                            break;
                        }
                        default: {
                            stringBuffer.append("%" + string.charAt(n2));
                            break;
                        }
                    }
                } else {
                    stringBuffer.append('%');
                }
                ++n2;
            }
        }
        try {
            Runtime.getRuntime().exec(stringBuffer.toString());
        }
        catch (IOException iOException) {
            this.view.messageDialog("Unexpected exception" + iOException.getMessage(), "LaTeXLogFilter: Alert!", 0);
        }
    }

    public void quit() {
        this.usersettings.save();
        this.fco.die();
        System.exit(0);
    }

    public void setLogfilename(String string) {
        this.usersettings.logfilename = string;
        this.fco.die();
        this.fco = new FileChangeObserver(string, this);
        this.fco.start();
        this.model.clear();
        this.parser.parse();
    }

    public void update() {
        int n = this.parsecounter++;
        this.model.clear();
        this.parser.parse();
        this.view.refresh();
    }
}

