/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.mfirstuc;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MfirstucSty;
import java.io.IOException;

public class MFUsentencecase
extends Command {
    protected MfirstucSty sty;

    public MFUsentencecase(MfirstucSty mfirstucSty) {
        this("MFUsentencecase", mfirstucSty);
    }

    public MFUsentencecase(String string, MfirstucSty mfirstucSty) {
        super(string);
        this.sty = mfirstucSty;
    }

    @Override
    public Object clone() {
        return new MFUsentencecase(this.getName(), this.sty);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    protected boolean toSentenceCase(TeXObjectList teXObjectList, TeXObjectList teXObjectList2, TeXParser teXParser) throws IOException {
        boolean bl = false;
        while (!teXObjectList.isEmpty() && !bl) {
            Object object;
            TeXObject teXObject = TeXParserUtils.resolve(teXObjectList.popStack(teXParser), teXParser);
            if (teXObject instanceof ControlSequence && ((String)(object = ((ControlSequence)teXObject).getName())).equals("protect")) {
                teXObjectList2.add(teXObject);
                teXObject = TeXParserUtils.resolve(teXObjectList.popStack(teXParser), teXParser);
            }
            if (teXObject instanceof ControlSequence) {
                object = ((ControlSequence)teXObject).getName();
                if (this.sty.isExclusion((String)object)) {
                    teXObjectList2.add(teXObject);
                    teXObject = this.popArg(teXParser, teXObjectList);
                    teXObjectList2.add(TeXParserUtils.createGroup(teXParser, teXObject));
                    continue;
                }
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof MathGroup) {
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof WhiteSpace) {
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof CharObject) {
                int n = ((CharObject)teXObject).getCharCode();
                if (Character.isAlphabetic(n)) {
                    int n2;
                    String string = teXObject.toString(teXParser).toUpperCase();
                    if (string.length() != Character.charCount(n)) {
                        for (n2 = 0; n2 < string.length(); n2 += Character.charCount(n2)) {
                            int n3 = string.codePointAt(n2);
                            if (teXObject instanceof Other) {
                                teXObjectList2.add(teXParser.getListener().getOther(n3));
                                continue;
                            }
                            teXObjectList2.add(teXParser.getListener().getLetter(n3));
                        }
                    } else {
                        n2 = Character.toTitleCase(n);
                        if (teXObject instanceof Other) {
                            teXObjectList2.add(teXParser.getListener().getOther(n2));
                        } else {
                            teXObjectList2.add(teXParser.getListener().getLetter(n2));
                        }
                    }
                    bl = true;
                    continue;
                }
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                object = ((TeXObjectList)teXObject).createList();
                bl = this.toSentenceCase((TeXObjectList)teXObject, (TeXObjectList)object, teXParser);
                teXObjectList2.add((TeXObject)object, true);
                continue;
            }
            if (teXObject instanceof CaseChangeable) {
                teXObjectList2.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
                bl = true;
                continue;
            }
            if (teXObject == null) continue;
            teXObjectList2.add(teXObject);
        }
        teXObjectList2.addAll(teXObjectList);
        return bl;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        TeXObject teXObject = this.popArgExpandFully(teXParser, teXObjectList);
        if (teXParser.isStack(teXObject)) {
            this.toSentenceCase((TeXObjectList)teXObject, teXObjectList2, teXParser);
        } else if (teXObject instanceof CaseChangeable) {
            teXObjectList2.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
        } else {
            teXObjectList2.add(teXObject);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.expandonce(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.expandonce(teXParser).process(teXParser);
    }
}

