/* Module Name:	IdxDef.H
 *
 * Description:
 *	Define data structures used by IdxTeX
 *
 * Author:	R L Aurbach	CR&DS MIS Group    26-Apr-1986
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	26-Apr-1986	Original Code
 * 1-002	RLA	03-May-1986	Add support for page-no highlighting
 * 1-003	RLA	14-Apr-1987	Add new page-no highlight -- ff
 * 2-004	RLA	14-Apr-1987	Add "see also" listhead
 * 3-001	F.H.	17-May-1991	converted to portable C
 * 3-002	S.I.    30-May-1992     Added \indexname \seename and 
 *                                      \alsoname for intern. support
 */

/* Definitions							*/
#define		IDX_K_NONE	0	/* No highlighting	*/
#define		IDX_K_UNDERLINE	1	/* Underline		*/
#define		IDX_K_ITALIC	2	/* Italicize		*/
#define		IDX_K_BOLD	3	/* BoldFace		*/
#define		IDX_K_FOLLOW	4	/* Following		*/
#define		IDX_K_ARTICLE	1	/* /TOC:ARTICLE seen	*/
#define		IDX_K_REPORT	2	/* /TOC:REPORT seen	*/

/* Declarations	*/
typedef struct pgnode
{
  struct pgnode	    *link;	/* Link to next page-ref*/
  char *vol;	                /* Volume string ptr	*/
  char *page_dsc;	        /* Page-ref string	*/
  char		    highlight;	/* Highlight flag	*/
} PGNODE, *PGNODE_PTR;

typedef struct node
{
  struct node	    *link;	/* Link to next node	*/
  char *spell;	                /* Spell string		*/
  char *item;	                /* Item string		*/
  struct node	    *subhead;	/* Subitem listhead	*/
  struct pgnode	    *pghead;	/* Page-ref listhead	*/
  struct pgnode	    *seehead;	/* See-also listhead	*/
} TREE, *TREE_PTR;
