/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.mappingToJvm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gradle.declarative.dsl.schema.DataBuilderFunction;
import org.gradle.declarative.dsl.schema.DataParameter;
import org.gradle.declarative.dsl.schema.DataProperty;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.ExternalObjectProviderKey;
import org.gradle.declarative.dsl.schema.ParameterSemantics;
import org.gradle.declarative.dsl.schema.SchemaFunction;
import org.gradle.declarative.dsl.schema.SchemaMemberFunction;
import org.gradle.internal.declarativedsl.InstanceAndPublicType;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.DeclarativeDslInterpretationException;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.OperationId;
import org.gradle.internal.declarativedsl.analysis.TypedOrigin;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeRuntimeFunction;
import org.gradle.internal.declarativedsl.mappingToJvm.ReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.objectGraph.ObjectReflection;
import org.gradle.internal.declarativedsl.objectGraph.PropertyValueReflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001GBI\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u000eH\u0002J \u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020#H\u0002J\u0014\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0002J(\u00101\u001a\u0002022\u0016\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c042\u0006\u0010/\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u001e2\u0006\u0010/\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010/\u001a\u000209H\u0002J \u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020#H\u0002J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010B\u001a\u00020%H\u0002J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020DH\u0002J\"\u0010E\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010B\u001a\u00020%2\b\u0010F\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/ReflectionToObjectConverter;", "externalObjectsMap", "", "Lorg/gradle/declarative/dsl/schema/ExternalObjectProviderKey;", "", "topLevelObject", "functionResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;", "propertyResolver", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;", "customAccessors", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;", "getScopeClassLoader", "Lkotlin/Function0;", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/util/Map;Ljava/lang/Object;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimePropertyResolver;Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeCustomAccessors;Lkotlin/jvm/functions/Function0;)V", "apply", "", "objectReflection", "Lorg/gradle/internal/declarativedsl/objectGraph/ObjectReflection;", "conversionFilter", "Lorg/gradle/internal/declarativedsl/mappingToJvm/ReflectionToObjectConverter$ConversionFilter;", "reflectionIdentityObjects", "", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "reflectionIdentityPublicTypes", "Lkotlin/reflect/KClass;", "objectByIdentity", "Lorg/gradle/internal/declarativedsl/InstanceAndPublicType;", "key", "newInstanceAndPublicType", "applyPropertyValue", "receiver", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "property", "Lorg/gradle/declarative/dsl/schema/DataProperty;", "assigned", "Lorg/gradle/internal/declarativedsl/objectGraph/PropertyValueReflection;", "getObjectByResolvedOrigin", "objectOrigin", "loadJvmTypeFor", "Ljava/lang/Class;", "dataType", "Lorg/gradle/declarative/dsl/schema/DataType;", "objectFromMemberFunction", "origin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$NewObjectFromMemberFunction;", "invokeFunctionAndGetResult", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeRuntimeFunction$InvocationResult;", "receiverInstanceAndPublicType", "Lkotlin/Pair;", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$FunctionInvocationOrigin;", "objectFromConfiguringLambda", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$ConfiguringLambdaReceiver;", "objectFromCustomAccessor", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$CustomConfigureAccessor;", "invokeBuilderFunction", "receiverOrigin", "function", "Lorg/gradle/declarative/dsl/schema/DataBuilderFunction;", "valueOrigin", "objectFromTopLevelFunction", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$NewObjectFromTopLevelFunction;", "getPropertyValue", "dataProperty", "getEnumConstant", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$EnumConstantOrigin;", "setPropertyValue", "value", "ObjectAccessKey", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nDeclarativeReflectionToObjectConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,266:1\n1869#2,2:267\n1869#2,2:269\n1869#2,2:271\n1869#2,2:273\n1563#2:275\n1634#2,3:276\n1252#2,4:284\n1252#2,4:294\n37#3,2:279\n1#4:281\n463#5:282\n413#5:283\n463#5:292\n413#5:293\n126#6:288\n153#6,3:289\n*S KotlinDebug\n*F\n+ 1 DeclarativeReflectionToObjectConverter.kt\norg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter\n*L\n30#1:267,2\n38#1:269,2\n45#1:271,2\n50#1:273,2\n111#1:275\n111#1:276,3\n168#1:284,4\n224#1:294,4\n111#1:279,2\n168#1:282\n168#1:283\n224#1:292\n224#1:293\n183#1:288\n183#1:289,3\n*E\n"})
public final class DeclarativeReflectionToObjectConverter
implements ReflectionToObjectConverter {
    @NotNull
    private final Map<ExternalObjectProviderKey, Object> externalObjectsMap;
    @NotNull
    private final Object topLevelObject;
    @NotNull
    private final RuntimeFunctionResolver functionResolver;
    @NotNull
    private final RuntimePropertyResolver propertyResolver;
    @NotNull
    private final RuntimeCustomAccessors customAccessors;
    @NotNull
    private final Function0<ClassLoader> getScopeClassLoader;
    @NotNull
    private final Map<ObjectAccessKey, Object> reflectionIdentityObjects;
    @NotNull
    private final Map<ObjectAccessKey, KClass<?>> reflectionIdentityPublicTypes;

    public DeclarativeReflectionToObjectConverter(@NotNull Map<ExternalObjectProviderKey, ? extends Object> externalObjectsMap, @NotNull Object topLevelObject, @NotNull RuntimeFunctionResolver functionResolver, @NotNull RuntimePropertyResolver propertyResolver, @NotNull RuntimeCustomAccessors customAccessors, @NotNull Function0<? extends ClassLoader> getScopeClassLoader) {
        Intrinsics.checkNotNullParameter(externalObjectsMap, (String)"externalObjectsMap");
        Intrinsics.checkNotNullParameter((Object)topLevelObject, (String)"topLevelObject");
        Intrinsics.checkNotNullParameter((Object)functionResolver, (String)"functionResolver");
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        Intrinsics.checkNotNullParameter((Object)customAccessors, (String)"customAccessors");
        Intrinsics.checkNotNullParameter(getScopeClassLoader, (String)"getScopeClassLoader");
        this.externalObjectsMap = externalObjectsMap;
        this.topLevelObject = topLevelObject;
        this.functionResolver = functionResolver;
        this.propertyResolver = propertyResolver;
        this.customAccessors = customAccessors;
        this.getScopeClassLoader = getScopeClassLoader;
        this.reflectionIdentityObjects = new LinkedHashMap();
        this.reflectionIdentityPublicTypes = new LinkedHashMap();
    }

    @Override
    public void apply(@NotNull ObjectReflection objectReflection, @NotNull ReflectionToObjectConverter.ConversionFilter conversionFilter) {
        Intrinsics.checkNotNullParameter((Object)objectReflection, (String)"objectReflection");
        Intrinsics.checkNotNullParameter((Object)conversionFilter, (String)"conversionFilter");
        if (objectReflection instanceof ObjectReflection.DataObjectReflection) {
            Iterable $this$forEach$iv = conversionFilter.filterProperties((ObjectReflection.DataObjectReflection)objectReflection);
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                DataProperty property = element$iv = iterator.next();
                boolean bl = false;
                PropertyValueReflection assigned = (PropertyValueReflection)MapsKt.getValue(((ObjectReflection.DataObjectReflection)objectReflection).getProperties(), (Object)property);
                this.applyPropertyValue(((ObjectReflection.DataObjectReflection)objectReflection).getObjectOrigin(), property, assigned);
                this.apply(assigned.getValue(), conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getAddedObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection addedObject = (ObjectReflection)element$iv;
                boolean bl = false;
                this.getObjectByResolvedOrigin(addedObject.getObjectOrigin());
                this.apply(addedObject, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getCustomAccessorObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection customAccessor = (ObjectReflection)element$iv;
                boolean bl = false;
                this.getObjectByResolvedOrigin(customAccessor.getObjectOrigin()).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.apply$lambda$2$0(customAccessor))).getFirst();
                this.apply(customAccessor, conversionFilter);
            }
            $this$forEach$iv = ((ObjectReflection.DataObjectReflection)objectReflection).getLambdaAccessedObjects();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObjectReflection lambdaAccessedObject = (ObjectReflection)element$iv;
                boolean bl = false;
                this.getObjectByResolvedOrigin(lambdaAccessedObject.getObjectOrigin()).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.apply$lambda$3$0(lambdaAccessedObject))).getFirst();
                this.apply(lambdaAccessedObject, conversionFilter);
            }
        }
    }

    private final InstanceAndPublicType objectByIdentity(ObjectAccessKey key, Function0<InstanceAndPublicType> newInstanceAndPublicType) {
        if (!this.reflectionIdentityObjects.containsKey(key)) {
            InstanceAndPublicType instanceAndPublicType = (InstanceAndPublicType)newInstanceAndPublicType.invoke();
            this.reflectionIdentityObjects.put(key, instanceAndPublicType.getInstance());
            this.reflectionIdentityPublicTypes.put(key, instanceAndPublicType.getPublicType());
            return instanceAndPublicType;
        }
        return InstanceAndPublicType.Companion.of(this.reflectionIdentityObjects.get(key), this.reflectionIdentityPublicTypes.get(key));
    }

    private final void applyPropertyValue(ObjectOrigin receiver, DataProperty property, PropertyValueReflection assigned) {
        AssignmentMethod assignmentMethod = assigned.getAssignmentMethod();
        if (assignmentMethod instanceof AssignmentMethod.Property || assignmentMethod instanceof AssignmentMethod.Augmentation) {
            this.setPropertyValue(receiver, property, this.getObjectByResolvedOrigin(assigned.getValue().getObjectOrigin()).getInstance());
        } else if (assignmentMethod instanceof AssignmentMethod.BuilderFunction) {
            this.invokeBuilderFunction(receiver, ((AssignmentMethod.BuilderFunction)assigned.getAssignmentMethod()).getFunction(), assigned.getValue().getObjectOrigin());
        } else if (!(assignmentMethod instanceof AssignmentMethod.AsConstructed)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final InstanceAndPublicType getObjectByResolvedOrigin(ObjectOrigin objectOrigin) {
        InstanceAndPublicType instanceAndPublicType;
        ObjectOrigin objectOrigin2 = objectOrigin;
        if (objectOrigin2 instanceof ObjectOrigin.DelegatingObjectOrigin) {
            instanceAndPublicType = this.getObjectByResolvedOrigin(((ObjectOrigin.DelegatingObjectOrigin)objectOrigin).getDelegate());
        } else if (objectOrigin2 instanceof ObjectOrigin.ConstantOrigin) {
            instanceAndPublicType = InstanceAndPublicType.Companion.of(((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getValue(), JvmClassMappingKt.getKotlinClass((Class)((ObjectOrigin.ConstantOrigin)objectOrigin).getLiteral().getType().getConstantType()));
        } else if (objectOrigin2 instanceof ObjectOrigin.EnumConstantOrigin) {
            instanceAndPublicType = this.getEnumConstant((ObjectOrigin.EnumConstantOrigin)objectOrigin);
        } else if (objectOrigin2 instanceof ObjectOrigin.External) {
            Object object = this.externalObjectsMap.get(((ObjectOrigin.External)objectOrigin).getKey());
            if (object == null) {
                throw new IllegalStateException(("no external object provided for external object key of " + ((ObjectOrigin.External)objectOrigin).getKey()).toString());
            }
            instanceAndPublicType = InstanceAndPublicType.Companion.unknownPublicType(object);
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromMemberFunction) {
            instanceAndPublicType = this.objectByIdentity(new ObjectAccessKey.Identity(((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getInvocationId()), (Function0<InstanceAndPublicType>)((Function0)() -> DeclarativeReflectionToObjectConverter.getObjectByResolvedOrigin$lambda$0(this, objectOrigin)));
        } else if (objectOrigin2 instanceof ObjectOrigin.NewObjectFromTopLevelFunction) {
            instanceAndPublicType = this.objectByIdentity(new ObjectAccessKey.Identity(((ObjectOrigin.NewObjectFromTopLevelFunction)objectOrigin).getInvocationId()), (Function0<InstanceAndPublicType>)((Function0)() -> DeclarativeReflectionToObjectConverter.getObjectByResolvedOrigin$lambda$1(this, objectOrigin)));
        } else if (objectOrigin2 instanceof ObjectOrigin.NullObjectOrigin) {
            instanceAndPublicType = InstanceAndPublicType.Companion.getNULL();
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyDefaultValue) {
            instanceAndPublicType = this.getPropertyValue(((ObjectOrigin.PropertyDefaultValue)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyDefaultValue)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.PropertyReference) {
            instanceAndPublicType = this.getPropertyValue(((ObjectOrigin.PropertyReference)objectOrigin).getReceiver(), ((ObjectOrigin.PropertyReference)objectOrigin).getProperty());
        } else if (objectOrigin2 instanceof ObjectOrigin.TopLevelReceiver) {
            instanceAndPublicType = InstanceAndPublicType.Companion.of(this.topLevelObject, Reflection.getOrCreateKotlinClass(this.topLevelObject.getClass()));
        } else if (objectOrigin2 instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
            instanceAndPublicType = this.objectFromConfiguringLambda((ObjectOrigin.ConfiguringLambdaReceiver)objectOrigin);
        } else if (objectOrigin2 instanceof ObjectOrigin.CustomConfigureAccessor) {
            instanceAndPublicType = this.objectFromCustomAccessor((ObjectOrigin.CustomConfigureAccessor)objectOrigin);
        } else if (objectOrigin2 instanceof ObjectOrigin.GroupedVarargValue) {
            Object[] objectArray;
            Class<?> elementClass = this.loadJvmTypeFor(((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementType());
            if (Intrinsics.areEqual(elementClass, Integer.TYPE)) {
                int n = 0;
                int n2 = ((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().size();
                int[] nArray = new int[n2];
                while (n < n2) {
                    int n3 = n++;
                    Object object = this.getObjectByResolvedOrigin(((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().get(n3)).getInstance();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    nArray[n3] = (Integer)object;
                }
                objectArray = nArray;
            } else if (Intrinsics.areEqual(elementClass, Long.TYPE)) {
                int n = 0;
                int n4 = ((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().size();
                long[] lArray = new long[n4];
                while (n < n4) {
                    int n5 = n++;
                    Object object = this.getObjectByResolvedOrigin(((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().get(n5)).getInstance();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    lArray[n5] = (Long)object;
                }
                objectArray = lArray;
            } else if (Intrinsics.areEqual(elementClass, Boolean.TYPE)) {
                int n = 0;
                int n6 = ((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().size();
                boolean[] blArray = new boolean[n6];
                while (n < n6) {
                    int n7 = n++;
                    Object object = this.getObjectByResolvedOrigin(((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().get(n7)).getInstance();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    blArray[n7] = (Boolean)object;
                }
                objectArray = blArray;
            } else {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Object[] objectArray2;
                Object object = Array.newInstance(elementClass, ((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues().size());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<in kotlin.Any>");
                Object[] it = objectArray2 = (Object[])object;
                boolean bl = false;
                Iterable $this$map$iv = ((ObjectOrigin.GroupedVarargValue)objectOrigin).getElementValues();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    ObjectOrigin objectOrigin3 = (ObjectOrigin)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.getObjectByResolvedOrigin((ObjectOrigin)it2).getInstance());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ArraysKt.copyInto$default((Object[])thisCollection$iv.toArray(new Object[0]), (Object[])it, (int)0, (int)0, (int)0, (int)14, null);
                objectArray = objectArray2;
            }
            int[] resultArray = objectArray;
            instanceAndPublicType = InstanceAndPublicType.Companion.of(resultArray, Reflection.getOrCreateKotlinClass(resultArray.getClass()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return instanceAndPublicType;
    }

    private final Class<?> loadJvmTypeFor(DataType dataType) {
        Class<Object> clazz;
        DataType dataType2 = dataType;
        if (dataType2 instanceof DataType.HasTypeName) {
            Class<?> clazz2;
            try {
                clazz2 = ((ClassLoader)this.getScopeClassLoader.invoke()).loadClass(((DataType.HasTypeName)dataType).getJavaTypeName());
            }
            catch (ClassNotFoundException e) {
                DeclarativeDslInterpretationException declarativeDslInterpretationException;
                DeclarativeDslInterpretationException it = declarativeDslInterpretationException = new DeclarativeDslInterpretationException("Failed to load the JVM class for " + dataType + " (" + e.getMessage() + ')');
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)it, (Throwable)e);
                throw (Throwable)declarativeDslInterpretationException;
            }
            Class<?> clazz3 = clazz2;
            Intrinsics.checkNotNull(clazz3);
            clazz = clazz3;
        } else if (dataType2 instanceof DataType.BooleanDataType) {
            clazz = Boolean.TYPE;
        } else if (dataType2 instanceof DataType.IntDataType) {
            clazz = Integer.TYPE;
        } else if (dataType2 instanceof DataType.LongDataType) {
            clazz = Long.TYPE;
        } else if (dataType2 instanceof DataType.StringDataType) {
            clazz = String.class;
        } else if (dataType2 instanceof DataType.NullType) {
            clazz = Void.class;
        } else if (dataType2 instanceof DataType.TypeVariableUsage) {
            clazz = Object.class;
        } else if (dataType2 instanceof DataType.UnitType) {
            clazz = Unit.class;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return clazz;
    }

    private final InstanceAndPublicType objectFromMemberFunction(ObjectOrigin.NewObjectFromMemberFunction origin) {
        SchemaMemberFunction dataFun = origin.getFunction();
        Pair<Object, KClass<?>> receiverInstanceAndPublicType = this.getObjectByResolvedOrigin(origin.getReceiver()).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.objectFromMemberFunction$lambda$0(dataFun, origin)));
        DeclarativeRuntimeFunction.InvocationResult callResult = this.invokeFunctionAndGetResult(receiverInstanceAndPublicType, origin);
        return callResult.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final DeclarativeRuntimeFunction.InvocationResult invokeFunctionAndGetResult(Pair<? extends Object, ? extends KClass<?>> receiverInstanceAndPublicType, ObjectOrigin.FunctionInvocationOrigin origin) {
        Map destination$iv$iv$iv;
        SchemaFunction dataFun = origin.getFunction();
        Object receiverInstance = receiverInstanceAndPublicType.getFirst();
        KClass receiverKClass = (KClass)receiverInstanceAndPublicType.getSecond();
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, dataFun, (ClassLoader)this.getScopeClassLoader.invoke());
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Map<DataParameter, TypedOrigin> $this$mapValues$iv = origin.getParameterBindings().getBindingMap();
            boolean $i$f$mapValues = false;
            Map<DataParameter, TypedOrigin> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object = this.getObjectByResolvedOrigin(((TypedOrigin)it.getValue()).getObjectOrigin()).getInstance();
                map3.put(k, object);
            }
        } else {
            if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
                throw new IllegalStateException(("could not resolve a member function " + dataFun + " call in the owner class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        Map bindingWithValues = destination$iv$iv$iv;
        return ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction().callByWithErrorHandling(receiverInstance, bindingWithValues, origin.getParameterBindings().getProvidesConfigureBlock());
    }

    /*
     * WARNING - void declaration
     */
    private final InstanceAndPublicType objectFromConfiguringLambda(ObjectOrigin.ConfiguringLambdaReceiver origin) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<DataParameter, TypedOrigin> map = origin.getParameterBindings().getBindingMap();
        SchemaFunction schemaFunction = origin.getFunction();
        ObjectOrigin objectOrigin = origin.getReceiver();
        DeclarativeReflectionToObjectConverter declarativeReflectionToObjectConverter = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ObjectOrigin objectOrigin2;
            Object object;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            DataParameter parameter = (DataParameter)entry.getKey();
            TypedOrigin value = (TypedOrigin)entry.getValue();
            collection.add(parameter.getSemantics() instanceof ParameterSemantics.IdentityKey ? ((object = (objectOrigin2 = value.getObjectOrigin()) instanceof ObjectOrigin.ConstantOrigin ? (ObjectOrigin.ConstantOrigin)objectOrigin2 : null) != null && (object = ((ObjectOrigin.ConstantOrigin)object).getLiteral()) != null ? object.getValue() : null) : null);
        }
        Collection<Object> collection2 = collection = (List)destination$iv$iv;
        SchemaFunction schemaFunction2 = schemaFunction;
        ObjectOrigin objectOrigin3 = objectOrigin;
        return declarativeReflectionToObjectConverter.objectByIdentity(new ObjectAccessKey.ConfiguringLambda(objectOrigin3, schemaFunction2, (List<? extends Object>)collection2), (Function0<InstanceAndPublicType>)((Function0)() -> DeclarativeReflectionToObjectConverter.objectFromConfiguringLambda$lambda$1(origin, this)));
    }

    private final InstanceAndPublicType objectFromCustomAccessor(ObjectOrigin.CustomConfigureAccessor origin) {
        return this.objectByIdentity(new ObjectAccessKey.CustomAccessor(origin.getReceiver(), origin.getAccessor().getCustomAccessorIdentifier()), (Function0<InstanceAndPublicType>)((Function0)() -> DeclarativeReflectionToObjectConverter.objectFromCustomAccessor$lambda$0(this, origin)));
    }

    private final void invokeBuilderFunction(ObjectOrigin receiverOrigin, DataBuilderFunction function, ObjectOrigin valueOrigin) {
        Pair<Object, KClass<?>> receiverInstanceAndPublicType = this.getObjectByResolvedOrigin(receiverOrigin).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.invokeBuilderFunction$lambda$0(function, receiverOrigin)));
        Object receiverInstance = receiverInstanceAndPublicType.getFirst();
        KClass receiverKClass = (KClass)receiverInstanceAndPublicType.getSecond();
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(receiverKClass, (SchemaFunction)function, (ClassLoader)this.getScopeClassLoader.invoke());
        if (!(runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved)) {
            if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
                throw new IllegalStateException(("could not resolve a member function " + function + " call in the owner class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        Map binding = MapsKt.mapOf((Pair)TuplesKt.to((Object)function.getDataParameter(), (Object)this.getObjectByResolvedOrigin(valueOrigin).getInstance()));
        ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction().callByWithErrorHandling(receiverInstance, binding, false).getResult();
    }

    /*
     * WARNING - void declaration
     */
    private final InstanceAndPublicType objectFromTopLevelFunction(ObjectOrigin.NewObjectFromTopLevelFunction origin) {
        Map destination$iv$iv$iv;
        RuntimeFunctionResolver.Resolution runtimeFunction = this.functionResolver.resolve(Reflection.getOrCreateKotlinClass(Object.class), origin.getFunction(), (ClassLoader)this.getScopeClassLoader.invoke());
        if (runtimeFunction instanceof RuntimeFunctionResolver.Resolution.Resolved) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Map<DataParameter, TypedOrigin> $this$mapValues$iv = origin.getParameterBindings().getBindingMap();
            boolean $i$f$mapValues = false;
            Map<DataParameter, TypedOrigin> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object = this.getObjectByResolvedOrigin(((TypedOrigin)it.getValue()).getObjectOrigin()).getInstance();
                map3.put(k, object);
            }
        } else {
            if (Intrinsics.areEqual((Object)runtimeFunction, (Object)RuntimeFunctionResolver.Resolution.Unresolved.INSTANCE)) {
                throw new IllegalStateException(("could not resolve a top-level function " + origin.getFunction()).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        Map bindingWithValues = destination$iv$iv$iv;
        return ((RuntimeFunctionResolver.Resolution.Resolved)runtimeFunction).getFunction().callByWithErrorHandling(null, bindingWithValues, origin.getParameterBindings().getProvidesConfigureBlock()).getResult();
    }

    private final InstanceAndPublicType getPropertyValue(ObjectOrigin receiver, DataProperty dataProperty) {
        Pair<Object, KClass<?>> receiverInstanceAndPublicType = this.getObjectByResolvedOrigin(receiver).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.getPropertyValue$lambda$0(dataProperty)));
        Object receiverInstance = receiverInstanceAndPublicType.getFirst();
        KClass receiverPublicType = (KClass)receiverInstanceAndPublicType.getSecond();
        RuntimePropertyResolver.ReadResolution property = this.propertyResolver.resolvePropertyRead(receiverPublicType, dataProperty.getName());
        if (!(property instanceof RuntimePropertyResolver.ReadResolution.ResolvedRead)) {
            if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.ReadResolution.UnresolvedRead.INSTANCE)) {
                throw new IllegalStateException(("cannot get property " + dataProperty.getName() + " from the receiver class " + receiverPublicType).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((RuntimePropertyResolver.ReadResolution.ResolvedRead)property).getGetter().getValue(receiverInstance);
    }

    private final InstanceAndPublicType getEnumConstant(ObjectOrigin.EnumConstantOrigin objectOrigin) {
        Object v1;
        Class<?> enumClass;
        block3: {
            enumClass = this.loadJvmTypeFor((DataType)objectOrigin.getType());
            if (enumClass.isEnum()) {
                Intrinsics.checkNotNull(enumClass, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                ?[] objArray = enumClass.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objArray, (String)"getEnumConstants(...)");
                for (Object obj : objArray) {
                    Enum it = (Enum)obj;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)objectOrigin.getEntryName())) continue;
                    v1 = obj;
                    break block3;
                }
                v1 = null;
            } else {
                throw new IllegalStateException((enumClass + " is not an enum class").toString());
            }
        }
        Enum enumConstant = v1;
        return InstanceAndPublicType.Companion.of(enumConstant, JvmClassMappingKt.getKotlinClass(enumClass));
    }

    private final void setPropertyValue(ObjectOrigin receiver, DataProperty dataProperty, Object value) {
        Object receiverInstance = this.getObjectByResolvedOrigin(receiver).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.setPropertyValue$lambda$0(dataProperty))).getFirst();
        KClass receiverKClass = Reflection.getOrCreateKotlinClass(receiverInstance.getClass());
        RuntimePropertyResolver.WriteResolution property = this.propertyResolver.resolvePropertyWrite(receiverKClass, dataProperty.getName());
        if (!(property instanceof RuntimePropertyResolver.WriteResolution.ResolvedWrite)) {
            if (Intrinsics.areEqual((Object)property, (Object)RuntimePropertyResolver.WriteResolution.UnresolvedWrite.INSTANCE)) {
                throw new IllegalStateException(("cannot set property " + dataProperty.getName() + " in the receiver class " + receiverKClass).toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RuntimePropertyResolver.WriteResolution.ResolvedWrite)property).getSetter().setValue(receiverInstance, value);
    }

    private static final String apply$lambda$2$0(ObjectReflection $customAccessor) {
        return "could not get object by custom accessor " + $customAccessor.getObjectOrigin();
    }

    private static final String apply$lambda$3$0(ObjectReflection $lambdaAccessedObject) {
        return "could not get object from lambda passed to " + $lambdaAccessedObject.getObjectOrigin();
    }

    private static final InstanceAndPublicType getObjectByResolvedOrigin$lambda$0(DeclarativeReflectionToObjectConverter this$0, ObjectOrigin $objectOrigin) {
        return this$0.objectFromMemberFunction((ObjectOrigin.NewObjectFromMemberFunction)$objectOrigin);
    }

    private static final InstanceAndPublicType getObjectByResolvedOrigin$lambda$1(DeclarativeReflectionToObjectConverter this$0, ObjectOrigin $objectOrigin) {
        return this$0.objectFromTopLevelFunction((ObjectOrigin.NewObjectFromTopLevelFunction)$objectOrigin);
    }

    private static final String objectFromMemberFunction$lambda$0(SchemaMemberFunction $dataFun, ObjectOrigin.NewObjectFromMemberFunction $origin) {
        return "tried to invoke a function " + $dataFun + " on a null receiver " + $origin.getReceiver();
    }

    private static final InstanceAndPublicType objectFromConfiguringLambda$lambda$1(ObjectOrigin.ConfiguringLambdaReceiver $origin, DeclarativeReflectionToObjectConverter this$0) {
        SchemaFunction function = $origin.getFunction();
        Pair<Object, KClass<?>> receiverInstanceAndPublicType = this$0.getObjectByResolvedOrigin($origin.getReceiver()).validate((Function0<String>)((Function0)() -> DeclarativeReflectionToObjectConverter.objectFromConfiguringLambda$lambda$1$0(function, $origin)));
        return this$0.invokeFunctionAndGetResult(receiverInstanceAndPublicType, $origin).getCapturedValue();
    }

    private static final String objectFromConfiguringLambda$lambda$1$0(SchemaFunction $function, ObjectOrigin.ConfiguringLambdaReceiver $origin) {
        return "tried to invoke a function " + $function + " on a null receiver " + $origin.getReceiver();
    }

    private static final InstanceAndPublicType objectFromCustomAccessor$lambda$0(DeclarativeReflectionToObjectConverter this$0, ObjectOrigin.CustomConfigureAccessor $origin) {
        Pair<Object, KClass<?>> instanceAndPublicType = this$0.getObjectByResolvedOrigin($origin.getReceiver()).validate((Function0<String>)((Function0)DeclarativeReflectionToObjectConverter::objectFromCustomAccessor$lambda$0$0));
        return this$0.customAccessors.getObjectFromCustomAccessor(instanceAndPublicType.getFirst(), $origin.getAccessor());
    }

    private static final String objectFromCustomAccessor$lambda$0$0() {
        return "receiver for custom accessor is null";
    }

    private static final String invokeBuilderFunction$lambda$0(DataBuilderFunction $function, ObjectOrigin $receiverOrigin) {
        return "tried to invoke a function " + $function + " on a null receiver " + $receiverOrigin;
    }

    private static final String getPropertyValue$lambda$0(DataProperty $dataProperty) {
        return "tried to access a property " + $dataProperty.getName() + " on a null receiver";
    }

    private static final String setPropertyValue$lambda$0(DataProperty $dataProperty) {
        return "tried to access a property " + $dataProperty.getName() + " on a null receiver";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "", "Identity", "CustomAccessor", "ConfiguringLambda", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$ConfiguringLambda;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$CustomAccessor;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$Identity;", "declarative-dsl-core"})
    private static interface ObjectAccessKey {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0003J/\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$ConfiguringLambda;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "owner", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "function", "Lorg/gradle/declarative/dsl/schema/SchemaFunction;", "identityValues", "", "", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;Lorg/gradle/declarative/dsl/schema/SchemaFunction;Ljava/util/List;)V", "getOwner", "()Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "getFunction", "()Lorg/gradle/declarative/dsl/schema/SchemaFunction;", "getIdentityValues", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "declarative-dsl-core"})
        public static final class ConfiguringLambda
        implements ObjectAccessKey {
            @NotNull
            private final ObjectOrigin owner;
            @NotNull
            private final SchemaFunction function;
            @NotNull
            private final List<Object> identityValues;

            public ConfiguringLambda(@NotNull ObjectOrigin owner, @NotNull SchemaFunction function, @NotNull List<? extends Object> identityValues) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                Intrinsics.checkNotNullParameter(identityValues, (String)"identityValues");
                this.owner = owner;
                this.function = function;
                this.identityValues = identityValues;
            }

            @NotNull
            public final ObjectOrigin getOwner() {
                return this.owner;
            }

            @NotNull
            public final SchemaFunction getFunction() {
                return this.function;
            }

            @NotNull
            public final List<Object> getIdentityValues() {
                return this.identityValues;
            }

            @NotNull
            public final ObjectOrigin component1() {
                return this.owner;
            }

            @NotNull
            public final SchemaFunction component2() {
                return this.function;
            }

            @NotNull
            public final List<Object> component3() {
                return this.identityValues;
            }

            @NotNull
            public final ConfiguringLambda copy(@NotNull ObjectOrigin owner, @NotNull SchemaFunction function, @NotNull List<? extends Object> identityValues) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                Intrinsics.checkNotNullParameter(identityValues, (String)"identityValues");
                return new ConfiguringLambda(owner, function, identityValues);
            }

            public static /* synthetic */ ConfiguringLambda copy$default(ConfiguringLambda configuringLambda, ObjectOrigin objectOrigin, SchemaFunction schemaFunction, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    objectOrigin = configuringLambda.owner;
                }
                if ((n & 2) != 0) {
                    schemaFunction = configuringLambda.function;
                }
                if ((n & 4) != 0) {
                    list = configuringLambda.identityValues;
                }
                return configuringLambda.copy(objectOrigin, schemaFunction, list);
            }

            @NotNull
            public String toString() {
                return "ConfiguringLambda(owner=" + this.owner + ", function=" + this.function + ", identityValues=" + this.identityValues + ')';
            }

            public int hashCode() {
                int result = this.owner.hashCode();
                result = result * 31 + this.function.hashCode();
                result = result * 31 + ((Object)this.identityValues).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConfiguringLambda)) {
                    return false;
                }
                ConfiguringLambda configuringLambda = (ConfiguringLambda)other;
                if (!Intrinsics.areEqual((Object)this.owner, (Object)configuringLambda.owner)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.function, (Object)configuringLambda.function)) {
                    return false;
                }
                return Intrinsics.areEqual(this.identityValues, configuringLambda.identityValues);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$CustomAccessor;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "owner", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "accessorId", "", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;Ljava/lang/String;)V", "getOwner", "()Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "getAccessorId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "declarative-dsl-core"})
        public static final class CustomAccessor
        implements ObjectAccessKey {
            @NotNull
            private final ObjectOrigin owner;
            @NotNull
            private final String accessorId;

            public CustomAccessor(@NotNull ObjectOrigin owner, @NotNull String accessorId) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)accessorId, (String)"accessorId");
                this.owner = owner;
                this.accessorId = accessorId;
            }

            @NotNull
            public final ObjectOrigin getOwner() {
                return this.owner;
            }

            @NotNull
            public final String getAccessorId() {
                return this.accessorId;
            }

            @NotNull
            public final ObjectOrigin component1() {
                return this.owner;
            }

            @NotNull
            public final String component2() {
                return this.accessorId;
            }

            @NotNull
            public final CustomAccessor copy(@NotNull ObjectOrigin owner, @NotNull String accessorId) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)accessorId, (String)"accessorId");
                return new CustomAccessor(owner, accessorId);
            }

            public static /* synthetic */ CustomAccessor copy$default(CustomAccessor customAccessor, ObjectOrigin objectOrigin, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    objectOrigin = customAccessor.owner;
                }
                if ((n & 2) != 0) {
                    string = customAccessor.accessorId;
                }
                return customAccessor.copy(objectOrigin, string);
            }

            @NotNull
            public String toString() {
                return "CustomAccessor(owner=" + this.owner + ", accessorId=" + this.accessorId + ')';
            }

            public int hashCode() {
                int result = this.owner.hashCode();
                result = result * 31 + this.accessorId.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CustomAccessor)) {
                    return false;
                }
                CustomAccessor customAccessor = (CustomAccessor)other;
                if (!Intrinsics.areEqual((Object)this.owner, (Object)customAccessor.owner)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.accessorId, (Object)customAccessor.accessorId);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey$Identity;", "Lorg/gradle/internal/declarativedsl/mappingToJvm/DeclarativeReflectionToObjectConverter$ObjectAccessKey;", "id", "Lorg/gradle/internal/declarativedsl/analysis/OperationId;", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/OperationId;)V", "getId", "()Lorg/gradle/internal/declarativedsl/analysis/OperationId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "declarative-dsl-core"})
        public static final class Identity
        implements ObjectAccessKey {
            @NotNull
            private final OperationId id;

            public Identity(@NotNull OperationId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.id = id;
            }

            @NotNull
            public final OperationId getId() {
                return this.id;
            }

            @NotNull
            public final OperationId component1() {
                return this.id;
            }

            @NotNull
            public final Identity copy(@NotNull OperationId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return new Identity(id);
            }

            public static /* synthetic */ Identity copy$default(Identity identity, OperationId operationId, int n, Object object) {
                if ((n & 1) != 0) {
                    operationId = identity.id;
                }
                return identity.copy(operationId);
            }

            @NotNull
            public String toString() {
                return "Identity(id=" + this.id + ')';
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Identity)) {
                    return false;
                }
                Identity identity = (Identity)other;
                return Intrinsics.areEqual((Object)this.id, (Object)identity.id);
            }
        }
    }
}

