/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.coverage;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.collections.IntList;

public class CoverageModule {
    @JRubyMethod(module=true, optional=1, checkArity=false)
    public static IRubyObject setup(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int mode2;
        IRubyObject opt;
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() != CoverageData.CoverageDataState.IDLE) {
            throw Error.runtimeError(context, "coverage measurement is already setup");
        }
        IRubyObject iRubyObject = opt = argc == 0 ? context.nil : args2[0];
        if (argc == 0) {
            mode2 = 0;
        } else if (opt instanceof RubySymbol && opt == Convert.asSymbol(context, "all")) {
            mode2 = 23;
        } else {
            mode2 = 0;
            RubyHash keywords = (RubyHash)TypeConverter.convertToType(opt, Access.hashClass(context), "to_hash");
            if (ArgsUtil.extractKeywordArg(context, "lines", keywords).isTrue()) {
                mode2 |= 1;
            }
            if (ArgsUtil.extractKeywordArg(context, "eval", keywords).isTrue()) {
                mode2 |= 0x10;
            }
            if (ArgsUtil.extractKeywordArg(context, "branches", keywords).isTrue()) {
                Warn.warn(context, "branch coverage is not supported");
                mode2 |= 2;
            }
            if (ArgsUtil.extractKeywordArg(context, "methods", keywords).isTrue()) {
                Warn.warn(context, "method coverage is not supported");
                mode2 |= 4;
            }
            if (ArgsUtil.extractKeywordArg(context, "oneshot_lines", keywords).isTrue()) {
                if ((mode2 & 1) != 0) {
                    throw Error.runtimeError(context, "cannot enable lines and oneshot_lines simultaneously");
                }
                mode2 |= 1;
                mode2 |= 8;
            }
        }
        int currentMode = mode2;
        if (data2.getCoverage() == null) {
            if (mode2 == 0) {
                mode2 |= 1;
            }
            data2.setCoverage(mode2, currentMode, CoverageData.CoverageDataState.SUSPENDED);
        } else if (currentMode != data2.getCurrentMode()) {
            throw Error.runtimeError(context, "cannot change the measuring target during coverage measurement");
        }
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject resume(ThreadContext context, IRubyObject self2) {
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() == CoverageData.CoverageDataState.IDLE) {
            throw Error.runtimeError(context, "coverage measurement is not set up yet");
        }
        if (data2.getCurrentState() == CoverageData.CoverageDataState.RUNNING) {
            throw Error.runtimeError(context, "coverage measurement is already running");
        }
        data2.resumeCoverage();
        return context.nil;
    }

    @JRubyMethod(module=true)
    public static IRubyObject suspend(ThreadContext context, IRubyObject self2) {
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() != CoverageData.CoverageDataState.RUNNING) {
            throw Error.runtimeError(context, "coverage measurement is not running");
        }
        data2.suspendCoverage();
        return context.nil;
    }

    @JRubyMethod(module=true, optional=1, keywords=true, checkArity=false)
    public static IRubyObject start(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        CoverageModule.setup(context, self2, args2);
        CoverageModule.resume(context, self2);
        return context.nil;
    }

    @JRubyMethod(module=true, optional=1, keywords=true, checkArity=false)
    public static IRubyObject result(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        CoverageData data2 = context.runtime.getCoverageData();
        if (data2.getCurrentState() == CoverageData.CoverageDataState.IDLE) {
            throw Error.runtimeError(context, "coverage measurement is not enabled");
        }
        boolean stop2 = true;
        boolean clear2 = true;
        if (argc > 0 && ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context))) {
            RubyHash keywords = (RubyHash)TypeConverter.convertToType(args2[0], Access.hashClass(context), "to_hash");
            stop2 = ArgsUtil.extractKeywordArg(context, "stop", keywords).isTrue();
            clear2 = ArgsUtil.extractKeywordArg(context, "clear", keywords).isTrue();
        }
        IRubyObject result2 = CoverageModule.peek_result(context, self2);
        if (stop2 && !clear2) {
            Warn.warn(context, "stop implies clear");
            clear2 = true;
        }
        if (clear2) {
            data2.clearCoverage();
        }
        if (stop2) {
            if (data2.getCurrentState() == CoverageData.CoverageDataState.RUNNING) {
                data2.suspendCoverage();
            }
            data2.resetCoverage();
            data2.setCurrentState(CoverageData.CoverageDataState.IDLE);
        }
        return result2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject peek_result(ThreadContext context, IRubyObject self2) {
        CoverageData coverageData = context.runtime.getCoverageData();
        if (!coverageData.isCoverageEnabled()) {
            throw Error.runtimeError(context, "coverage measurement is not enabled");
        }
        return CoverageModule.convertCoverageToRuby(context, coverageData.getCoverage(), coverageData.getCurrentMode());
    }

    @JRubyMethod(name={"running?"}, module=true)
    public static IRubyObject running_p(ThreadContext context, IRubyObject self2) {
        return context.runtime.getCoverageData().getCurrentState() == CoverageData.CoverageDataState.RUNNING ? context.tru : context.fals;
    }

    @JRubyMethod(module=true)
    public static IRubyObject state(ThreadContext context, IRubyObject self2) {
        return switch (context.runtime.getCoverageData().getCurrentState()) {
            default -> throw new MatchException(null, null);
            case CoverageData.CoverageDataState.IDLE -> Convert.asSymbol(context, "idle");
            case CoverageData.CoverageDataState.SUSPENDED -> Convert.asSymbol(context, "suspended");
            case CoverageData.CoverageDataState.RUNNING -> Convert.asSymbol(context, "running");
        };
    }

    @JRubyMethod(module=true)
    public static IRubyObject line_stub(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return context.runtime.getParserManager().getLineStub(context, arg2);
    }

    @JRubyMethod(module=true, name={"supported?"})
    public static IRubyObject supported_p(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        RubySymbol mode2 = Convert.castAsSymbol(context, arg2);
        return mode2 == Convert.asSymbol(context, "lines") || mode2 == Convert.asSymbol(context, "oneshot_lines") || mode2 == Convert.asSymbol(context, "eval") ? context.tru : context.fals;
    }

    private static IRubyObject convertCoverageToRuby(ThreadContext context, Map<String, IntList> coverage2, int mode2) {
        if (coverage2 == null) {
            return Create.newSmallHash(context);
        }
        RubyHash covHash = Create.newHash(context);
        for (Map.Entry<String, IntList> entry : coverage2.entrySet()) {
            RubyObject value2;
            IntList val = entry.getValue();
            boolean oneshot = (mode2 & 8) != 0;
            int size2 = val.size();
            RubyArray<?> ary = Create.allocArray(context, size2);
            for (int i2 = 0; i2 < size2; ++i2) {
                int integer = val.get(i2);
                if (oneshot) {
                    ary.push(context, Convert.asFixnum(context, integer + 1));
                    continue;
                }
                ary.store(i2, integer == -1 ? context.nil : Convert.asFixnum(context, integer));
            }
            RubyString key2 = Create.newString(context, entry.getKey());
            if (mode2 != 0) {
                RubyHash oneshotHash = Create.newSmallHash(context);
                RubySymbol linesKey = Convert.asSymbol(context, oneshot ? "oneshot_lines" : "lines");
                oneshotHash.fastASetSmall(linesKey, ary);
                value2 = oneshotHash;
            } else {
                value2 = ary;
            }
            covHash.fastASetCheckString(context.runtime, key2, value2);
        }
        return covHash;
    }
}

