/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlProperties;

public class ServerProperties
extends HsqlProperties {
    static final int SERVER_PROPERTY = 0;
    static final int SERVER_MULTI_PROPERTY = 1;
    static final int SYSTEM_PROPERTY = 2;
    static final String sc_key_prefix = "server";
    static final String sc_key_address = "server.address";
    static final String sc_key_autorestart_server = "server.restart_on_shutdown";
    static final String sc_key_database = "server.database";
    static final String sc_key_dbname = "server.dbname";
    static final String sc_key_no_system_exit = "server.no_system_exit";
    static final String sc_key_port = "server.port";
    static final String sc_key_http_port = "server.port";
    static final String sc_key_silent = "server.silent";
    static final String sc_key_tls = "server.tls";
    static final String sc_key_trace = "server.trace";
    static final String sc_key_web_default_page = "server.default_page";
    static final String sc_key_web_root = "server.root";
    static final String sc_key_max_connections = "server.maxconnections";
    static final String sc_key_max_wait = "server.max_wait";
    static final String sc_key_remote_open_db = "server.remote_open";
    static final String sc_key_max_databases = "server.maxdatabases";
    static final String sc_key_acl = "server.acl";
    static final String sc_key_daemon = "server.daemon";
    static final String sc_key_props = "server.props";
    static final String sc_key_system = "system";
    static final String sc_default_web_mime = "text/html";
    static final String sc_default_web_page = "index.html";
    static final String sc_default_web_root = ".";
    static final HashMap<String, HsqlProperties.PropertyMeta> serverMeta = new HashMap();
    static final OrderedHashSet<String> prefixes = new OrderedHashSet();
    final int protocol;
    protected boolean initialised = false;
    IntKeyHashMap<String> idToAliasMap = new IntKeyHashMap();
    IntKeyHashMap<String> idToPathMap = new IntKeyHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProperties(int n, File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this.stringProps.load(fileInputStream);
        }
        this.protocol = n;
    }

    ServerProperties(int n) {
        this.protocol = n;
    }

    ServerProperties(int n, String string, String string2) {
        super(string, string2);
        this.protocol = n;
    }

    @Override
    public void validate() {
        Object object;
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object2;
            object = (String)enumeration.nextElement();
            HsqlProperties.PropertyMeta propertyMeta = serverMeta.get(object);
            if (propertyMeta == null) {
                propertyMeta = this.getPrefixedMetadata((String)object);
            }
            if (propertyMeta == null) {
                object2 = "unsupported property: " + object;
                super.addError(0, (String)object2);
                continue;
            }
            object2 = null;
            if (propertyMeta.propType == 2) {
                object2 = this.validateSystemProperty((String)object, propertyMeta);
            } else if (propertyMeta.propType == 1) {
                object2 = this.validateMultiProperty((String)object, propertyMeta);
            } else {
                String string = this.getProperty((String)object);
                if (string == null) {
                    if (propertyMeta.propDefaultValue == null) {
                        object2 = "missing value for property: " + object;
                    } else {
                        this.setProperty((String)object, propertyMeta.propDefaultValue.toString());
                    }
                } else {
                    object2 = HsqlProperties.validateProperty(object, string, propertyMeta);
                }
            }
            if (object2 == null) continue;
            super.addError(0, (String)object2);
        }
        object = this.idToAliasMap.keySet().iterator();
        while (object.hasNext()) {
            int n = object.nextInt();
            if (this.idToPathMap.containsKey(n)) continue;
            this.addError(0, "no path for database id: " + n);
        }
        object = this.idToPathMap.keySet().iterator();
        while (object.hasNext()) {
            int n = object.nextInt();
            if (this.idToAliasMap.containsKey(n)) continue;
            this.addError(0, "no alias for database id: " + n);
        }
        this.initialised = true;
    }

    HsqlProperties.PropertyMeta getPrefixedMetadata(String string) {
        for (int i = 0; i < prefixes.size(); ++i) {
            String string2 = prefixes.get(i);
            if (!string.startsWith(string2)) continue;
            return serverMeta.get((Object)string2);
        }
        return null;
    }

    String validateMultiProperty(String object, HsqlProperties.PropertyMeta propertyMeta) {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        String string5 = propertyMeta.propName;
        if (propertyMeta.propName.equals(sc_key_database) && sc_key_database.equals(object)) {
            object = (String)object + ".0";
        }
        try {
            n = Integer.parseInt(((String)object).substring(string5.length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            return "malformed database enumerator: " + (String)object;
        }
        if (propertyMeta.propName.equals(sc_key_dbname) ? (string4 = this.idToAliasMap.put(n, string3 = this.stringProps.getProperty((String)object).toLowerCase())) != null : propertyMeta.propName.equals(sc_key_database) && (string2 = this.idToPathMap.put(n, string = this.stringProps.getProperty((String)object))) != null) {
            return "duplicate database enumerator: " + (String)object;
        }
        return null;
    }

    String validateSystemProperty(String string, HsqlProperties.PropertyMeta propertyMeta) {
        String string2 = propertyMeta.propName;
        String string3 = string.substring(string2.length() + 1);
        String string4 = this.stringProps.getProperty(string);
        if (string4 == null) {
            return "value required for property: " + string;
        }
        System.setProperty(string3, string4);
        return null;
    }

    static {
        serverMeta.put(sc_key_database, ServerProperties.newMeta(sc_key_database, 1, null));
        serverMeta.put(sc_key_dbname, ServerProperties.newMeta(sc_key_dbname, 1, null));
        serverMeta.put(sc_key_system, ServerProperties.newMeta(sc_key_system, 2, null));
        serverMeta.put(sc_key_silent, ServerProperties.newMeta(sc_key_silent, 0, false));
        serverMeta.put(sc_key_trace, ServerProperties.newMeta(sc_key_trace, 0, false));
        serverMeta.put(sc_key_tls, ServerProperties.newMeta(sc_key_tls, 0, false));
        serverMeta.put(sc_key_acl, ServerProperties.newMeta(sc_key_acl, 0, null));
        serverMeta.put(sc_key_autorestart_server, ServerProperties.newMeta(sc_key_autorestart_server, 0, false));
        serverMeta.put(sc_key_remote_open_db, ServerProperties.newMeta(sc_key_remote_open_db, 0, false));
        serverMeta.put(sc_key_no_system_exit, ServerProperties.newMeta(sc_key_no_system_exit, 0, false));
        serverMeta.put(sc_key_daemon, ServerProperties.newMeta(sc_key_daemon, 0, false));
        serverMeta.put(sc_key_address, ServerProperties.newMeta(sc_key_address, 0, null));
        serverMeta.put("server.port", ServerProperties.newMeta("server.port", 0, 9001, 0, 65535));
        serverMeta.put("server.port", ServerProperties.newMeta("server.port", 0, 80, 0, 65535));
        serverMeta.put(sc_key_max_connections, ServerProperties.newMeta(sc_key_max_connections, 0, 100, 1, 10000));
        serverMeta.put(sc_key_max_wait, ServerProperties.newMeta(sc_key_max_wait, 0, 1000, 0, 30000));
        serverMeta.put(sc_key_max_databases, ServerProperties.newMeta(sc_key_max_databases, 0, 10, 1, 1000));
        prefixes.add(sc_key_database);
        prefixes.add(sc_key_dbname);
        prefixes.add(sc_key_system);
    }
}

