/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.services.ComponentResultProcessorWrapper;
import org.apache.tapestry5.internal.services.PageActivator;
import org.apache.tapestry5.internal.services.RestEndpointNotFoundException;
import org.apache.tapestry5.internal.services.UnknownActivationContextHandler;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.MetaDataLocator;
import org.slf4j.Logger;

public class PageActivatorImpl
implements PageActivator {
    private final Logger logger;
    private final MetaDataLocator metaDataLocator;
    private final UnknownActivationContextHandler unknownActivationContextHandler;
    private final Request request;

    public PageActivatorImpl(Logger logger, MetaDataLocator metaDataLocator, UnknownActivationContextHandler unknownActivationContextHandler, Request request) {
        this.logger = logger;
        this.metaDataLocator = metaDataLocator;
        this.unknownActivationContextHandler = unknownActivationContextHandler;
        this.request = request;
    }

    @Override
    public boolean activatePage(ComponentResources pageResources, EventContext activationContext, ComponentEventResultProcessor resultProcessor) throws IOException {
        ComponentResultProcessorWrapper callback = new ComponentResultProcessorWrapper(resultProcessor);
        boolean handled = pageResources.triggerContextEvent("activate", activationContext, callback);
        boolean acceptEmpty = !pageResources.getComponentModel().handlesEvent("activate") && activationContext.getCount() == 0;
        boolean checkUnknown = this.metaDataLocator.findMeta("tapestry.unknwon-activation-context-check", pageResources, Boolean.class);
        if (!handled && !acceptEmpty && checkUnknown && !pageResources.getComponentModel().handleActivationEventContext()) {
            this.logger.info("Page {} required an exact activation context, let's handle this", (Object)pageResources.getPageName());
            this.unknownActivationContextHandler.handleUnknownContext(pageResources, activationContext);
            return true;
        }
        if (callback.isAborted()) {
            callback.rethrow();
            return true;
        }
        if ("true".equals(pageResources.getComponentModel().getMeta("restEndpointEventHandlerMethodsPresent"))) {
            callback = new ComponentResultProcessorWrapper(resultProcessor);
            handled = pageResources.triggerContextEvent("http" + this.request.getMethod(), activationContext, callback);
            if (callback.isAborted()) {
                callback.rethrow();
                return true;
            }
            throw new RestEndpointNotFoundException(String.format("Page %s (%s) has at least one REST endpoint event handler method but none handled %s for this request", pageResources.getPageName(), pageResources.getPage().getClass().getName(), this.request.getMethod()));
        }
        return false;
    }
}

