/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.commons.ObjectProvider;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Core;

public class AssetObjectProvider
implements ObjectProvider {
    private final AssetSource source;
    private final TypeCoercer typeCoercer;
    private final SymbolSource symbolSource;

    public AssetObjectProvider(@Core AssetSource source, @Builtin TypeCoercer typeCoercer, @Builtin SymbolSource symbolSource) {
        this.source = source;
        this.typeCoercer = typeCoercer;
        this.symbolSource = symbolSource;
    }

    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        Path path = (Path)annotationProvider.getAnnotation(Path.class);
        if (path == null) {
            return null;
        }
        String expanded = this.symbolSource.expandSymbols(path.value());
        Asset asset = this.source.getAsset(null, expanded, null);
        return (T)this.typeCoercer.coerce((Object)asset, objectType);
    }
}

