/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.Map;
import org.apache.tapestry5.internal.plastic.LocalVariableImpl;
import org.apache.tapestry5.internal.plastic.NameCache;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.internal.plastic.asm.Label;
import org.apache.tapestry5.internal.plastic.asm.MethodVisitor;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.plastic.LocalVariable;
import org.apache.tapestry5.plastic.MethodDescription;

public class InstructionBuilderState
implements Opcodes {
    final MethodDescription description;
    final MethodVisitor visitor;
    final NameCache nameCache;
    int localIndex;
    int varSuffix;
    final Map<LocalVariable, LVInfo> locals = PlasticInternalUtils.newMap();
    final int[] argumentIndex;
    final int[] argumentLoadOpcode;

    protected InstructionBuilderState(MethodDescription description, MethodVisitor visitor, NameCache nameCache) {
        this.description = description;
        this.visitor = visitor;
        this.nameCache = nameCache;
        int argCount = description.argumentTypes.length;
        this.argumentIndex = new int[argCount];
        this.argumentLoadOpcode = new int[argCount];
        int offset = 1;
        for (int i = 0; i < argCount; ++i) {
            PrimitiveType type = PrimitiveType.getByName(description.argumentTypes[i]);
            this.argumentIndex[i] = offset++;
            int n = this.argumentLoadOpcode[i] = type == null ? 25 : type.loadOpcode;
            if (type == null || !type.isWide()) continue;
            ++offset;
        }
        this.localIndex = offset;
    }

    Label newLabel() {
        Label result = new Label();
        this.visitor.visitLabel(result);
        return result;
    }

    LocalVariable startVariable(String type) {
        Label start = this.newLabel();
        Label end = new Label();
        PrimitiveType ptype = PrimitiveType.getByName(type);
        int width = ptype != null && ptype.isWide() ? 2 : 1;
        int loadOpcode = ptype == null ? 25 : ptype.loadOpcode;
        int storeOpcode = ptype == null ? 58 : ptype.storeOpcode;
        LVInfo info = new LVInfo(width, this.localIndex, loadOpcode, storeOpcode, end);
        this.localIndex += width;
        LocalVariableImpl var = new LocalVariableImpl(type);
        this.locals.put(var, info);
        this.visitor.visitLocalVariable(this.nextVarName(), this.nameCache.toDesc(type), null, start, end, info.offset);
        return var;
    }

    void load(LocalVariable var) {
        LVInfo info = this.locals.get(var);
        this.visitor.visitVarInsn(info.loadOpcode, info.offset);
    }

    void store(LocalVariable var) {
        LVInfo info = this.locals.get(var);
        this.visitor.visitVarInsn(info.storeOpcode, info.offset);
    }

    void stopVariable(LocalVariable variable) {
        LVInfo info = this.locals.get(variable);
        this.visitor.visitLabel(info.end);
        this.locals.remove(variable);
        this.localIndex -= info.width;
    }

    private String nextVarName() {
        return "var" + this.varSuffix++;
    }

    static class LVInfo {
        final int width;
        final int offset;
        final int loadOpcode;
        final int storeOpcode;
        final Label end;

        public LVInfo(int width, int offset, int loadOpcode, int storeOpcode, Label end) {
            this.width = width;
            this.offset = offset;
            this.loadOpcode = loadOpcode;
            this.storeOpcode = storeOpcode;
            this.end = end;
        }
    }
}

