/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.csv;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.storm.sql.runtime.IOutputSerializer;

public class CsvSerializer
implements IOutputSerializer,
Serializable {
    private final List<String> fields;

    public CsvSerializer(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public ByteBuffer write(List<Object> data, ByteBuffer buffer) {
        try {
            StringWriter writer = new StringWriter();
            CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.RFC4180);
            for (Object o : data) {
                printer.print(o);
            }
            return ByteBuffer.wrap(writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

