/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.maven.mojos.apis.ApisJarContext;
import org.apache.sling.feature.maven.mojos.apis.ApisUtil;
import org.apache.sling.feature.maven.mojos.apis.ArtifactType;

public class RegionSupport {
    private final Log log;
    private final boolean incrementalApis;
    private final Set<String> includeRegions;
    private final Set<String> excludeRegions;
    private final boolean toggleApiOnly;

    public RegionSupport(Log logger, boolean incrementalApis, boolean toggleApiOnly, Set<String> includeRegions, Set<String> excludeRegions) {
        this.log = logger;
        this.incrementalApis = incrementalApis;
        this.includeRegions = includeRegions;
        this.excludeRegions = excludeRegions;
        this.toggleApiOnly = toggleApiOnly;
    }

    public ApiRegions getApiRegions(Feature feature) throws MojoExecutionException {
        ApiRegions sourceRegions;
        ApiRegions regions = new ApiRegions();
        try {
            sourceRegions = ApiRegions.getApiRegions((Feature)feature);
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException(iae.getMessage(), (Exception)iae);
        }
        if (sourceRegions != null) {
            for (ApiRegion r : sourceRegions.listRegions()) {
                if (r.getParent() != null && !this.incrementalApis) {
                    for (ApiExport exp : r.getParent().listExports()) {
                        r.add(exp);
                    }
                }
                if (!this.isRegionIncluded(r.getName())) continue;
                this.log.debug((CharSequence)("API Region " + r.getName() + " will not processed due to the configured include/exclude list"));
                regions.add(r);
            }
            if (regions.isEmpty()) {
                this.log.info((CharSequence)("Feature file " + feature.getId().toMvnId() + " has no included api regions, no API JAR will be created"));
                regions = null;
            }
        } else {
            regions.add(new ApiRegion("global"){

                public ApiExport getExportByName(String name) {
                    ApiExport exp = super.getExportByName(name);
                    if (exp == null) {
                        exp = new ApiExport(name);
                        this.add(exp);
                    }
                    return exp;
                }
            });
        }
        return regions;
    }

    private boolean isRegionIncluded(String name) {
        boolean included = false;
        for (String i : this.includeRegions) {
            if (!"*".equals(i) && !i.equals(name)) continue;
            included = true;
            break;
        }
        if (included && this.excludeRegions != null) {
            for (String e : this.excludeRegions) {
                if (!name.equals(e)) continue;
                included = false;
                break;
            }
        }
        return included;
    }

    public List<ApiExport> getAllExports(ApiRegion region, Set<String> enabledToggles) {
        ArrayList<ApiExport> result = new ArrayList<ApiExport>();
        for (ApiExport exp : region.listExports()) {
            if (!this.include(exp, enabledToggles)) continue;
            result.add(exp);
        }
        return result;
    }

    private boolean include(ApiExport exp, Set<String> enabledToggles) {
        boolean include;
        boolean bl = include = !this.toggleApiOnly;
        if (this.toggleApiOnly) {
            include = exp.getToggle() != null && enabledToggles.contains(exp.getToggle());
        } else if (exp.getToggle() != null && !enabledToggles.contains(exp.getToggle()) && exp.getPreviousArtifactId() == null) {
            include = false;
        }
        return include;
    }

    public Set<String> computeAllUsedExportPackages(ApiRegions apiRegions, Set<String> enabledToggles, Clause[] exportedPackages, Artifact bundle) throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        for (Clause exportedPackage : exportedPackages) {
            String packageName = exportedPackage.getName();
            for (ApiRegion apiRegion : apiRegions.listRegions()) {
                ApiExport exp = apiRegion.getExportByName(packageName);
                if (exp == null || !this.include(exp, enabledToggles)) continue;
                result.add(exportedPackage.getName());
            }
        }
        result.removeAll(ApisUtil.getIgnoredPackages(bundle));
        return result;
    }

    public Set<Clause> computeUsedExportPackagesPerRegion(ApiRegion apiRegion, Clause[] exportedPackages, Set<String> allPackages) throws MojoExecutionException {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Clause exportedPackage : exportedPackages) {
            ApiExport exp;
            String packageName = exportedPackage.getName();
            if (!allPackages.contains(packageName) || (exp = apiRegion.getExportByName(packageName)) == null) continue;
            result.add(exportedPackage);
        }
        return result;
    }

    public Clause[] getExportedPackages(Manifest manifest) {
        String exportPackageHeader = manifest.getMainAttributes().getValue("Export-Package");
        Clause[] exportPackages = Parser.parseHeader((String)exportPackageHeader);
        return exportPackages;
    }

    public Manifest getManifest(ArtifactId artifactId, File bundleFile) throws MojoExecutionException {
        Manifest manifest;
        JarInputStream jis = new JarInputStream(new FileInputStream(bundleFile));
        try {
            this.log.debug((CharSequence)("Reading Manifest headers from bundle " + bundleFile));
            Manifest manifest2 = jis.getManifest();
            if (manifest2 == null) {
                throw new MojoExecutionException("Artifact + " + artifactId.toMvnId() + " does not  have a manifest.");
            }
            manifest = manifest2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading manifest from file " + bundleFile + " for artifact " + artifactId.toMvnId(), (Exception)e);
            }
        }
        jis.close();
        return manifest;
    }

    public Set<Clause> getAllPublicPackages(ApisJarContext ctx, Artifact artifact, File artifactFile) throws MojoExecutionException {
        LinkedHashSet<Clause> packages = new LinkedHashSet<Clause>();
        Manifest manifest = this.getManifest(artifact.getId(), artifactFile);
        if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
            for (Clause c : this.getExportedPackages(manifest)) {
                packages.add(c);
            }
        } else {
            Set<String> names = ApisUtil.getPackages(ctx, artifactFile, ArtifactType.APIS.getContentExtension()).getKey();
            for (String n : names) {
                packages.add(new Clause(n, null, null));
            }
        }
        return packages;
    }

    public String calculateOmitDependenciesFlag(ApiRegion region, Clause[] exportedPackageClauses, Set<Clause> usedExportedPackagesPerRegion) {
        String reason = null;
        for (Clause c : exportedPackageClauses) {
            boolean found = false;
            for (Clause current : usedExportedPackagesPerRegion) {
                if (!current.getName().equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                String msg = "Package ".concat(c.getName()).concat(" not exported.");
                reason = reason == null ? msg : reason.concat(" ").concat(msg);
                continue;
            }
            ApiExport exp = region.getAllExportByName(c.getName());
            if (exp == null || exp.getDeprecation().getPackageInfo() == null && exp.getDeprecation().getMemberInfos().isEmpty()) continue;
            String msg = "Package (or parts) ".concat(c.getName()).concat(" marked as deprecated.");
            reason = reason == null ? msg : reason.concat(" ").concat(msg);
        }
        return reason;
    }
}

