/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.jackrabbit.core.query.lucene.RangeScan;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexMigration {
    private static final Logger log = LoggerFactory.getLogger(IndexMigration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(PersistentIndex index, DirectoryManager directoryManager, char oldSeparatorChar) throws IOException {
        Directory indexDir = index.getDirectory();
        log.debug("Checking {} ...", (Object)indexDir);
        ReadOnlyIndexReader reader = index.getReadOnlyIndexReader();
        try {
            if (IndexFormatVersion.getVersion((IndexReader)reader).getVersion() >= IndexFormatVersion.V3.getVersion()) {
                log.debug("IndexFormatVersion >= V3, no migration needed");
                return;
            }
            TermEnum terms = reader.terms(new Term(FieldNames.PROPERTIES, ""));
            try {
                Term t = terms.term();
                if (t.text().indexOf(oldSeparatorChar) == -1) {
                    log.debug("Index already migrated");
                    return;
                }
            }
            finally {
                terms.close();
            }
        }
        finally {
            reader.release();
            index.releaseWriterAndReaders();
        }
        log.debug("Index requires migration {}", (Object)indexDir);
        String migrationName = index.getName() + "_v2.3";
        if (directoryManager.hasDirectory(migrationName)) {
            directoryManager.delete(migrationName);
        }
        Directory migrationDir = directoryManager.getDirectory(migrationName);
        try {
            IndexWriter writer = new IndexWriter(migrationDir, (Analyzer)new JackrabbitAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            try {
                MigrationIndexReader r = new MigrationIndexReader(IndexReader.open((Directory)index.getDirectory()), oldSeparatorChar);
                try {
                    writer.addIndexes(new IndexReader[]{r});
                    writer.close();
                }
                finally {
                    r.close();
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            migrationDir.close();
        }
        directoryManager.delete(index.getName());
        if (!directoryManager.rename(migrationName, index.getName())) {
            throw new IOException("failed to move migrated directory " + migrationDir);
        }
        log.info("Migrated " + index.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ChainedTermEnum
    extends TermEnum {
        private Queue<TermEnum> queue = new LinkedList<TermEnum>();

        public ChainedTermEnum(Collection<TermEnum> enums) {
            this.queue.addAll(enums);
        }

        public boolean next() throws IOException {
            TermEnum terms;
            boolean newEnum = false;
            while ((terms = this.queue.peek()) != null) {
                if (newEnum && terms.term() != null) {
                    return true;
                }
                if (terms.next()) {
                    return true;
                }
                this.queue.remove();
                terms.close();
                newEnum = true;
            }
            return false;
        }

        public Term term() {
            TermEnum terms = this.queue.peek();
            if (terms != null) {
                return terms.term();
            }
            return null;
        }

        public int docFreq() {
            TermEnum terms = this.queue.peek();
            if (terms != null) {
                return terms.docFreq();
            }
            return 0;
        }

        public void close() throws IOException {
            while (!this.queue.isEmpty()) {
                this.queue.remove().close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MigrationIndexReader
    extends FilterIndexReader {
        private final char oldSepChar;

        public MigrationIndexReader(IndexReader in, char oldSepChar) {
            super(in);
            this.oldSepChar = oldSepChar;
        }

        public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
            Document doc = super.document(n, fieldSelector);
            Fieldable[] fields = doc.getFieldables(FieldNames.PROPERTIES);
            if (fields != null) {
                doc.removeFields(FieldNames.PROPERTIES);
                for (Fieldable field : fields) {
                    String value = field.stringValue();
                    value = value.replace(this.oldSepChar, '[');
                    doc.add((Fieldable)new Field(FieldNames.PROPERTIES, value, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                }
            }
            return doc;
        }

        public TermEnum terms() throws IOException {
            ArrayList<TermEnum> enums = new ArrayList<TermEnum>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Object obj : this.in.getFieldNames(IndexReader.FieldOption.ALL)) {
                fieldNames.add((String)obj);
            }
            Collections.sort(fieldNames);
            for (String fieldName : fieldNames) {
                if (fieldName.equals(FieldNames.PROPERTIES)) {
                    this.addPropertyTerms(enums);
                    continue;
                }
                enums.add((TermEnum)new RangeScan(this.in, new Term(fieldName, ""), new Term(fieldName, "\uffff")));
            }
            return new MigrationTermEnum(new ChainedTermEnum(enums), this.oldSepChar);
        }

        public TermPositions termPositions() throws IOException {
            return new MigrationTermPositions(this.in.termPositions(), this.oldSepChar);
        }

        private void addPropertyTerms(List<TermEnum> enums) throws IOException {
            TreeMap<String, RangeScan> termEnums = new TreeMap<String, RangeScan>(new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    s1 = s1.replace(MigrationIndexReader.this.oldSepChar, '[');
                    s2 = s2.replace(MigrationIndexReader.this.oldSepChar, '[');
                    return s1.compareTo(s2);
                }
            });
            RangeScan terms = new RangeScan(this.in, new Term(FieldNames.PROPERTIES, ""), new Term(FieldNames.PROPERTIES, "\uffff"));
            String previous = null;
            while (terms.next()) {
                Term t = terms.term();
                String name = t.text().substring(0, t.text().indexOf(this.oldSepChar) + 1);
                if (!name.equals(previous)) {
                    termEnums.put(name, new RangeScan(this.in, new Term(FieldNames.PROPERTIES, name), new Term(FieldNames.PROPERTIES, name + "\uffff")));
                }
                previous = name;
            }
            enums.addAll(termEnums.values());
        }

        private static class MigrationTermPositions
        extends FilterIndexReader.FilterTermPositions {
            private final char oldSepChar;

            public MigrationTermPositions(TermPositions in, char oldSepChar) {
                super(in);
                this.oldSepChar = oldSepChar;
            }

            public void seek(Term term) throws IOException {
                if (term.field().equals(FieldNames.PROPERTIES)) {
                    char[] text = term.text().toCharArray();
                    text[term.text().indexOf((int)91)] = this.oldSepChar;
                    super.seek(term.createTerm(new String(text)));
                } else {
                    super.seek(term);
                }
            }

            public void seek(TermEnum termEnum) throws IOException {
                if (termEnum instanceof MigrationTermEnum) {
                    super.seek(((MigrationTermEnum)termEnum).unwrap());
                } else {
                    super.seek(termEnum);
                }
            }
        }

        private static class MigrationTermEnum
        extends FilterIndexReader.FilterTermEnum {
            private final char oldSepChar;

            public MigrationTermEnum(TermEnum in, char oldSepChar) {
                super(in);
                this.oldSepChar = oldSepChar;
            }

            public Term term() {
                Term t = super.term();
                if (t == null) {
                    return t;
                }
                if (t.field().equals(FieldNames.PROPERTIES)) {
                    String text = t.text();
                    return t.createTerm(text.replace(this.oldSepChar, '['));
                }
                return t;
            }

            TermEnum unwrap() {
                return this.in;
            }
        }
    }
}

