/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.notifications;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.jobs.Job;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class NotificationUtility {
    public static final String PROPERTY_TIME = ":time";

    public static void sendNotification(EventAdmin eventAdmin, String eventTopic, Job job, Long time) {
        if (eventAdmin != null) {
            JobImpl jobCopy = new JobImpl(job.getTopic(), job.getId(), ((JobImpl)job).getProperties());
            NotificationUtility.sendNotificationInternal(eventAdmin, eventTopic, jobCopy, time);
        }
    }

    private static void sendNotificationInternal(EventAdmin eventAdmin, String eventTopic, Job job, Long time) {
        Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
        ((Dictionary)eventProps).put("slingevent:eventId", job.getId());
        ((Dictionary)eventProps).put("event.job.topic", job.getTopic());
        for (String name : job.getPropertyNames()) {
            ((Dictionary)eventProps).put(name, job.getProperty(name));
        }
        ((Dictionary)eventProps).remove(":sling:jobs:asynchandler");
        ((Dictionary)eventProps).put("timestamp", System.currentTimeMillis());
        if (time != null) {
            ((Dictionary)eventProps).put(PROPERTY_TIME, time);
        }
        eventAdmin.postEvent(new Event(eventTopic, eventProps));
    }
}

