/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.readability;

import java.util.List;
import org.apache.sling.cms.readability.Word;

public class Sentence {
    private final String text;
    private final List<Word> words;

    public Sentence(String text, List<Word> words) {
        this.text = text;
        this.words = words;
    }

    public int getCharacterCount() {
        return this.words.stream().map(Word::getCharacters).mapToInt(i -> i).sum();
    }

    public int getComplexWordCount() {
        return (int)this.words.stream().filter(Word::isComplex).count();
    }

    public int getSyllableCount() {
        return this.words.stream().map(Word::getSylables).mapToInt(i -> i).sum();
    }

    public String getText() {
        return this.text;
    }

    public int getWordCount() {
        return this.words.size();
    }

    public List<Word> getWords() {
        return this.words;
    }

    public String toString() {
        return "Sentence [text=" + this.text + ", words=" + this.words + ", getCharacterCount()=" + this.getCharacterCount() + ", getComplexWordCount()=" + this.getComplexWordCount() + ", getSyllableCount()=" + this.getSyllableCount() + ", getWordCount()=" + this.getWordCount() + "]";
    }
}

