/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.ConfigurationResolver;
import org.apache.sling.caconfig.impl.ConfigurationBuilderImpl;
import org.apache.sling.caconfig.management.ConfigurationResourceResolverConfig;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationInheritanceStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationMetadataProviderMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationPersistenceStrategyMultiplexer;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationResourceResolvingStrategyMultiplexer;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ConfigurationResolver.class, ConfigurationResourceResolverConfig.class}, immediate=true)
@Designate(ocd=Config.class)
public class ConfigurationResolverImpl
implements ConfigurationResolver,
ConfigurationResourceResolverConfig {
    @Reference
    private ConfigurationResourceResolvingStrategyMultiplexer configurationResourceResolvingStrategy;
    @Reference
    private ConfigurationPersistenceStrategyMultiplexer configurationPersistenceStrategy;
    @Reference
    private ConfigurationInheritanceStrategyMultiplexer configurationInheritanceStrategy;
    @Reference
    private ConfigurationOverrideMultiplexer configurationOverrideMultiplexer;
    @Reference
    private ConfigurationMetadataProviderMultiplexer configurationMetadataProvider;
    private Collection<String> configBucketNames;

    @Activate
    private void activate(Config config) {
        this.configBucketNames = new ArrayList<String>();
        this.configBucketNames.add("sling:configs");
        if (!ArrayUtils.isEmpty((Object[])config.configBucketNames())) {
            this.configBucketNames.addAll(Arrays.asList(config.configBucketNames()));
        }
    }

    @NotNull
    public ConfigurationBuilder get(@NotNull Resource resource) {
        return new ConfigurationBuilderImpl(resource, this, this.configurationResourceResolvingStrategy, this.configurationPersistenceStrategy, this.configurationInheritanceStrategy, this.configurationOverrideMultiplexer, this.configurationMetadataProvider, this.configBucketNames);
    }

    @Override
    @NotNull
    public Collection<String> configBucketNames() {
        return this.configBucketNames;
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Resolver", description="Getting context-aware configurations for a given resource context.")
    static @interface Config {
        @AttributeDefinition(name="Config bucket names", description="Additional bucket resource names to 'sling:configs' to store configuration resources. The names are used in the order defined, always starting with sling:configs. Once a bucket resource with a matching name is found, that bucket is used and the following names are skipped. For writeback via ConfigurationManager always sling:configs is used.")
        public String[] configBucketNames();
    }
}

