/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.ide.artifacts.EmbeddedBundle;
import org.apache.sling.ide.artifacts.EmbeddedBundleLocator;
import org.apache.sling.ide.eclipse.core.EclipseResources;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.ServerUtil;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.core.internal.JVMDebuggerConnection;
import org.apache.sling.ide.eclipse.core.internal.JarBuilder;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.core.internal.ServerBehaviourDelegateWithModulePublishSupport;
import org.apache.sling.ide.eclipse.core.internal.SlingLaunchpadServer;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.osgi.OsgiClient;
import org.apache.sling.ide.osgi.OsgiClientException;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.sync.content.SyncCommandFactory;
import org.apache.sling.ide.transport.Batcher;
import org.apache.sling.ide.transport.Command;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryInfo;
import org.apache.sling.ide.transport.RepositoryPath;
import org.apache.sling.ide.transport.Result;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.osgi.framework.Version;

public class SlingLaunchpadBehaviour
extends ServerBehaviourDelegateWithModulePublishSupport {
    private SyncCommandFactory commandFactory;
    private ILaunch launch;
    private JVMDebuggerConnection debuggerConnection;

    public void stop(boolean force) {
        if (this.debuggerConnection != null) {
            this.debuggerConnection.stop(force);
        }
        this.setServerState(4);
        try {
            ServerUtil.stopRepository(this.getServer(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().getPluginLogger().warn("Failed to stop repository", (Throwable)e);
        }
    }

    public void start(IProgressMonitor monitor) throws CoreException {
        block25: {
            RepositoryInfo repositoryInfo;
            Repository repository;
            boolean success = false;
            Result result = null;
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Starting server", (int)10).setWorkRemaining(50);
            try {
                repository = ServerUtil.connectRepository(this.getServer(), monitor);
                repositoryInfo = ServerUtil.getRepositoryInfo(this.getServer(), monitor);
            }
            catch (CoreException e) {
                this.setServerState(4);
                throw e;
            }
            catch (URISyntaxException e) {
                this.setServerState(4);
                throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e.getMessage(), (Throwable)e));
            }
            monitor.worked(10);
            try {
                try {
                    Throwable e = null;
                    Object var7_11 = null;
                    try (OsgiClient client = Activator.getDefault().getOsgiClientFactory().createOsgiClient(repositoryInfo);){
                        try {
                            EmbeddedBundleLocator bundleLocator = Activator.getDefault().getEmbeddedBundleLocator();
                            this.installBundle(monitor, client, bundleLocator.getBundle("org.apache.sling.tooling.support.source"));
                            this.installBundle(monitor, client, bundleLocator.getBundle("org.apache.sling.tooling.support.install"));
                        }
                        catch (IOException | OsgiClientException e2) {
                            Activator.getDefault().getPluginLogger().warn("Failed reading the installation support bundle", e2);
                        }
                        try {
                            if (this.getServer().getMode().equals("debug")) {
                                this.debuggerConnection = new JVMDebuggerConnection(client);
                                success = this.debuggerConnection.connectInDebugMode(this.launch, this.getServer(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)30));
                            } else {
                                Command command = repository.newListChildrenNodeCommand(new RepositoryPath("/"));
                                result = command.execute();
                                success = result.isSuccess();
                                monitor.worked(30);
                            }
                            if (success) {
                                this.setServerState(2);
                                break block25;
                            }
                            this.setServerState(4);
                            Object message = "Unable to connect to the Server. Please make sure a server instance is running ";
                            if (result != null) {
                                message = (String)message + " (" + result.toString() + ")";
                            }
                            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", (String)message));
                        }
                        catch (RuntimeException | CoreException e3) {
                            this.setServerState(4);
                            throw e3;
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Error closing OSGi client", (Throwable)e1));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void installBundle(IProgressMonitor monitor, OsgiClient client, EmbeddedBundle bundle) throws OsgiClientException, IOException {
        monitor.setTaskName("Installing " + bundle.getBundleSymbolicName() + " " + String.valueOf(bundle.getVersion()));
        Version remoteVersion = client.getBundleVersion(bundle.getBundleSymbolicName());
        monitor.worked(2);
        ISlingLaunchpadServer launchpadServer = (ISlingLaunchpadServer)this.getServer().loadAdapter(SlingLaunchpadServer.class, monitor);
        if (remoteVersion == null || remoteVersion.compareTo(bundle.getVersion()) < 0 || remoteVersion.equals((Object)bundle.getVersion()) && "SNAPSHOT".equals(bundle.getVersion().getQualifier())) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream contents = bundle.openInputStream();){
                client.installBundle(contents, bundle.getBundleSymbolicName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            remoteVersion = bundle.getVersion();
        }
        launchpadServer.setBundleVersion(bundle.getBundleSymbolicName(), remoteVersion, monitor);
        monitor.worked(3);
    }

    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        block11: {
            Logger logger = Activator.getDefault().getPluginLogger();
            if (this.commandFactory == null) {
                this.commandFactory = Activator.getDefault().getCommandFactory();
            }
            logger.trace(this.traceOperation(kind, deltaKind, module), new Object[0]);
            if (this.getServer().getServerState() == 4) {
                logger.trace("Ignoring request to publish module when the server is stopped", new Object[0]);
                this.setModulePublishState(module, 1);
                return;
            }
            if ((kind == 3 || kind == 1) && deltaKind == 0) {
                logger.trace("Ignoring request to publish the module when no resources have changed; most likely another module has changed", new Object[0]);
                this.setModulePublishState(module, 1);
                return;
            }
            if (kind == 2 && deltaKind == 3) {
                logger.trace("Ignoring request to unpublish all of the module resources", new Object[0]);
                this.setModulePublishState(module, 1);
                return;
            }
            try {
                if (ProjectHelper.isBundleProject(module[0].getProject())) {
                    String serverMode = this.getServer().getMode();
                    if (!serverMode.equals("debug") || kind == 4) {
                        this.publishBundleModule(module, monitor);
                    }
                    break block11;
                }
                if (!ProjectHelper.isContentProject(module[0].getProject())) break block11;
                try {
                    this.publishContentModule(kind, deltaKind, module, monitor);
                }
                catch (SerializationException e) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Serialization error for " + this.traceOperation(kind, deltaKind, module).toString(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "IO error for " + this.traceOperation(kind, deltaKind, module).toString(), (Throwable)e));
                }
            }
            catch (CoreException e) {
                this.setModulePublishState(module, 3);
                throw e;
            }
        }
    }

    private String traceOperation(int kind, int deltaKind, IModule[] module) {
        StringBuilder trace = new StringBuilder();
        trace.append("SlingLaunchpadBehaviour.publishModule(");
        switch (kind) {
            case 4: {
                trace.append("PUBLISH_CLEAN, ");
                break;
            }
            case 1: {
                trace.append("PUBLISH_INCREMENTAL, ");
                break;
            }
            case 3: {
                trace.append("PUBLISH_AUTO, ");
                break;
            }
            case 2: {
                trace.append("PUBLISH_FULL, ");
                break;
            }
            default: {
                trace.append("UNKNOWN - ").append(kind).append(", ");
            }
        }
        switch (deltaKind) {
            case 1: {
                trace.append("ADDED, ");
                break;
            }
            case 2: {
                trace.append("CHANGED, ");
                break;
            }
            case 0: {
                trace.append("NO_CHANGE, ");
                break;
            }
            case 3: {
                trace.append("REMOVED, ");
                break;
            }
            default: {
                trace.append("UNKONWN - ").append(deltaKind).append(", ");
            }
        }
        switch (this.getServer().getServerState()) {
            case 2: {
                trace.append("STARTED, ");
                break;
            }
            case 1: {
                trace.append("STARTING, ");
                break;
            }
            case 4: {
                trace.append("STOPPED, ");
                break;
            }
            case 3: {
                trace.append("STOPPING, ");
                break;
            }
            default: {
                trace.append("UNKONWN - ").append(this.getServer().getServerState()).append(", ");
            }
        }
        trace.append(Arrays.toString(module)).append(")");
        return trace.toString();
    }

    /*
     * Loose catch block
     */
    private void publishBundleModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        block33: {
            IProject project = module[0].getProject();
            boolean installLocally = this.getServer().getAttribute("launchpad.installLocally", true);
            monitor.beginTask("deploying via local install", 5);
            try {
                IPath outputLocation;
                IFolder outputFolder;
                OsgiClient osgiClient;
                Throwable throwable;
                block30: {
                    block31: {
                        throwable = null;
                        Object var6_9 = null;
                        osgiClient = Activator.getDefault().getOsgiClientFactory().createOsgiClient(ServerUtil.getRepositoryInfo(this.getServer(), monitor));
                        Version supportBundleVersion = osgiClient.getBundleVersion("org.apache.sling.tooling.support.install");
                        monitor.worked(1);
                        if (supportBundleVersion == null) {
                            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "The support bundle was not found, please install it via the server properties page."));
                        }
                        IJavaProject javaProject = ProjectHelper.asJavaProject(project);
                        outputFolder = (IFolder)project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
                        outputLocation = outputFolder.getLocation();
                        IResource manifest = outputFolder.findMember("META-INF/MANIFEST.MF");
                        if (manifest != null) break block30;
                        Activator.getDefault().getPluginLogger().warn("Project " + String.valueOf(project) + " does not have a META-INF/MANIFEST.MF (yet) - not publishing this time");
                        monitor.done();
                        this.setModulePublishState(module, 3);
                        if (osgiClient == null) break block31;
                        osgiClient.close();
                    }
                    return;
                }
                try {
                    try {
                        monitor.worked(1);
                        if (installLocally) {
                            osgiClient.installBundle(outputLocation.toFile().toPath());
                            monitor.worked(3);
                        } else {
                            JarBuilder builder = new JarBuilder(outputFolder);
                            monitor.worked(1);
                            Throwable throwable2 = null;
                            Object var15_20 = null;
                            try (InputStream bundleInput = builder.buildJar();){
                                osgiClient.installBundle(bundleInput, builder.getBundleSymbolicName());
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            monitor.worked(2);
                        }
                        this.setModulePublishState(module, 1);
                        break block33;
                        {
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                        }
                        finally {
                            if (osgiClient != null) {
                                osgiClient.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | URISyntaxException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", e1.getMessage(), (Throwable)e1));
                }
                catch (OsgiClientException e1) {
                    throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed installing bundle : " + e1.getMessage(), (Throwable)e1));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void publishContentModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException, SerializationException, IOException {
        IModuleResource resource2;
        Logger logger = Activator.getDefault().getPluginLogger();
        Repository repository = ServerUtil.getConnectedRepository(this.getServer(), monitor);
        if (repository == null) {
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Unable to find a repository for server " + String.valueOf(this.getServer())));
        }
        Batcher batcher = Activator.getDefault().getBatcherFactory().createBatcher();
        ArrayList<IModuleResource> addedOrUpdatedResources = new ArrayList<IModuleResource>();
        IModuleResource[] allResources = this.getResources(module);
        HashSet<IPath> handledPaths = new HashSet<IPath>();
        switch (deltaKind) {
            case 2: {
                IModuleResourceDelta[] iModuleResourceDeltaArray = this.getPublishedResourceDelta(module);
                int n = iModuleResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModuleResourceDelta resourceDelta = iModuleResourceDeltaArray[n2];
                    StringBuilder deltaTrace = new StringBuilder();
                    deltaTrace.append("- processing delta kind ");
                    switch (resourceDelta.getKind()) {
                        case 1: {
                            deltaTrace.append("ADDED ");
                            break;
                        }
                        case 2: {
                            deltaTrace.append("CHANGED ");
                            break;
                        }
                        case 0: {
                            deltaTrace.append("NO_CHANGE ");
                            break;
                        }
                        case 3: {
                            deltaTrace.append("REMOVED ");
                            break;
                        }
                        default: {
                            deltaTrace.append("UNKNOWN - ").append(resourceDelta.getKind());
                        }
                    }
                    deltaTrace.append("for resource ").append(resourceDelta.getModuleResource());
                    logger.trace(deltaTrace.toString(), new Object[0]);
                    switch (resourceDelta.getKind()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Command<?> command = this.addFileCommand(repository, resourceDelta.getModuleResource());
                            if (command != null) {
                                this.ensureParentIsPublished(resourceDelta.getModuleResource(), repository, allResources, handledPaths, batcher);
                                addedOrUpdatedResources.add(resourceDelta.getModuleResource());
                            }
                            this.enqueue(batcher, command);
                            break;
                        }
                        case 3: {
                            this.enqueue(batcher, this.removeFileCommand(repository, resourceDelta.getModuleResource()));
                        }
                    }
                    ++n2;
                }
                break;
            }
            case 0: 
            case 1: {
                IModuleResourceDelta[] iModuleResourceDeltaArray = this.getResources(module);
                int n = iModuleResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    resource2 = iModuleResourceDeltaArray[n2];
                    Command<?> command = this.addFileCommand(repository, resource2);
                    this.enqueue(batcher, command);
                    if (command != null) {
                        addedOrUpdatedResources.add(resource2);
                    }
                    ++n2;
                }
                break;
            }
            case 3: {
                IModuleResourceDelta[] iModuleResourceDeltaArray = this.getResources(module);
                int n = iModuleResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    resource2 = iModuleResourceDeltaArray[n2];
                    this.enqueue(batcher, this.removeFileCommand(repository, resource2));
                    ++n2;
                }
                break;
            }
        }
        for (IModuleResource resource2 : addedOrUpdatedResources) {
            this.enqueue(batcher, this.reorderChildNodesCommand(repository, resource2));
        }
        this.execute(batcher);
        super.publishModule(kind, deltaKind, module, monitor);
        this.setModulePublishState(module, 1);
    }

    private void execute(Batcher batcher) throws CoreException {
        for (Command command : batcher.get()) {
            Result result = command.execute();
            if (result.isSuccess()) continue;
            throw new CoreException((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", "Failed publishing path=" + String.valueOf(command.getPath()) + ", result=" + result.toString()));
        }
    }

    private void ensureParentIsPublished(IModuleResource moduleResource, Repository repository, IModuleResource[] allResources, Set<IPath> handledPaths, Batcher batcher) throws CoreException, SerializationException, IOException {
        Logger logger = Activator.getDefault().getPluginLogger();
        IPath currentPath = moduleResource.getModuleRelativePath();
        logger.trace("Ensuring that parent of path {0} is published", new Object[]{currentPath});
        if (currentPath.segmentCount() == 0) {
            logger.trace("Path {0} can not have a parent, skipping", new Object[]{currentPath});
            return;
        }
        IPath parentPath = currentPath.removeLastSegments(1);
        if (handledPaths.contains(parentPath)) {
            logger.trace("Parent path {0} was already handled, skipping", new Object[]{parentPath});
            return;
        }
        IModuleResource[] iModuleResourceArray = allResources;
        int n = allResources.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResource maybeParent = iModuleResourceArray[n2];
            if (maybeParent.getModuleRelativePath().equals((Object)parentPath)) {
                this.ensureParentIsPublished(maybeParent, repository, allResources, handledPaths, batcher);
                this.enqueue(batcher, this.addFileCommand(repository, maybeParent));
                handledPaths.add(maybeParent.getModuleRelativePath());
                logger.trace("Ensured that resource at path {0} is published", new Object[]{parentPath});
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Resource at " + String.valueOf(moduleResource.getModuleRelativePath()) + " has parent path " + String.valueOf(parentPath) + " but no resource with that path is in the module's resources.");
    }

    private void enqueue(Batcher batcher, Command<?> command) {
        if (command == null) {
            return;
        }
        batcher.add(command);
    }

    private Command<?> addFileCommand(Repository repository, IModuleResource resource) throws CoreException, SerializationException, IOException {
        IResource res = this.getResource(resource);
        if (res == null) {
            return null;
        }
        return this.commandFactory.newCommandForAddedOrUpdatedResource(repository, EclipseResources.create(res));
    }

    private Command<?> reorderChildNodesCommand(Repository repository, IModuleResource resource) throws CoreException, SerializationException, IOException {
        IResource res = this.getResource(resource);
        if (res == null) {
            return null;
        }
        return this.commandFactory.newReorderChildNodesCommand(repository, EclipseResources.create(res));
    }

    private IResource getResource(IModuleResource resource) {
        IResource file = (IResource)resource.getAdapter(IFile.class);
        if (file == null) {
            file = (IResource)resource.getAdapter(IFolder.class);
        }
        if (file == null) {
            Activator.getDefault().getPluginLogger().trace("Got null {0} and {1} for {2}", new Object[]{IFile.class.getSimpleName(), IFolder.class.getSimpleName(), resource});
            return null;
        }
        return file;
    }

    private Command<?> removeFileCommand(Repository repository, IModuleResource resource) throws SerializationException, IOException, CoreException {
        IResource deletedResource = this.getResource(resource);
        if (deletedResource == null) {
            return null;
        }
        return this.commandFactory.newCommandForRemovedResource(repository, EclipseResources.create(deletedResource));
    }
}

