/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sis.converter.Column;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.TreeTable;

final class FallbackConverter<S, T>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 6331789192804695560L;
    final ObjectConverter<S, ? extends T> primary;
    final ObjectConverter<S, ? extends T> fallback;

    private FallbackConverter(Class<S> sourceClass, Class<T> targetClass, ObjectConverter<S, ? extends T> primary, ObjectConverter<S, ? extends T> fallback) {
        super(sourceClass, targetClass);
        if (FallbackConverter.needSwap(primary, fallback.getClass())) {
            this.primary = fallback;
            this.fallback = primary;
        } else {
            this.primary = primary;
            this.fallback = fallback;
        }
    }

    private static <S> boolean needSwap(ObjectConverter<S, ?> primary, Class<?> fallbackClass) {
        if (primary instanceof FallbackConverter) {
            FallbackConverter candidate = (FallbackConverter)primary;
            return FallbackConverter.needSwap(candidate.primary, fallbackClass) && FallbackConverter.needSwap(candidate.fallback, fallbackClass);
        }
        Class<?> targetClass = primary.getTargetClass();
        return fallbackClass.isAssignableFrom(targetClass) && !targetClass.isAssignableFrom(fallbackClass);
    }

    public static <S, T> ObjectConverter<S, ? extends T> merge(ObjectConverter<S, ? extends T> primary, ObjectConverter<S, ? extends T> fallback) {
        Class<? extends T> target2;
        ArgumentChecks.ensureNonNull("primary", primary);
        ArgumentChecks.ensureNonNull("fallback", fallback);
        assert (!(fallback instanceof FallbackConverter)) : fallback;
        ObjectConverter<S, ? extends T> candidate = FallbackConverter.mergeIfSubtype(primary, fallback, null);
        if (candidate != null) {
            return candidate;
        }
        Class<S> source = primary.getSourceClass();
        Class<? extends T> target1 = primary.getTargetClass();
        Class<Object> target = Classes.findCommonClass(target1, target2 = fallback.getTargetClass());
        if (target == Object.class) {
            Set<Class<Class<S>>> interfaces = Classes.findCommonInterfaces(target1, target2);
            interfaces.removeAll(Arrays.asList(Classes.getAllInterfaces(source)));
            Iterator<Class<?>> it = interfaces.iterator();
            if (it.hasNext()) {
                target = it.next();
            }
        }
        assert (target.isAssignableFrom(target1)) : target1;
        assert (target.isAssignableFrom(target2)) : target2;
        FallbackConverter<S, ? extends T> converter = new FallbackConverter<S, T>(source, target, primary, fallback);
        return converter;
    }

    private static <S, T> ObjectConverter<S, ? extends T> mergeIfSubtype(ObjectConverter<S, T> branch, ObjectConverter<S, ?> converter, Class<? super T> parentTarget) {
        if (branch.equals(converter)) {
            return branch;
        }
        Class<T> targetClass = branch.getTargetClass();
        if (!targetClass.isAssignableFrom(converter.getTargetClass())) {
            return null;
        }
        ObjectConverter<S, ?> checked = converter;
        if (branch instanceof FallbackConverter) {
            return ((FallbackConverter)branch).merge(checked, parentTarget);
        }
        return new FallbackConverter<S, T>(branch.getSourceClass(), targetClass, branch, checked);
    }

    private ObjectConverter<S, ? extends T> merge(ObjectConverter<S, ? extends T> converter, Class<? super T> parentTarget) {
        ObjectConverter<S, ? extends T> newFallback;
        FallbackConverter newPrimary;
        ObjectConverter<S, ? extends T> candidate = FallbackConverter.mergeIfSubtype(this.fallback, converter, this.targetClass);
        if (candidate != null) {
            newPrimary = this.primary;
            newFallback = candidate;
        } else {
            candidate = FallbackConverter.mergeIfSubtype(this.primary, converter, this.targetClass);
            if (candidate != null) {
                newPrimary = candidate;
                newFallback = this.fallback;
            } else if (this.targetClass != parentTarget) {
                newPrimary = this;
                newFallback = converter;
            } else {
                return null;
            }
        }
        return new FallbackConverter<S, T>(this.sourceClass, this.targetClass, newPrimary, newFallback);
    }

    @Override
    public final Set<FunctionProperty> properties() {
        Set<FunctionProperty> properties = this.primary.properties();
        if (!(this.primary instanceof FallbackConverter)) {
            properties = EnumSet.copyOf(properties);
            properties.remove((Object)FunctionProperty.INVERTIBLE);
        }
        properties.retainAll(this.fallback.properties());
        return properties;
    }

    @Override
    public T apply(S source) throws UnconvertibleObjectException {
        try {
            return this.primary.apply(source);
        }
        catch (UnconvertibleObjectException exception) {
            try {
                return this.fallback.apply(source);
            }
            catch (UnconvertibleObjectException failure) {
                exception.addSuppressed(failure);
                throw exception;
            }
        }
    }

    private void toTree(ObjectConverter<?, ?> converter, TreeTable.Node addTo) {
        if (converter instanceof FallbackConverter) {
            boolean isNew;
            boolean bl = isNew = converter.getTargetClass() != this.targetClass;
            if (isNew) {
                addTo = addTo.newChild();
            }
            ((FallbackConverter)converter).toTree(addTo, isNew);
        } else {
            Column.toTree(converter, addTo);
        }
    }

    final void toTree(TreeTable.Node addTo, boolean isNew) {
        if (isNew) {
            addTo.setValue(Column.SOURCE, this.sourceClass);
            addTo.setValue(Column.TARGET, this.targetClass);
        }
        this.toTree(this.primary, addTo);
        this.toTree(this.fallback, addTo);
    }

    @Override
    public String toString() {
        TreeTable table = Column.createTable();
        this.toTree(table.getRoot(), true);
        return Column.format(table);
    }
}

