/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.Probabilistic;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleSequenceStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class NameFinderME
implements TokenNameFinder,
Probabilistic {
    private static final String[][] EMPTY = new String[0][0];
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    private final SequenceCodec<String> seqCodec;
    protected final SequenceClassificationModel model;
    protected final NameContextGenerator contextGenerator;
    private Sequence bestSequence;
    private final AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private final SequenceValidator<String> sequenceValidator;

    public NameFinderME(TokenNameFinderModel model) {
        TokenNameFinderFactory factory = model.getFactory();
        this.seqCodec = factory.createSequenceCodec();
        this.sequenceValidator = this.seqCodec.createSequenceValidator();
        this.model = model.getNameFinderSequenceModel();
        this.contextGenerator = factory.createContextGenerator();
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
    }

    @Override
    public Span[] find(String[] tokens) {
        return this.find(tokens, EMPTY);
    }

    public Span[] find(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.model.bestSequence(tokens, (Object[])additionalContext, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[0]));
        Span[] spans = this.seqCodec.decode(c);
        spans = this.setProbs(spans);
        return spans;
    }

    @Override
    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    @Override
    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    private Span[] setProbs(Span[] spans) {
        double[] probs = this.probs(spans);
        if (probs != null) {
            for (int i = 0; i < probs.length; ++i) {
                double prob = probs[i];
                spans[i] = new Span(spans[i], prob);
            }
        }
        return spans;
    }

    public double[] probs(Span[] spans) {
        double[] sprobs = new double[spans.length];
        double[] probs = this.bestSequence.getProbs();
        for (int si = 0; si < spans.length; ++si) {
            double p = 0.0;
            for (int oi = spans[si].getStart(); oi < spans[si].getEnd(); ++oi) {
                p += probs[oi];
            }
            sprobs[si] = p /= (double)spans[si].length();
        }
        return sprobs;
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters params, TokenNameFinderFactory factory) throws IOException {
        params.putIfAbsent("Algorithm", "PERCEPTRON");
        params.putIfAbsent("Cutoff", 0);
        params.putIfAbsent("Iterations", 300);
        int beamSize = params.getIntParameter("BeamSize", 3);
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        MaxentModel nameFinderModel = null;
        SequenceClassificationModel seqModel = null;
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(params);
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            NameFinderEventStream eventStream = new NameFinderEventStream(samples, type, factory.createContextGenerator(), factory.createSequenceCodec());
            EventTrainer trainer = TrainerFactory.getEventTrainer(params, manifestInfoEntries);
            nameFinderModel = trainer.train(eventStream);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, factory.createContextGenerator());
            EventModelSequenceTrainer<NameSample> trainer = TrainerFactory.getEventModelSequenceTrainer(params, manifestInfoEntries);
            nameFinderModel = trainer.train(ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(params, manifestInfoEntries);
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, factory.createContextGenerator(), false);
            seqModel = trainer.train(ss);
        } else {
            throw new IllegalStateException("Unexpected trainer type!");
        }
        if (seqModel != null) {
            return new TokenNameFinderModel(languageCode, seqModel, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
        }
        return new TokenNameFinderModel(languageCode, nameFinderModel, beamSize, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
    }

    static String extractNameType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Span[] dropOverlappingSpans(Span[] spans) {
        ArrayList sortedSpans = new ArrayList(spans.length);
        Collections.addAll(sortedSpans, spans);
        Collections.sort(sortedSpans);
        Iterator it = sortedSpans.iterator();
        Span lastSpan = null;
        while (it.hasNext()) {
            Span span = (Span)it.next();
            if (lastSpan != null && lastSpan.intersects(span)) {
                it.remove();
                span = lastSpan;
            }
            lastSpan = span;
        }
        return sortedSpans.toArray(new Span[0]);
    }
}

