/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceChooserAware;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryAware;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterAware;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFunction;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceLoadBalancer
extends ServiceSupport
implements CamelContextAware,
ServiceDiscoveryAware,
ServiceChooserAware,
ServiceFilterAware,
ServiceLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceLoadBalancer.class);
    private CamelContext camelContext;
    private ServiceDiscovery serviceDiscovery;
    private ServiceChooser serviceChooser;
    private ServiceFilter serviceFilter;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serverDiscovery) {
        this.serviceDiscovery = serverDiscovery;
    }

    public ServiceChooser getServiceChooser() {
        return this.serviceChooser;
    }

    public void setServiceChooser(ServiceChooser serverChooser) {
        this.serviceChooser = serverChooser;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camel context");
        ObjectHelper.notNull((Object)this.serviceDiscovery, (String)"service discovery");
        ObjectHelper.notNull((Object)this.serviceChooser, (String)"service chooser");
        ObjectHelper.notNull((Object)this.serviceFilter, (String)"service serviceFilter");
        LOGGER.info("ServiceCall is using default load balancer with service discovery type: {}, service filter type: {} and service chooser type: {}", new Object[]{this.serviceDiscovery.getClass(), this.serviceFilter.getClass(), this.serviceChooser.getClass()});
        ServiceHelper.startService((Object)this.serviceChooser);
        ServiceHelper.startService((Object)this.serviceDiscovery);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.serviceDiscovery);
        ServiceHelper.stopService((Object)this.serviceChooser);
    }

    public <T> T process(String serviceName, ServiceLoadBalancerFunction<T> function) throws Exception {
        ServiceDefinition service;
        List services = this.serviceDiscovery.getServices(serviceName);
        if (services == null || services.isEmpty()) {
            throw new RejectedExecutionException("No active services with name " + serviceName);
        }
        ServiceDefinition serviceDefinition = (services = this.serviceFilter.apply(services)).isEmpty() ? null : (service = services.size() > 1 ? this.serviceChooser.choose(services) : (ServiceDefinition)services.get(0));
        if (service == null) {
            throw new RejectedExecutionException("No active services with name " + serviceName);
        }
        return (T)function.apply(service);
    }
}

