/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J$\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "thetaFromX", "", "start", "", "clockwise", "(ZDZ)V", "isLinear", "()Z", "adjustDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "domain", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "geomSize", "createCoordinateMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "xLim", "yLim", "flipped", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPolarCoordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarCoordProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class PolarCoordProvider
extends CoordProviderBase {
    private final boolean thetaFromX;
    private final double start;
    private final boolean clockwise;

    public PolarCoordProvider(boolean thetaFromX, double start, boolean clockwise) {
        super(null, null, false, null, 8, null);
        this.thetaFromX = thetaFromX;
        this.start = start;
        this.clockwise = clockwise;
    }

    @Override
    public boolean isLinear() {
        return false;
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        return new PolarCoordProvider(this.thetaFromX, this.start, this.clockwise);
    }

    @Override
    @NotNull
    public DoubleRectangle adjustDomain(@NotNull DoubleRectangle domain) {
        DoubleRectangle doubleRectangle;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        boolean bl = this.thetaFromX;
        if (bl) {
            pair = TuplesKt.to((Object)domain.yRange(), (Object)domain.xRange());
        } else if (!bl) {
            pair = TuplesKt.to((Object)domain.xRange(), (Object)domain.yRange());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        boolean bl2 = false;
        DoubleSpan rDomain = (DoubleSpan)pair2.component1();
        DoubleSpan thetaDomain = (DoubleSpan)pair2.component2();
        DoubleSpan rDomainAdjusted = new DoubleSpan(rDomain.getLowerEnd().doubleValue(), rDomain.getUpperEnd() + rDomain.getLength() * 0.05);
        Pair pair3 = TuplesKt.to((Object)rDomainAdjusted, (Object)thetaDomain);
        DoubleSpan rDomain2 = (DoubleSpan)pair3.component1();
        DoubleSpan thetaDomain2 = (DoubleSpan)pair3.component2();
        boolean bl3 = this.thetaFromX;
        if (bl3) {
            doubleRectangle = new DoubleRectangle(thetaDomain2, rDomain2);
        } else if (!bl3) {
            doubleRectangle = new DoubleRectangle(rDomain2, thetaDomain2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleRectangle;
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double it = Math.min(geomSize.getX(), geomSize.getY());
        boolean bl = false;
        return new DoubleVector(it, it);
    }

    @Override
    @NotNull
    public CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        KFunction kFunction;
        DoubleVector doubleVector;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        boolean bl = this.thetaFromX;
        if (bl) {
            pair = TuplesKt.to((Object)adjustedDomain.yRange(), (Object)adjustedDomain.xRange());
        } else if (!bl) {
            pair = TuplesKt.to((Object)adjustedDomain.xRange(), (Object)adjustedDomain.yRange());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        DoubleSpan rDomain = (DoubleSpan)pair2.component1();
        DoubleSpan thetaDomain = (DoubleSpan)pair2.component2();
        double rNorm = 0.0 - rDomain.getLowerEnd();
        double thetaNorm = 0.0 - thetaDomain.getLowerEnd();
        DoubleSpan rRangeNorm = new DoubleSpan(0.0, rDomain.getUpperEnd() + rNorm);
        DoubleSpan thetaRangeNorm = new DoubleSpan(0.0, thetaDomain.getUpperEnd() + thetaNorm);
        ScaleMapper rScaleMapper = Mappers.INSTANCE.mul(rRangeNorm, Math.min(clientSize.getX(), clientSize.getY()) / 2.0);
        ScaleMapper thetaScaleMapper = Mappers.INSTANCE.mul(thetaRangeNorm, Math.PI * 2);
        DoubleVector center = clientSize.mul(0.5);
        boolean bl2 = this.thetaFromX;
        if (bl2) {
            doubleVector = new DoubleVector(thetaNorm, rNorm);
        } else if (!bl2) {
            doubleVector = new DoubleVector(rNorm, thetaNorm);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector norm = doubleVector;
        boolean bl3 = this.thetaFromX;
        if (bl3) {
            kFunction = (KFunction)new Function1<DoubleVector, Pair<? extends Double, ? extends Double>>((ScaleMapper<Double>)rScaleMapper, (ScaleMapper<Double>)thetaScaleMapper){
                final /* synthetic */ ScaleMapper<Double> $rScaleMapper;
                final /* synthetic */ ScaleMapper<Double> $thetaScaleMapper;
                {
                    this.$rScaleMapper = $rScaleMapper;
                    this.$thetaScaleMapper = $thetaScaleMapper;
                    super(1, Intrinsics.Kotlin.class, "scalerThetaX", "createCoordinateMapper$scalerThetaX(Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)Lkotlin/Pair;", 0);
                }

                @NotNull
                public final Pair<Double, Double> invoke(@NotNull DoubleVector p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return PolarCoordProvider.access$createCoordinateMapper$scalerThetaX(this.$rScaleMapper, this.$thetaScaleMapper, p0);
                }
            };
        } else if (!bl3) {
            kFunction = (KFunction)new Function1<DoubleVector, Pair<? extends Double, ? extends Double>>((ScaleMapper<Double>)rScaleMapper, (ScaleMapper<Double>)thetaScaleMapper){
                final /* synthetic */ ScaleMapper<Double> $rScaleMapper;
                final /* synthetic */ ScaleMapper<Double> $thetaScaleMapper;
                {
                    this.$rScaleMapper = $rScaleMapper;
                    this.$thetaScaleMapper = $thetaScaleMapper;
                    super(1, Intrinsics.Kotlin.class, "scalerThetaY", "createCoordinateMapper$scalerThetaY(Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)Lkotlin/Pair;", 0);
                }

                @NotNull
                public final Pair<Double, Double> invoke(@NotNull DoubleVector p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return PolarCoordProvider.access$createCoordinateMapper$scalerThetaY(this.$rScaleMapper, this.$thetaScaleMapper, p0);
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KFunction scaler2 = kFunction;
        double sign = this.clockwise ? -1.0 : 1.0;
        double startAngle = 1.5707963267948966 + sign * this.start;
        Projection polarProjection2 = new Projection((KFunction<Pair<Double, Double>>)scaler2, norm, sign, startAngle, center){
            private final boolean nonlinear;
            final /* synthetic */ KFunction<Pair<Double, Double>> $scaler;
            final /* synthetic */ DoubleVector $norm;
            final /* synthetic */ double $sign;
            final /* synthetic */ double $startAngle;
            final /* synthetic */ DoubleVector $center;
            {
                this.$scaler = $scaler;
                this.$norm = $norm;
                this.$sign = $sign;
                this.$startAngle = $startAngle;
                this.$center = $center;
                this.nonlinear = true;
            }

            public boolean getNonlinear() {
                return this.nonlinear;
            }

            @NotNull
            public DoubleVector project(@NotNull DoubleVector v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Pair pair = (Pair)((Function1)this.$scaler).invoke((Object)v.add(this.$norm));
                Double r = (Double)pair.component1();
                Double theta = (Double)pair.component2();
                if (r == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                if (theta == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                double x = r * Math.cos(this.$sign * theta + this.$startAngle);
                double y = r * Math.sin(this.$sign * theta + this.$startAngle);
                return this.$center.add(new DoubleVector(x, y));
            }

            @NotNull
            public DoubleVector invert(@NotNull DoubleVector v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @NotNull
            public DoubleRectangle validDomain() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public boolean getCylindrical() {
                return Projection.DefaultImpls.getCylindrical((Projection)this);
            }
        };
        DoubleRectangle clientBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), clientSize);
        return new CoordinatesMapper(Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY(), clientBounds, polarProjection2, false);
    }

    private static final Pair<Double, Double> createCoordinateMapper$scalerThetaX(ScaleMapper<Double> rScaleMapper, ScaleMapper<Double> thetaScaleMapper, DoubleVector v) {
        return TuplesKt.to((Object)rScaleMapper.invoke(Double.valueOf(v.getY())), (Object)thetaScaleMapper.invoke(Double.valueOf(v.getX())));
    }

    private static final Pair<Double, Double> createCoordinateMapper$scalerThetaY(ScaleMapper<Double> rScaleMapper, ScaleMapper<Double> thetaScaleMapper, DoubleVector v) {
        return TuplesKt.to((Object)rScaleMapper.invoke(Double.valueOf(v.getX())), (Object)thetaScaleMapper.invoke(Double.valueOf(v.getY())));
    }

    public static final /* synthetic */ Pair access$createCoordinateMapper$scalerThetaX(ScaleMapper rScaleMapper, ScaleMapper thetaScaleMapper, DoubleVector v) {
        return PolarCoordProvider.createCoordinateMapper$scalerThetaX((ScaleMapper<Double>)rScaleMapper, (ScaleMapper<Double>)thetaScaleMapper, v);
    }

    public static final /* synthetic */ Pair access$createCoordinateMapper$scalerThetaY(ScaleMapper rScaleMapper, ScaleMapper thetaScaleMapper, DoubleVector v) {
        return PolarCoordProvider.createCoordinateMapper$scalerThetaY((ScaleMapper<Double>)rScaleMapper, (ScaleMapper<Double>)thetaScaleMapper, v);
    }
}

