/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.FieldColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.mpp.rpc.thrift.TDeviceViewReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeviceViewResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeDeviceViewFieldDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeDeviceViewFieldDetector.class);
    private final ConfigManager configManager;
    private final PartialPath path;
    private final TsTable table;
    private final Map<String, Set<FieldColumnSchema>> fields;
    private TDeviceViewResp result = new TDeviceViewResp(StatusUtils.OK, new ConcurrentHashMap());
    private final Map<String, String> lowerCase2OriginalMap = new HashMap<String, String>();

    public TreeDeviceViewFieldDetector(ConfigManager configManager, TsTable table, Map<String, Set<FieldColumnSchema>> fields) {
        this.configManager = configManager;
        this.path = TreeViewSchema.getPrefixPattern((TsTable)table);
        this.table = table;
        this.fields = fields;
    }

    public TSStatus detectMissingFieldTypes() {
        if (this.table.getFieldNum() == 0 && Objects.isNull(this.fields)) {
            new TreeDeviceViewFieldDetectionTaskExecutor(this.configManager, this.getLatestSchemaRegionMap(), this.table.getTagNum(), TreeViewSchema.isRestrict((TsTable)this.table)).execute();
            if (this.result.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return this.result.getStatus();
            }
            this.result.getDeviewViewFieldTypeMap().forEach((field, type) -> {
                FieldColumnSchema columnSchema = new FieldColumnSchema(field, TSDataType.getTsDataType((byte)type));
                if (!field.equals(this.lowerCase2OriginalMap.get(field))) {
                    TreeViewSchema.setOriginalName((TsTableColumnSchema)columnSchema, (String)this.lowerCase2OriginalMap.get(field));
                }
                this.table.addColumnSchema((TsTableColumnSchema)columnSchema);
            });
        } else {
            Map<String, Set<FieldColumnSchema>> unknownFields;
            if (Objects.isNull(this.fields)) {
                unknownFields = new HashMap<String, Set<FieldColumnSchema>>();
                for (TsTableColumnSchema tsTableColumnSchema : this.table.getColumnList()) {
                    if (!(tsTableColumnSchema instanceof FieldColumnSchema) || tsTableColumnSchema.getDataType() != TSDataType.UNKNOWN) continue;
                    String key = TreeViewSchema.getSourceName((TsTableColumnSchema)tsTableColumnSchema);
                    if (!unknownFields.containsKey(key)) {
                        unknownFields.put(key, new HashSet());
                    }
                    unknownFields.get(key).add((FieldColumnSchema)tsTableColumnSchema);
                }
            } else {
                unknownFields = this.fields;
            }
            if (unknownFields.isEmpty()) {
                return StatusUtils.OK;
            }
            new TreeDeviceViewFieldDetectionTaskExecutor(this.configManager, this.getLatestSchemaRegionMap(), this.table.getTagNum(), TreeViewSchema.isRestrict((TsTable)this.table), unknownFields.keySet()).execute();
            if (this.result.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return this.result.getStatus();
            }
            for (Map.Entry entry : unknownFields.entrySet()) {
                if (this.result.getDeviewViewFieldTypeMap().containsKey(entry.getKey())) {
                    ((Set)entry.getValue()).forEach(field -> field.setDataType(TSDataType.getTsDataType((byte)((Byte)this.result.getDeviewViewFieldTypeMap().get(unknownField.getKey())))));
                    continue;
                }
                return new TSStatus(TSStatusCode.TYPE_NOT_FOUND.getStatusCode()).setMessage(String.format("Measurements not found for %s, cannot auto detect", entry.getKey()));
            }
        }
        return StatusUtils.OK;
    }

    private Map<TConsensusGroupId, TRegionReplicaSet> getLatestSchemaRegionMap() {
        PathPatternTree tree = new PathPatternTree();
        tree.appendPathPattern(this.path);
        tree.constructTree();
        return this.configManager.getRelatedSchemaRegionGroup(tree);
    }

    private class TreeDeviceViewFieldDetectionTaskExecutor
    extends DataNodeRegionTaskExecutor<TDeviceViewReq, TDeviceViewResp> {
        protected TreeDeviceViewFieldDetectionTaskExecutor(ConfigManager configManager, Map<TConsensusGroupId, TRegionReplicaSet> targetRegionGroup, int tagNumber, boolean restrict) {
            super(configManager, targetRegionGroup, false, CnToDnAsyncRequestType.DETECT_TREE_DEVICE_VIEW_FIELD_TYPE, (TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) -> new TDeviceViewReq(consensusGroupIdList, Arrays.asList(TreeDeviceViewFieldDetector.this.path.getNodes()), tagNumber, restrict));
            configManager.getClusterSchemaManager().getTemplateSetInfo(Collections.singletonList(TreeDeviceViewFieldDetector.this.path)).getPatternTemplateMap().values().stream().flatMap(Collection::stream).flatMap(template -> template.getSchemaMap().values().stream()).forEach(schema -> this.mergeMeasurementAndType(schema.getMeasurementName(), schema.getTypeInByte()));
        }

        protected TreeDeviceViewFieldDetectionTaskExecutor(ConfigManager configManager, Map<TConsensusGroupId, TRegionReplicaSet> targetRegionGroup, int tagNumber, @Nonnull boolean restrict, Set<String> measurements) {
            super(configManager, targetRegionGroup, false, CnToDnAsyncRequestType.DETECT_TREE_DEVICE_VIEW_FIELD_TYPE, (TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) -> new TDeviceViewReq(consensusGroupIdList, Arrays.asList(TreeDeviceViewFieldDetector.this.path.getNodes()), tagNumber, restrict).setRequiredMeasurements(measurements));
            configManager.getClusterSchemaManager().getTemplateSetInfo(Collections.singletonList(TreeDeviceViewFieldDetector.this.path)).getPatternTemplateMap().values().stream().flatMap(Collection::stream).flatMap(template -> template.getSchemaMap().values().stream()).filter(schema -> measurements.contains(schema.getMeasurementName())).forEach(schema -> this.mergeMeasurementAndType(schema.getMeasurementName(), schema.getTypeInByte()));
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TDeviceViewResp response) {
            if (TreeDeviceViewFieldDetector.this.result.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return Collections.emptyList();
            }
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.mergeDeviceViewResp(response);
                return Collections.emptyList();
            }
            if (response.getStatus().getCode() == TSStatusCode.DATA_TYPE_MISMATCH.getStatusCode()) {
                TreeDeviceViewFieldDetector.this.result = response;
                return Collections.emptyList();
            }
            if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatus = response.getStatus().getSubStatus();
                for (int i = 0; i < subStatus.size(); ++i) {
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.mergeDeviceViewResp(response);
                        response = null;
                        continue;
                    }
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.DATA_TYPE_MISMATCH.getStatusCode()) {
                        response.setStatus((TSStatus)subStatus.get(i));
                        TreeDeviceViewFieldDetector.this.result = response;
                        return Collections.emptyList();
                    }
                    if (!Objects.nonNull(response)) continue;
                    failedRegionList.add(consensusGroupIdList.get(i));
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        private void mergeDeviceViewResp(TDeviceViewResp resp) {
            resp.getDeviewViewFieldTypeMap().forEach(this::mergeMeasurementAndType);
        }

        private void mergeMeasurementAndType(String measurement, byte type) {
            String fieldName = measurement.toLowerCase(Locale.ENGLISH);
            if (!TreeDeviceViewFieldDetector.this.result.getDeviewViewFieldTypeMap().containsKey(fieldName)) {
                TreeDeviceViewFieldDetector.this.result.getDeviewViewFieldTypeMap().put(fieldName, type);
            } else if (!Objects.equals(TreeDeviceViewFieldDetector.this.result.getDeviewViewFieldTypeMap().get(fieldName), type)) {
                TreeDeviceViewFieldDetector.this.result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.DATA_TYPE_MISMATCH, (String)String.format("Multiple types encountered when auto detecting type of measurement '%s', please check", measurement)));
            }
            if (!TreeDeviceViewFieldDetector.this.lowerCase2OriginalMap.containsKey(fieldName)) {
                TreeDeviceViewFieldDetector.this.lowerCase2OriginalMap.put(fieldName, measurement);
            } else if (!Objects.equals(TreeDeviceViewFieldDetector.this.lowerCase2OriginalMap.get(fieldName), measurement)) {
                TreeDeviceViewFieldDetector.this.result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.MEASUREMENT_NAME_CONFLICT, (String)String.format("The measurements %s and %s share the same lower case when auto detecting type, please check", TreeDeviceViewFieldDetector.this.lowerCase2OriginalMap.get(fieldName), measurement)));
            }
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            String errorMsg = "Failed to get device view field type on region {}.";
            LOGGER.warn("Failed to get device view field type on region {}.", (Object)consensusGroupId);
            TreeDeviceViewFieldDetector.this.result = new TDeviceViewResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.TYPE_NOT_FOUND, (String)"Failed to get device view field type on region {}."), Collections.emptyMap());
            this.interruptTask();
        }
    }
}

