/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheStats;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

class RetryCacheImpl
implements RetryCache {
    private final Cache<ClientInvocationId, CacheEntry> cache;
    private final AtomicReference<StatisticsImpl> statistics = new AtomicReference();
    private final TimeDuration statisticsExpiryTime;

    RetryCacheImpl(RaftProperties properties) {
        this(RaftServerConfigKeys.RetryCache.expiryTime((RaftProperties)properties), RaftServerConfigKeys.RetryCache.statisticsExpiryTime((RaftProperties)properties));
    }

    RetryCacheImpl(TimeDuration cacheExpiryTime, TimeDuration statisticsExpiryTime) {
        this.cache = CacheBuilder.newBuilder().recordStats().expireAfterWrite(cacheExpiryTime.getDuration(), cacheExpiryTime.getUnit()).build();
        this.statisticsExpiryTime = statisticsExpiryTime;
    }

    CacheEntry getOrCreateEntry(ClientInvocationId key) {
        return this.getOrCreateEntry(key, () -> new CacheEntry(key));
    }

    private CacheEntry getOrCreateEntry(ClientInvocationId key, Supplier<CacheEntry> constructor) {
        try {
            return (CacheEntry)this.cache.get((Object)key, constructor::get);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to get " + key, e);
        }
    }

    CacheEntry refreshEntry(CacheEntry newEntry) {
        this.cache.put((Object)newEntry.getKey(), (Object)newEntry);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheQueryResult queryCache(RaftClientRequest request) {
        ClientInvocationId key = ClientInvocationId.valueOf((RaftClientMessage)request);
        MemoizedSupplier newEntry = MemoizedSupplier.valueOf(() -> new CacheEntry(key));
        CacheEntry cacheEntry = this.getOrCreateEntry(key, (Supplier<CacheEntry>)newEntry);
        if (newEntry.isInitialized()) {
            return new CacheQueryResult(cacheEntry, false);
        }
        if (!cacheEntry.isDone() || !cacheEntry.isFailed()) {
            return new CacheQueryResult(cacheEntry, true);
        }
        RetryCacheImpl retryCacheImpl = this;
        synchronized (retryCacheImpl) {
            CacheEntry currentEntry = (CacheEntry)this.cache.getIfPresent((Object)key);
            if (currentEntry == cacheEntry || currentEntry == null) {
                return new CacheQueryResult(this.refreshEntry((CacheEntry)newEntry.get()), false);
            }
            return new CacheQueryResult(currentEntry, true);
        }
    }

    void invalidateRepliedRequests(RaftClientRequest request) {
        ClientId clientId = request.getClientId();
        Iterable callIds = request.getRepliedCallIds();
        if (!callIds.iterator().hasNext()) {
            return;
        }
        LOG.debug("invalidateRepliedRequests callIds {} for {}", (Object)callIds, (Object)clientId);
        this.cache.invalidateAll(CollectionUtils.as((Iterable)callIds, callId -> ClientInvocationId.valueOf((ClientId)clientId, (long)callId)));
    }

    public RetryCache.Statistics getStatistics() {
        return this.statistics.updateAndGet(old -> old == null || old.isExpired() ? new StatisticsImpl(this.cache) : old);
    }

    public CacheEntry getIfPresent(ClientInvocationId key) {
        return (CacheEntry)this.cache.getIfPresent((Object)key);
    }

    public synchronized void close() {
        this.cache.invalidateAll();
        this.statistics.set(null);
    }

    static CompletableFuture<RaftClientReply> failWithReply(RaftClientReply reply, CacheEntry entry) {
        if (entry != null) {
            entry.failWithReply(reply);
            return entry.getReplyFuture();
        }
        return CompletableFuture.completedFuture(reply);
    }

    class StatisticsImpl
    implements RetryCache.Statistics {
        private final long size;
        private final CacheStats cacheStats;
        private final Timestamp creation = Timestamp.currentTime();

        StatisticsImpl(Cache<?, ?> cache) {
            this.size = cache.size();
            this.cacheStats = cache.stats();
        }

        boolean isExpired() {
            return Optional.ofNullable(RetryCacheImpl.this.statisticsExpiryTime).map(t -> this.creation.elapsedTime().compareTo(t) > 0).orElse(true);
        }

        public long size() {
            return this.size;
        }

        public long hitCount() {
            return this.cacheStats.hitCount();
        }

        public double hitRate() {
            return this.cacheStats.hitRate();
        }

        public long missCount() {
            return this.cacheStats.missCount();
        }

        public double missRate() {
            return this.cacheStats.missRate();
        }

        public String toString() {
            return this.creation + ":size=" + this.size + "," + this.cacheStats;
        }
    }

    static class CacheQueryResult {
        private final CacheEntry entry;
        private final boolean isRetry;

        CacheQueryResult(CacheEntry entry, boolean isRetry) {
            this.entry = entry;
            this.isRetry = isRetry;
        }

        public CacheEntry getEntry() {
            return this.entry;
        }

        public boolean isRetry() {
            return this.isRetry;
        }
    }

    static class CacheEntry
    implements RetryCache.Entry {
        private final ClientInvocationId key;
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private volatile boolean failed = false;

        CacheEntry(ClientInvocationId key) {
            this.key = key;
        }

        public String toString() {
            return this.key + ":" + (this.isDone() ? "done" : "pending");
        }

        boolean isDone() {
            return this.isFailed() || this.replyFuture.isDone();
        }

        boolean isCompletedNormally() {
            return !this.failed && JavaUtils.isCompletedNormally(this.replyFuture);
        }

        void updateResult(RaftClientReply reply) {
            assert (!this.replyFuture.isDone() && !this.replyFuture.isCancelled());
            this.replyFuture.complete(reply);
        }

        boolean isFailed() {
            return this.failed || this.replyFuture.isCompletedExceptionally();
        }

        void failWithReply(RaftClientReply reply) {
            this.failed = true;
            this.replyFuture.complete(reply);
        }

        CompletableFuture<RaftClientReply> failWithException(Throwable t) {
            this.failed = true;
            this.replyFuture.completeExceptionally(t);
            return this.replyFuture;
        }

        public CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        public ClientInvocationId getKey() {
            return this.key;
        }
    }
}

