/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite3.internal.catalog.storage.UpdateLogImpl;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.server.NotificationEnqueuedListener;
import org.apache.ignite3.internal.metastorage.server.time.ClusterTime;
import org.apache.ignite3.internal.schema.SchemaSafeTimeTracker;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;
import org.jetbrains.annotations.TestOnly;

public class SchemaSafeTimeTrackerImpl
implements SchemaSafeTimeTracker,
IgniteComponent,
NotificationEnqueuedListener {
    private final ClusterTime clusterTime;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> schemaSafeTime = new PendingComparableValuesTracker(HybridTimestamp.MIN_VALUE);
    private CompletableFuture<Void> schemaSafeTimeUpdateFuture = CompletableFutures.nullCompletedFuture();
    private final Object futureMutex = new Object();

    public SchemaSafeTimeTrackerImpl(ClusterTime clusterTime) {
        this.clusterTime = clusterTime;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.schemaSafeTime.update(this.clusterTime.currentSafeTime(), null);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.schemaSafeTime.close(new NodeStoppingException());
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEnqueued(CompletableFuture<Void> newNotificationFuture, List<Entry> entries, HybridTimestamp timestamp) {
        boolean hasCatalogUpdates = SchemaSafeTimeTrackerImpl.hasCatalogUpdates(entries);
        Object object = this.futureMutex;
        synchronized (object) {
            CompletionStage<Void> newSchemaSafeTimeUpdateFuture = hasCatalogUpdates ? this.schemaSafeTimeUpdateFuture.thenCompose(unused -> newNotificationFuture) : this.schemaSafeTimeUpdateFuture;
            this.schemaSafeTimeUpdateFuture = newSchemaSafeTimeUpdateFuture = newSchemaSafeTimeUpdateFuture.thenRun(() -> this.schemaSafeTime.update(timestamp, null));
        }
    }

    private static boolean hasCatalogUpdates(List<Entry> entries) {
        for (Entry entry : entries) {
            if (!SchemaSafeTimeTrackerImpl.isCatalogUpdateEntry(entry)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCatalogUpdateEntry(Entry entry) {
        return SchemaSafeTimeTrackerImpl.isPrefixedWith(UpdateLogImpl.CATALOG_UPDATE_PREFIX.bytes(), entry.key());
    }

    private static boolean isPrefixedWith(byte[] prefix, byte[] key) {
        if (key.length < prefix.length) {
            return false;
        }
        return Arrays.equals(key, 0, prefix.length, prefix, 0, prefix.length);
    }

    @Override
    public CompletableFuture<Void> waitFor(HybridTimestamp hybridTimestamp) {
        return this.schemaSafeTime.waitFor(hybridTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void enqueueFuture(CompletableFuture<Void> future) {
        Object object = this.futureMutex;
        synchronized (object) {
            this.schemaSafeTimeUpdateFuture = this.schemaSafeTimeUpdateFuture.thenCompose(unused -> future);
        }
    }

    @TestOnly
    HybridTimestamp currentSafeTime() {
        return this.schemaSafeTime.current();
    }
}

