/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.treesitter.highlighter;

import java.util.EnumMap;
import java.util.Map;
import org.apache.ignite.internal.cli.commands.treesitter.parser.HoconTokenType;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Indexer;
import org.apache.ignite.internal.cli.commands.treesitter.parser.Parser;
import org.apache.ignite.internal.cli.core.style.AnsiStringSupport;
import org.treesitter.TSTree;

public class HoconAnsiHighlighter {
    private static final Map<HoconTokenType, AnsiStringSupport.Color> COLOR_MAP = new EnumMap<HoconTokenType, AnsiStringSupport.Color>(HoconTokenType.class);

    public static String highlight(String text) {
        TSTree tree = Parser.parseHocon(text);
        HoconTokenType[] tokens = Indexer.indexHocon(text, tree);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            HoconTokenType token = tokens[i];
            AnsiStringSupport.Color color = COLOR_MAP.get((Object)token);
            sb.append(AnsiStringSupport.fg(color).mark(String.valueOf(text.charAt(i))));
        }
        return AnsiStringSupport.ansi(sb.toString());
    }

    static {
        COLOR_MAP.put(HoconTokenType.QUOTE, AnsiStringSupport.Color.GREEN);
        COLOR_MAP.put(HoconTokenType.STRING, AnsiStringSupport.Color.GREEN);
        COLOR_MAP.put(HoconTokenType.PATH, AnsiStringSupport.Color.WHITE);
        COLOR_MAP.put(HoconTokenType.BRACKET, AnsiStringSupport.Color.GRAY);
        COLOR_MAP.put(HoconTokenType.COMMA, AnsiStringSupport.Color.GRAY);
        COLOR_MAP.put(HoconTokenType.COLON, AnsiStringSupport.Color.GRAY);
        COLOR_MAP.put(HoconTokenType.EQUALS, AnsiStringSupport.Color.GRAY);
        COLOR_MAP.put(HoconTokenType.NUMBER, AnsiStringSupport.Color.BLUE);
        COLOR_MAP.put(HoconTokenType.BOOL, AnsiStringSupport.Color.YELLOW_DARK);
        COLOR_MAP.put(HoconTokenType.UNKNOWN, AnsiStringSupport.Color.GRAY);
        COLOR_MAP.put(HoconTokenType.SPACE, AnsiStringSupport.Color.GRAY);
    }
}

