/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

class ScanVersionsCursor
implements Cursor<ReadResult> {
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final VersionChain versionChain;
    @Nullable
    private Boolean hasNext;
    private RowVersion currentRowVersion;
    private long nextLink;

    ScanVersionsCursor(VersionChain versionChain, AbstractPageMemoryMvPartitionStorage storage) {
        this.storage = storage;
        this.versionChain = versionChain;
        this.nextLink = versionChain.headLink();
    }

    public void close() {
    }

    public boolean hasNext() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            if (this.hasNext != null) {
                return this.hasNext;
            }
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(this.versionChain.rowId()));
            this.hasNext = this.nextLink != 0L;
            if (this.hasNext.booleanValue()) {
                this.currentRowVersion = this.storage.readRowVersion(this.nextLink, AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
                this.nextLink = this.currentRowVersion.nextLink();
            }
            return this.hasNext;
        });
    }

    public ReadResult next() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            assert (AbstractPageMemoryMvPartitionStorage.rowIsLocked(this.versionChain.rowId()));
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.rowVersionToReadResult(this.currentRowVersion);
        });
    }

    private ReadResult rowVersionToReadResult(RowVersion rowVersion) {
        RowId rowId = this.versionChain.rowId();
        if (rowVersion.isCommitted()) {
            if (rowVersion.isTombstone()) {
                return ReadResult.empty((RowId)rowId);
            }
            return ReadResult.createFromCommitted((RowId)rowId, (BinaryRow)rowVersion.value(), (HybridTimestamp)rowVersion.timestamp());
        }
        return ReadResult.createFromWriteIntent((RowId)rowId, (BinaryRow)rowVersion.value(), (UUID)this.versionChain.transactionId(), (int)this.versionChain.commitTableId(), (int)this.versionChain.commitPartitionId(), null);
    }
}

