/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.SnapshotRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.SnapshotRequestSerializer;

public class SnapshotRequestImpl
implements CliRequests.SnapshotRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1006;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;

    private SnapshotRequestImpl(String groupId, String peerId) {
        this.groupId = groupId;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public MessageSerializer serializer() {
        return SnapshotRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(SnapshotRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1006;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotRequestImpl otherMessage = (SnapshotRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.peerId);
        return result;
    }

    public SnapshotRequestImpl clone() {
        try {
            return (SnapshotRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SnapshotRequestBuilder {
        private String groupId;
        private String peerId;

        private Builder() {
        }

        @Override
        public SnapshotRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public SnapshotRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.SnapshotRequest build() {
            return new SnapshotRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"));
        }
    }
}

