/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.SampleValue;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

abstract class IgniteBinaryIdentityBenchmark
extends IgniteCacheAbstractBenchmark<BinaryObject, SampleValue> {
    IgniteBinaryIdentityBenchmark() {
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating data...");
        long start = System.nanoTime();
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(this.cache.getName());){
            int i = 0;
            while (i < this.args.range() && !Thread.currentThread().isInterrupted()) {
                dataLdr.addData((Object)this.createKey(i), (Object)new SampleValue(i));
                if (++i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Items populated: " + i));
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating data in " + (System.nanoTime() - start) / 1000000L + " ms."));
    }

    @Override
    protected IgniteCache<BinaryObject, SampleValue> cache() {
        return this.ignite().cache("atomic").withKeepBinary();
    }

    abstract BinaryObject createKey(int var1);

    BinaryObject createFieldsIdentityBinaryKey(int key) {
        BinaryObjectBuilder bldr = this.ignite().binary().builder("BinaryKeyWithFieldsIdentity");
        IgniteBinaryIdentityBenchmark.setBuilderFields(bldr, key);
        return bldr.build();
    }

    private static void setBuilderFields(BinaryObjectBuilder builder, int key) {
        builder.setField("f1", (Object)1);
        builder.setField("f2", (Object)"SomeString");
        builder.setField("f3", (Object)key);
    }
}

