/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.contracts.annotations.meta.ContractElement;
import org.apache.groovy.contracts.annotations.meta.Postcondition;
import org.apache.groovy.contracts.ast.visitor.BaseVisitor;
import org.apache.groovy.contracts.common.spi.AnnotationProcessor;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public class AnnotationProcessorVisitor
extends BaseVisitor {
    private static final String CONTRACT_ELEMENT_CLASSNAME = ContractElement.class.getName();
    private final ProcessingContextInformation pci;

    public AnnotationProcessorVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    public void visitClass(ClassNode type) {
        this.handleClassNode(type);
        ArrayList methodNodes = new ArrayList();
        methodNodes.addAll(type.getMethods());
        methodNodes.addAll(type.getDeclaredConstructors());
        for (MethodNode methodNode : methodNodes) {
            if (!CandidateChecks.isClassInvariantCandidate(type, methodNode) && !CandidateChecks.isPreOrPostconditionCandidate(type, methodNode)) continue;
            this.handleMethodAnnotations(methodNode, AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, CONTRACT_ELEMENT_CLASSNAME));
        }
        this.visitInterfaces(type, type.getInterfaces());
        this.visitAbstractBaseClassesForInterfaceMethodNodes(type, type.getSuperClass());
    }

    private void visitAbstractBaseClassesForInterfaceMethodNodes(ClassNode origin, ClassNode superClass) {
        if (superClass == null || !superClass.isAbstract()) {
            return;
        }
        for (ClassNode interfaceNode : superClass.getInterfaces()) {
            ArrayList interfaceMethods = new ArrayList(interfaceNode.getMethods());
            for (MethodNode interfaceMethod : interfaceMethods) {
                MethodNode implementationInOriginClassNode;
                MethodNode implementingMethod;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethod, CONTRACT_ELEMENT_CLASSNAME);
                if (annotationNodes == null || annotationNodes.isEmpty() || (implementingMethod = superClass.getMethod(interfaceMethod.getName(), interfaceMethod.getParameters())) != null || (implementationInOriginClassNode = origin.getMethod(interfaceMethod.getName(), interfaceMethod.getParameters())) == null) continue;
                this.handleMethodAnnotations(implementationInOriginClassNode, annotationNodes);
            }
        }
    }

    private void visitInterfaces(ClassNode classNode, ClassNode[] interfaces) {
        for (ClassNode interfaceNode : interfaces) {
            List<AnnotationNode> interfaceNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceNode, CONTRACT_ELEMENT_CLASSNAME);
            this.processAnnotationNodes(classNode, interfaceNodes);
            ArrayList interfaceMethods = new ArrayList(interfaceNode.getMethods());
            for (MethodNode interfaceMethod : interfaceMethods) {
                MethodNode implementingMethod = classNode.getMethod(interfaceMethod.getName(), interfaceMethod.getParameters());
                if (implementingMethod == null) continue;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethod, CONTRACT_ELEMENT_CLASSNAME);
                this.handleInterfaceMethodNode(classNode, implementingMethod, annotationNodes);
            }
            this.visitInterfaces(classNode, interfaceNode.getInterfaces());
        }
    }

    private void handleClassNode(ClassNode classNode) {
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)classNode, CONTRACT_ELEMENT_CLASSNAME);
        this.processAnnotationNodes(classNode, annotationNodes);
    }

    private void processAnnotationNodes(ClassNode classNode, List<AnnotationNode> annotationNodes) {
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor processor = this.createAnnotationProcessor(annotationNode);
            if (processor == null) continue;
            Expression valueExpression = AnnotationProcessorVisitor.getReplacedCondition(annotationNode);
            BlockStatement blockStatement = (BlockStatement)valueExpression.getNodeMetaData((Object)"org.apache.groovy.contracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK");
            processor.process(this.pci, this.pci.contract(), classNode, blockStatement, AnnotationProcessorVisitor.asConditionExecution(annotationNode));
        }
    }

    private void handleInterfaceMethodNode(ClassNode type, MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        this.handleMethodAnnotations(type.getMethod(methodNode.getName(), methodNode.getParameters()), annotationNodes);
    }

    private void handleMethodAnnotations(MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        if (methodNode == null) {
            return;
        }
        HashMap<String, List<BooleanExpression>> collectedPreconditions = new HashMap<String, List<BooleanExpression>>();
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor annotationProcessor = this.createAnnotationProcessor(annotationNode);
            if (annotationProcessor == null || AnnotationProcessorVisitor.getReplacedCondition(annotationNode) == null) continue;
            this.handleMethodAnnotation(methodNode, annotationNode, annotationProcessor, collectedPreconditions);
        }
        for (String processorName : collectedPreconditions.keySet()) {
            AnnotationProcessor processor = AnnotationProcessorVisitor.getAnnotationProcessor(processorName);
            BooleanExpression collectedExpression = null;
            for (BooleanExpression boolExp : (List)collectedPreconditions.get(processorName)) {
                if (collectedExpression == null) {
                    collectedExpression = boolExp;
                    continue;
                }
                collectedExpression = GeneralUtils.boolX((Expression)GeneralUtils.andX((Expression)collectedExpression, (Expression)boolExp));
            }
            processor.process(this.pci, this.pci.contract(), methodNode.getDeclaringClass(), methodNode, null, collectedExpression);
        }
    }

    private void handleMethodAnnotation(MethodNode methodNode, AnnotationNode annotationNode, AnnotationProcessor annotationProcessor, Map<String, List<BooleanExpression>> collected) {
        boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotationNode.getClassNode(), Postcondition.class.getName());
        ArgumentListExpression argumentList = new ArgumentListExpression();
        for (Parameter parameter : methodNode.getParameters()) {
            argumentList.addExpression((Expression)GeneralUtils.varX((Variable)parameter));
        }
        if (isPostcondition && !methodNode.isVoidMethod()) {
            argumentList.addExpression((Expression)GeneralUtils.localVarX((String)"result", (ClassNode)methodNode.getReturnType()));
        }
        if (isPostcondition && !methodNode.isConstructor()) {
            argumentList.addExpression((Expression)GeneralUtils.localVarX((String)"old", (ClassNode)ClassHelper.MAP_TYPE.getPlainNodeReference()));
        }
        Expression valueExpression = AnnotationProcessorVisitor.getReplacedCondition(annotationNode);
        BooleanExpression booleanExpression = AnnotationProcessorVisitor.asConditionExecution(annotationNode);
        ((MethodCallExpression)booleanExpression.getExpression()).setArguments((Expression)argumentList);
        BlockStatement blockStatement = (BlockStatement)valueExpression.getNodeMetaData((Object)"org.apache.groovy.contracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK");
        if (isPostcondition) {
            annotationProcessor.process(this.pci, this.pci.contract(), methodNode.getDeclaringClass(), methodNode, blockStatement, booleanExpression);
        } else {
            String name = annotationProcessor.getClass().getName();
            collected.putIfAbsent(name, new ArrayList());
            collected.get(name).add(booleanExpression);
        }
        if (!AnnotationUtils.hasAnnotationOfType((AnnotatedNode)methodNode, annotationNode.getClassNode().getName())) {
            AnnotationNode markerAnnotation = new AnnotationNode(annotationNode.getClassNode());
            AnnotationProcessorVisitor.replaceCondition(markerAnnotation, valueExpression);
            markerAnnotation.setRuntimeRetention(true);
            markerAnnotation.setSourceRetention(false);
            methodNode.addAnnotation(markerAnnotation);
        }
    }

    private AnnotationProcessor createAnnotationProcessor(AnnotationNode annotationNode) {
        String name;
        AnnotationProcessor apt;
        Expression annotationProcessor = null;
        List annotations = annotationNode.getClassNode().getAnnotations();
        for (AnnotationNode anno : annotations) {
            if (!"org.apache.groovy.contracts.annotations.meta.AnnotationProcessorImplementation".equals(anno.getClassNode().getName())) continue;
            annotationProcessor = anno.getMember("value");
            break;
        }
        if (annotationProcessor != null && (apt = AnnotationProcessorVisitor.getAnnotationProcessor(name = annotationProcessor.getType().getName())) != null) {
            return apt;
        }
        throw new GroovyBugError("Annotation processing class could not be instantiated! This indicates a bug in groovy-contracts, please file an issue!");
    }

    public static AnnotationProcessor getAnnotationProcessor(String name) {
        try {
            Class<?> apt = Class.forName(name);
            return (AnnotationProcessor)apt.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

