/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.AbstractServiceFactory;
import org.apache.cxf.service.ServiceBuilder;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.processor.FrontendFactory;
import org.apache.cxf.tools.java2wsdl.processor.internal.ServiceBuilderFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public final class SpringServiceBuilderFactory
extends ServiceBuilderFactory {
    private List<String> beanDefinitions;

    public SpringServiceBuilderFactory(List<String> beanDefinitions) {
        this.beanDefinitions = beanDefinitions;
    }

    public SpringServiceBuilderFactory() {
        this.beanDefinitions = new ArrayList<String>(0);
    }

    public static String databindingNameToBeanName(String databindingName) {
        return StringUtils.capitalize((String)databindingName.toLowerCase()) + "DatabindingBean";
    }

    @Override
    public ServiceBuilder newBuilder(FrontendFactory.Style s) {
        ServiceBuilder builder;
        DataBinding dataBinding;
        ApplicationContext applicationContext = SpringServiceBuilderFactory.getApplicationContext(this.beanDefinitions);
        String databindingBeanName = SpringServiceBuilderFactory.databindingNameToBeanName(this.databindingName);
        try {
            dataBinding = (DataBinding)applicationContext.getBean(databindingBeanName);
        }
        catch (RuntimeException e) {
            throw new ToolException("Cannot get databinding bean " + databindingBeanName + " for databinding " + this.databindingName, (Throwable)e);
        }
        String beanName = this.getBuilderBeanName(s);
        try {
            builder = (ServiceBuilder)applicationContext.getBean(beanName, ServiceBuilder.class);
            AbstractServiceFactory serviceFactory = (AbstractServiceFactory)builder;
            serviceFactory.setDataBinding(dataBinding);
        }
        catch (RuntimeException e) {
            throw new ToolException("Can not get ServiceBuilder bean " + beanName + "to initialize the ServiceBuilder for style: " + s + " Reason: \n" + e.getMessage(), (Throwable)e);
        }
        builder.setServiceClass(this.serviceClass);
        return builder;
    }

    protected String getBuilderBeanName(FrontendFactory.Style s) {
        return s + "ServiceBuilderBean";
    }

    public static ApplicationContext getApplicationContext(List<String> additionalFilePathnames) {
        BusApplicationContext busApplicationContext = (BusApplicationContext)BusFactory.getDefaultBus().getExtension(BusApplicationContext.class);
        GenericApplicationContext appContext = new GenericApplicationContext((ApplicationContext)busApplicationContext);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        List urls = ClassLoaderUtils.getResources((String)"META-INF/cxf/java2wsbeans.xml", SpringServiceBuilderFactory.class);
        for (URL url : urls) {
            reader.loadBeanDefinitions((Resource)new UrlResource(url));
        }
        for (String pathname : additionalFilePathnames) {
            try {
                reader.loadBeanDefinitions((Resource)new FileSystemResource(pathname));
            }
            catch (BeanDefinitionStoreException bdse) {
                throw new ToolException("Unable to open bean definition file " + pathname, bdse.getCause());
            }
        }
        appContext.refresh();
        return appContext;
    }

    public void setBeanDefinitions(List<String> beanDefinitions) {
        this.beanDefinitions = beanDefinitions;
    }
}

