/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.settings.Mergeable;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.bean.MetaBean;

public class AddressSettings
implements Mergeable<AddressSettings>,
Serializable,
EncodingSupport {
    static MetaBean<AddressSettings> metaBean = new MetaBean();
    private static final long serialVersionUID = 1607502280582336366L;
    public static final long DEFAULT_MAX_SIZE_BYTES = -1L;
    public static final long DEFAULT_MAX_SIZE_MESSAGES = -1L;
    public static final int DEFAULT_MAX_READ_PAGE_MESSAGES = -1;
    public static final AddressFullMessagePolicy DEFAULT_ADDRESS_FULL_MESSAGE_POLICY = AddressFullMessagePolicy.PAGE;
    public static final int DEFAULT_PAGE_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_DELIVERY_ATTEMPTS = 10;
    public static final int DEFAULT_PAGE_MAX_CACHE = 5;
    public static final int DEFAULT_MESSAGE_COUNTER_HISTORY_DAY_LIMIT = 0;
    public static final long DEFAULT_REDELIVER_DELAY = 0L;
    public static final double DEFAULT_REDELIVER_MULTIPLIER = 1.0;
    public static final double DEFAULT_REDELIVER_COLLISION_AVOIDANCE_FACTOR = 0.0;
    public static final boolean DEFAULT_LAST_VALUE_QUEUE = false;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_JMS_QUEUES = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_CREATE_TOPICS = true;
    @Deprecated
    public static final boolean DEFAULT_AUTO_DELETE_TOPICS = true;
    public static final boolean DEFAULT_AUTO_CREATE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES = true;
    public static final boolean DEFAULT_AUTO_DELETE_CREATED_QUEUES = false;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_DELAY = 0L;
    public static final boolean DEFAULT_AUTO_DELETE_QUEUES_SKIP_USAGE_CHECK = false;
    public static final long DEFAULT_AUTO_DELETE_QUEUES_MESSAGE_COUNT = 0L;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_QUEUES = DeletionPolicy.OFF;
    public static final boolean DEFAULT_AUTO_CREATE_ADDRESSES = true;
    public static final boolean DEFAULT_AUTO_DELETE_ADDRESSES = true;
    public static final long DEFAULT_AUTO_DELETE_ADDRESSES_DELAY = 0L;
    public static final boolean DEFAULT_AUTO_DELETE_ADDRESSES_SKIP_USAGE_CHECK = false;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_ADDRESSES = DeletionPolicy.OFF;
    public static final DeletionPolicy DEFAULT_CONFIG_DELETE_DIVERTS = DeletionPolicy.OFF;
    public static final long DEFAULT_REDISTRIBUTION_DELAY = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_EXPIRY_RESOURCES = false;
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_PREFIX = SimpleString.of((String)"EXP.");
    public static final SimpleString DEFAULT_EXPIRY_QUEUE_SUFFIX = SimpleString.of((String)"");
    public static final long DEFAULT_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MIN_EXPIRY_DELAY = -1L;
    public static final long DEFAULT_MAX_EXPIRY_DELAY = -1L;
    public static final boolean DEFAULT_NO_EXPIRY = false;
    public static final boolean DEFAULT_SEND_TO_DLA_ON_NO_ROUTE = false;
    public static final long DEFAULT_SLOW_CONSUMER_THRESHOLD = -1L;
    public static final long DEFAULT_SLOW_CONSUMER_CHECK_PERIOD = 5L;
    public static final int MANAGEMENT_BROWSE_PAGE_SIZE = 200;
    public static final SlowConsumerPolicy DEFAULT_SLOW_CONSUMER_POLICY = SlowConsumerPolicy.NOTIFY;
    public static final int DEFAULT_QUEUE_PREFETCH = 1000;
    public static final long DEFAULT_ADDRESS_REJECT_THRESHOLD = -1L;
    public static final boolean DEFAULT_AUTO_CREATE_DEAD_LETTER_RESOURCES = false;
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_PREFIX = SimpleString.of((String)"DLQ.");
    public static final SimpleString DEFAULT_DEAD_LETTER_QUEUE_SUFFIX = SimpleString.of((String)"");
    public static final boolean DEFAULT_ENABLE_METRICS = true;
    public static final int MANAGEMENT_MESSAGE_ATTRIBUTE_SIZE_LIMIT = 256;
    public static final SlowConsumerThresholdMeasurementUnit DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT = SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_SECOND;
    public static final boolean DEFAULT_ENABLE_INGRESS_TIMESTAMP = false;
    private AddressFullMessagePolicy addressFullMessagePolicy = null;
    private Long maxSizeBytes = null;
    private Integer maxReadPageBytes = null;
    private Integer maxReadPageMessages = null;
    private Integer prefetchPageBytes = null;
    private Integer prefetchPageMessages = null;
    private Long pageLimitBytes = null;
    private Long pageLimitMessages = null;
    private PageFullMessagePolicy pageFullMessagePolicy = null;
    private Long maxSizeMessages = null;
    private Integer pageSizeBytes = null;
    private Integer pageCacheMaxSize = null;
    private Boolean dropMessagesWhenFull = null;
    private Integer maxDeliveryAttempts = null;
    private Integer messageCounterHistoryDayLimit = null;
    private Long redeliveryDelay = null;
    private Double redeliveryMultiplier = null;
    private Double redeliveryCollisionAvoidanceFactor = null;
    private Long maxRedeliveryDelay = null;
    private SimpleString deadLetterAddress = null;
    private SimpleString expiryAddress = null;
    private Long expiryDelay = null;
    private Long minExpiryDelay = null;
    private Long maxExpiryDelay = null;
    private Boolean noExpiry = null;
    private Boolean defaultLastValueQueue = null;
    private SimpleString defaultLastValueKey = null;
    private Boolean defaultNonDestructive = null;
    private Boolean defaultExclusiveQueue = null;
    private Boolean defaultGroupRebalance = null;
    private Boolean defaultGroupRebalancePauseDispatch = null;
    private Integer defaultGroupBuckets = null;
    private SimpleString defaultGroupFirstKey = null;
    private Long redistributionDelay = null;
    private Boolean sendToDLAOnNoRoute = null;
    private Long slowConsumerThreshold = null;
    private SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit = DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT;
    private Long slowConsumerCheckPeriod = null;
    private SlowConsumerPolicy slowConsumerPolicy = null;
    @Deprecated
    private Boolean autoCreateJmsQueues = null;
    @Deprecated
    private Boolean autoDeleteJmsQueues = null;
    @Deprecated
    private Boolean autoCreateJmsTopics = null;
    @Deprecated
    private Boolean autoDeleteJmsTopics = null;
    private Boolean autoCreateQueues = null;
    private Boolean autoDeleteQueues = null;
    private Boolean autoDeleteCreatedQueues = null;
    private Long autoDeleteQueuesDelay = null;
    private Boolean autoDeleteQueuesSkipUsageCheck = null;
    private Long autoDeleteQueuesMessageCount = null;
    private Long defaultRingSize = null;
    private Long retroactiveMessageCount = null;
    private DeletionPolicy configDeleteQueues = null;
    private Boolean autoCreateAddresses = null;
    private Boolean autoDeleteAddresses = null;
    private Long autoDeleteAddressesDelay = null;
    private Boolean autoDeleteAddressesSkipUsageCheck = null;
    private DeletionPolicy configDeleteAddresses = null;
    private DeletionPolicy configDeleteDiverts = null;
    private Integer managementBrowsePageSize = 200;
    private Long maxSizeBytesRejectThreshold = null;
    private Integer defaultMaxConsumers = null;
    private Boolean defaultPurgeOnNoConsumers = null;
    private Integer defaultConsumersBeforeDispatch = null;
    private Long defaultDelayBeforeDispatch = null;
    private RoutingType defaultQueueRoutingType = null;
    private RoutingType defaultAddressRoutingType = null;
    private Integer defaultConsumerWindowSize = null;
    private Boolean autoCreateDeadLetterResources = null;
    private SimpleString deadLetterQueuePrefix = null;
    private SimpleString deadLetterQueueSuffix = null;
    private Boolean autoCreateExpiryResources = null;
    private SimpleString expiryQueuePrefix = null;
    private SimpleString expiryQueueSuffix = null;
    private Boolean enableMetrics = null;
    private Integer managementMessageAttributeSizeLimit = null;
    private Boolean enableIngressTimestamp = null;
    private Integer idCacheSize = null;
    private Integer initialQueueBufferSize = null;
    @Deprecated
    private transient Integer queuePrefetch = null;

    public AddressSettings(AddressSettings other) {
        metaBean.copy((Object)other, (Object)this);
    }

    public AddressSettings() {
    }

    @Deprecated
    public boolean isAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues != null ? this.autoCreateJmsQueues : true;
    }

    public String toJSON() {
        return metaBean.toJSON((Object)this, true).toString();
    }

    public static AddressSettings fromJSON(String jsonString) {
        AddressSettings newSettings = new AddressSettings();
        metaBean.fromJSON((Object)newSettings, jsonString);
        return newSettings;
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsQueues(boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues != null ? this.autoDeleteJmsQueues : true;
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsQueues(boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        return this;
    }

    @Deprecated
    public boolean isAutoCreateJmsTopics() {
        return this.autoCreateJmsTopics != null ? this.autoCreateJmsTopics : true;
    }

    @Deprecated
    public AddressSettings setAutoCreateJmsTopics(boolean autoCreateJmsTopics) {
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        return this;
    }

    @Deprecated
    public boolean isAutoDeleteJmsTopics() {
        return this.autoDeleteJmsTopics != null ? this.autoDeleteJmsTopics : true;
    }

    @Deprecated
    public AddressSettings setAutoDeleteJmsTopics(boolean autoDeleteJmsTopics) {
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
        return this;
    }

    public Boolean isAutoCreateQueues() {
        return this.autoCreateQueues != null ? this.autoCreateQueues : true;
    }

    public AddressSettings setAutoCreateQueues(Boolean autoCreateQueues) {
        this.autoCreateQueues = autoCreateQueues;
        return this;
    }

    public Boolean isAutoDeleteQueues() {
        return this.autoDeleteQueues != null ? this.autoDeleteQueues : true;
    }

    public AddressSettings setAutoDeleteQueues(Boolean autoDeleteQueues) {
        this.autoDeleteQueues = autoDeleteQueues;
        return this;
    }

    public AddressSettings setAutoDeleteCreatedQueues(Boolean autoDeleteCreatedQueues) {
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
        return this;
    }

    public Boolean isAutoDeleteCreatedQueues() {
        return this.autoDeleteCreatedQueues != null ? this.autoDeleteCreatedQueues : false;
    }

    public long getAutoDeleteQueuesDelay() {
        return this.autoDeleteQueuesDelay != null ? this.autoDeleteQueuesDelay : 0L;
    }

    public AddressSettings setAutoDeleteQueuesDelay(long autoDeleteQueuesDelay) {
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
        return this;
    }

    public boolean getAutoDeleteQueuesSkipUsageCheck() {
        return this.autoDeleteQueuesSkipUsageCheck != null ? this.autoDeleteQueuesSkipUsageCheck : false;
    }

    public AddressSettings setAutoDeleteQueuesSkipUsageCheck(boolean autoDeleteQueuesSkipUsageCheck) {
        this.autoDeleteQueuesSkipUsageCheck = autoDeleteQueuesSkipUsageCheck;
        return this;
    }

    public long getAutoDeleteQueuesMessageCount() {
        return this.autoDeleteQueuesMessageCount != null ? this.autoDeleteQueuesMessageCount : 0L;
    }

    public AddressSettings setAutoDeleteQueuesMessageCount(long autoDeleteQueuesMessageCount) {
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
        return this;
    }

    public DeletionPolicy getConfigDeleteQueues() {
        return this.configDeleteQueues != null ? this.configDeleteQueues : DEFAULT_CONFIG_DELETE_QUEUES;
    }

    public AddressSettings setConfigDeleteQueues(DeletionPolicy configDeleteQueues) {
        this.configDeleteQueues = configDeleteQueues;
        return this;
    }

    public Boolean isAutoCreateAddresses() {
        return this.autoCreateAddresses != null ? this.autoCreateAddresses : true;
    }

    public AddressSettings setAutoCreateAddresses(Boolean autoCreateAddresses) {
        this.autoCreateAddresses = autoCreateAddresses;
        return this;
    }

    public Boolean isAutoDeleteAddresses() {
        return this.autoDeleteAddresses != null ? this.autoDeleteAddresses : true;
    }

    public AddressSettings setAutoDeleteAddresses(Boolean autoDeleteAddresses) {
        this.autoDeleteAddresses = autoDeleteAddresses;
        return this;
    }

    public long getAutoDeleteAddressesDelay() {
        return this.autoDeleteAddressesDelay != null ? this.autoDeleteAddressesDelay : 0L;
    }

    public AddressSettings setAutoDeleteAddressesDelay(long autoDeleteAddressesDelay) {
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
        return this;
    }

    public boolean isAutoDeleteAddressesSkipUsageCheck() {
        return this.autoDeleteAddressesSkipUsageCheck != null ? this.autoDeleteAddressesSkipUsageCheck : false;
    }

    public AddressSettings setAutoDeleteAddressesSkipUsageCheck(boolean autoDeleteAddressesSkipUsageCheck) {
        this.autoDeleteAddressesSkipUsageCheck = autoDeleteAddressesSkipUsageCheck;
        return this;
    }

    public DeletionPolicy getConfigDeleteAddresses() {
        return this.configDeleteAddresses != null ? this.configDeleteAddresses : DEFAULT_CONFIG_DELETE_ADDRESSES;
    }

    public AddressSettings setConfigDeleteAddresses(DeletionPolicy configDeleteAddresses) {
        this.configDeleteAddresses = configDeleteAddresses;
        return this;
    }

    public AddressSettings setConfigDeleteDiverts(DeletionPolicy configDeleteDiverts) {
        this.configDeleteDiverts = configDeleteDiverts;
        return this;
    }

    public DeletionPolicy getConfigDeleteDiverts() {
        return this.configDeleteDiverts != null ? this.configDeleteDiverts : DEFAULT_CONFIG_DELETE_DIVERTS;
    }

    public Integer getDefaultMaxConsumers() {
        return this.defaultMaxConsumers != null ? this.defaultMaxConsumers : ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers();
    }

    public AddressSettings setDefaultMaxConsumers(Integer defaultMaxConsumers) {
        this.defaultMaxConsumers = defaultMaxConsumers;
        return this;
    }

    public Integer getDefaultConsumersBeforeDispatch() {
        return this.defaultConsumersBeforeDispatch != null ? this.defaultConsumersBeforeDispatch : ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch();
    }

    public AddressSettings setDefaultConsumersBeforeDispatch(Integer defaultConsumersBeforeDispatch) {
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        return this;
    }

    public Long getDefaultDelayBeforeDispatch() {
        return this.defaultDelayBeforeDispatch != null ? this.defaultDelayBeforeDispatch : ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch();
    }

    public AddressSettings setDefaultDelayBeforeDispatch(Long defaultDelayBeforeDispatch) {
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        return this;
    }

    public Boolean isDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers != null ? this.defaultPurgeOnNoConsumers : ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
    }

    public AddressSettings setDefaultPurgeOnNoConsumers(Boolean defaultPurgeOnNoConsumers) {
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        return this;
    }

    public RoutingType getDefaultQueueRoutingType() {
        return this.defaultQueueRoutingType != null ? this.defaultQueueRoutingType : ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }

    public AddressSettings setDefaultQueueRoutingType(RoutingType defaultQueueRoutingType) {
        this.defaultQueueRoutingType = defaultQueueRoutingType;
        return this;
    }

    public RoutingType getDefaultAddressRoutingType() {
        return this.defaultAddressRoutingType != null ? this.defaultAddressRoutingType : ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }

    public AddressSettings setDefaultAddressRoutingType(RoutingType defaultAddressRoutingType) {
        this.defaultAddressRoutingType = defaultAddressRoutingType;
        return this;
    }

    public boolean isDefaultLastValueQueue() {
        return this.defaultLastValueQueue != null ? this.defaultLastValueQueue : false;
    }

    public AddressSettings setDefaultLastValueQueue(boolean defaultLastValueQueue) {
        this.defaultLastValueQueue = defaultLastValueQueue;
        return this;
    }

    public SimpleString getDefaultLastValueKey() {
        return this.defaultLastValueKey != null ? this.defaultLastValueKey : ActiveMQDefaultConfiguration.getDefaultLastValueKey();
    }

    public AddressSettings setDefaultLastValueKey(SimpleString defaultLastValueKey) {
        this.defaultLastValueKey = defaultLastValueKey;
        return this;
    }

    public boolean isDefaultNonDestructive() {
        return this.defaultNonDestructive != null ? this.defaultNonDestructive : ActiveMQDefaultConfiguration.getDefaultNonDestructive();
    }

    public AddressSettings setDefaultNonDestructive(boolean defaultNonDestructive) {
        this.defaultNonDestructive = defaultNonDestructive;
        return this;
    }

    public Boolean isDefaultExclusiveQueue() {
        return this.defaultExclusiveQueue != null ? this.defaultExclusiveQueue : ActiveMQDefaultConfiguration.getDefaultExclusive();
    }

    public AddressSettings setDefaultExclusiveQueue(Boolean defaultExclusiveQueue) {
        this.defaultExclusiveQueue = defaultExclusiveQueue;
        return this;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy : DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
    }

    public AddressSettings setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        return this;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes != null ? this.pageSizeBytes : 0xA00000;
    }

    public AddressSettings setPageSizeBytes(int pageSize) {
        this.pageSizeBytes = this.testForNull(pageSize);
        return this;
    }

    public int getPageCacheMaxSize() {
        return this.pageCacheMaxSize != null ? this.pageCacheMaxSize : 5;
    }

    public AddressSettings setPageCacheMaxSize(int pageCacheMaxSize) {
        this.pageCacheMaxSize = pageCacheMaxSize;
        return this;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes != null ? this.maxSizeBytes : -1L;
    }

    public long getMaxSizeMessages() {
        return this.maxSizeMessages != null ? this.maxSizeMessages : -1L;
    }

    private Integer testForNull(int value) {
        return value < 0 ? null : Integer.valueOf(value);
    }

    public AddressSettings setMaxSizeMessages(long maxSizeMessages) {
        this.maxSizeMessages = maxSizeMessages;
        return this;
    }

    public AddressSettings setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public int getMaxReadPageMessages() {
        return this.maxReadPageMessages != null ? this.maxReadPageMessages : -1;
    }

    public AddressSettings setMaxReadPageMessages(int maxReadPageMessages) {
        this.maxReadPageMessages = maxReadPageMessages;
        return this;
    }

    public int getPrefetchPageMessages() {
        return this.prefetchPageMessages != null ? this.prefetchPageMessages.intValue() : this.getMaxReadPageMessages();
    }

    public AddressSettings setPrefetchPageMessages(int prefetchPageMessages) {
        this.prefetchPageMessages = prefetchPageMessages <= 0 ? null : Integer.valueOf(prefetchPageMessages);
        return this;
    }

    public Long getPageLimitBytes() {
        return this.pageLimitBytes;
    }

    public AddressSettings setPageLimitBytes(Long pageLimitBytes) {
        this.pageLimitBytes = pageLimitBytes;
        return this;
    }

    public Long getPageLimitMessages() {
        return this.pageLimitMessages;
    }

    public AddressSettings setPageLimitMessages(Long pageLimitMessages) {
        this.pageLimitMessages = pageLimitMessages;
        return this;
    }

    public PageFullMessagePolicy getPageFullMessagePolicy() {
        return this.pageFullMessagePolicy;
    }

    public AddressSettings setPageFullMessagePolicy(PageFullMessagePolicy policy) {
        this.pageFullMessagePolicy = policy;
        return this;
    }

    public int getMaxReadPageBytes() {
        return this.maxReadPageBytes != null ? this.maxReadPageBytes : 2 * this.getPageSizeBytes();
    }

    public AddressSettings setMaxReadPageBytes(int maxReadPageBytes) {
        this.maxReadPageBytes = maxReadPageBytes;
        return this;
    }

    public int getPrefetchPageBytes() {
        return this.prefetchPageBytes != null ? this.prefetchPageBytes.intValue() : this.getMaxReadPageBytes();
    }

    public AddressSettings setPrefetchPageBytes(int prefetchPageBytes) {
        this.prefetchPageBytes = prefetchPageBytes <= 0 ? null : Integer.valueOf(prefetchPageBytes);
        return this;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts : 10;
    }

    public AddressSettings setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit : 0;
    }

    public AddressSettings setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
        return this;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay != null ? this.redeliveryDelay : 0L;
    }

    public AddressSettings setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier != null ? this.redeliveryMultiplier : 1.0;
    }

    public AddressSettings setRedeliveryMultiplier(double redeliveryMultiplier) {
        this.redeliveryMultiplier = redeliveryMultiplier;
        return this;
    }

    public double getRedeliveryCollisionAvoidanceFactor() {
        return this.redeliveryCollisionAvoidanceFactor != null ? this.redeliveryCollisionAvoidanceFactor : 0.0;
    }

    public AddressSettings setRedeliveryCollisionAvoidanceFactor(double redeliveryCollisionAvoidanceFactor) {
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
        return this;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay != null ? this.maxRedeliveryDelay : this.getRedeliveryDelay() * 10L;
    }

    public AddressSettings setMaxRedeliveryDelay(long maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        return this;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public AddressSettings setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
        return this;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public AddressSettings setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
        return this;
    }

    public boolean isAutoCreateExpiryResources() {
        return this.autoCreateExpiryResources != null ? this.autoCreateExpiryResources : false;
    }

    public AddressSettings setAutoCreateExpiryResources(boolean value) {
        this.autoCreateExpiryResources = value;
        return this;
    }

    public SimpleString getExpiryQueuePrefix() {
        return this.expiryQueuePrefix != null ? this.expiryQueuePrefix : DEFAULT_EXPIRY_QUEUE_PREFIX;
    }

    public AddressSettings setExpiryQueuePrefix(SimpleString value) {
        this.expiryQueuePrefix = value;
        return this;
    }

    public SimpleString getExpiryQueueSuffix() {
        return this.expiryQueueSuffix != null ? this.expiryQueueSuffix : DEFAULT_EXPIRY_QUEUE_SUFFIX;
    }

    public AddressSettings setExpiryQueueSuffix(SimpleString value) {
        this.expiryQueueSuffix = value;
        return this;
    }

    public Long getExpiryDelay() {
        return this.expiryDelay != null ? this.expiryDelay : -1L;
    }

    public AddressSettings setExpiryDelay(Long expiryDelay) {
        this.expiryDelay = expiryDelay;
        return this;
    }

    public Long getMinExpiryDelay() {
        return this.minExpiryDelay != null ? this.minExpiryDelay : -1L;
    }

    public AddressSettings setMinExpiryDelay(Long minExpiryDelay) {
        this.minExpiryDelay = minExpiryDelay;
        return this;
    }

    public Long getMaxExpiryDelay() {
        return this.maxExpiryDelay != null ? this.maxExpiryDelay : -1L;
    }

    public AddressSettings setMaxExpiryDelay(Long maxExpiryDelay) {
        this.maxExpiryDelay = maxExpiryDelay;
        return this;
    }

    public Boolean isNoExpiry() {
        return this.noExpiry != null ? this.noExpiry : false;
    }

    public AddressSettings setNoExpiry(Boolean noExpiry) {
        this.noExpiry = noExpiry;
        return this;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute : false;
    }

    public AddressSettings setSendToDLAOnNoRoute(boolean value) {
        this.sendToDLAOnNoRoute = value;
        return this;
    }

    public boolean isAutoCreateDeadLetterResources() {
        return this.autoCreateDeadLetterResources != null ? this.autoCreateDeadLetterResources : false;
    }

    public AddressSettings setAutoCreateDeadLetterResources(boolean value) {
        this.autoCreateDeadLetterResources = value;
        return this;
    }

    public SimpleString getDeadLetterQueuePrefix() {
        return this.deadLetterQueuePrefix != null ? this.deadLetterQueuePrefix : DEFAULT_DEAD_LETTER_QUEUE_PREFIX;
    }

    public AddressSettings setDeadLetterQueuePrefix(SimpleString value) {
        this.deadLetterQueuePrefix = value;
        return this;
    }

    public SimpleString getDeadLetterQueueSuffix() {
        return this.deadLetterQueueSuffix != null ? this.deadLetterQueueSuffix : DEFAULT_DEAD_LETTER_QUEUE_SUFFIX;
    }

    public AddressSettings setDeadLetterQueueSuffix(SimpleString value) {
        this.deadLetterQueueSuffix = value;
        return this;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay != null ? this.redistributionDelay : -1L;
    }

    public AddressSettings setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
        return this;
    }

    public long getSlowConsumerThreshold() {
        return this.slowConsumerThreshold != null ? this.slowConsumerThreshold : -1L;
    }

    public AddressSettings setSlowConsumerThreshold(long slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
        return this;
    }

    public SlowConsumerThresholdMeasurementUnit getSlowConsumerThresholdMeasurementUnit() {
        return this.slowConsumerThresholdMeasurementUnit != null ? this.slowConsumerThresholdMeasurementUnit : DEFAULT_SLOW_CONSUMER_THRESHOLD_MEASUREMENT_UNIT;
    }

    public AddressSettings setSlowConsumerThresholdMeasurementUnit(SlowConsumerThresholdMeasurementUnit slowConsumerThresholdMeasurementUnit) {
        this.slowConsumerThresholdMeasurementUnit = slowConsumerThresholdMeasurementUnit;
        return this;
    }

    public long getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod != null ? this.slowConsumerCheckPeriod : 5L;
    }

    public AddressSettings setSlowConsumerCheckPeriod(long slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        return this;
    }

    public SlowConsumerPolicy getSlowConsumerPolicy() {
        return this.slowConsumerPolicy != null ? this.slowConsumerPolicy : DEFAULT_SLOW_CONSUMER_POLICY;
    }

    public AddressSettings setSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
        return this;
    }

    public int getManagementBrowsePageSize() {
        return this.managementBrowsePageSize != null ? this.managementBrowsePageSize : 200;
    }

    public AddressSettings setManagementBrowsePageSize(int managementBrowsePageSize) {
        this.managementBrowsePageSize = managementBrowsePageSize;
        return this;
    }

    @Deprecated
    public int getQueuePrefetch() {
        return this.queuePrefetch != null ? this.queuePrefetch : 1000;
    }

    @Deprecated
    public AddressSettings setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = queuePrefetch;
        return this;
    }

    public long getMaxSizeBytesRejectThreshold() {
        return this.maxSizeBytesRejectThreshold == null ? -1L : this.maxSizeBytesRejectThreshold;
    }

    public AddressSettings setMaxSizeBytesRejectThreshold(long maxSizeBytesRejectThreshold) {
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
        return this;
    }

    public int getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize != null ? this.defaultConsumerWindowSize : 0x100000;
    }

    public AddressSettings setDefaultConsumerWindowSize(int defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        return this;
    }

    public boolean isDefaultGroupRebalance() {
        return this.defaultGroupRebalance != null ? this.defaultGroupRebalance : ActiveMQDefaultConfiguration.getDefaultGroupRebalance();
    }

    public AddressSettings setDefaultGroupRebalance(boolean defaultGroupRebalance) {
        this.defaultGroupRebalance = defaultGroupRebalance;
        return this;
    }

    public boolean isDefaultGroupRebalancePauseDispatch() {
        return this.defaultGroupRebalancePauseDispatch != null ? this.defaultGroupRebalancePauseDispatch : ActiveMQDefaultConfiguration.getDefaultGroupRebalancePauseDispatch();
    }

    public AddressSettings setDefaultGroupRebalancePauseDispatch(boolean defaultGroupRebalancePauseDispatch) {
        this.defaultGroupRebalancePauseDispatch = defaultGroupRebalancePauseDispatch;
        return this;
    }

    public int getDefaultGroupBuckets() {
        return this.defaultGroupBuckets != null ? this.defaultGroupBuckets : ActiveMQDefaultConfiguration.getDefaultGroupBuckets();
    }

    public SimpleString getDefaultGroupFirstKey() {
        return this.defaultGroupFirstKey != null ? this.defaultGroupFirstKey : ActiveMQDefaultConfiguration.getDefaultGroupFirstKey();
    }

    public AddressSettings setDefaultGroupFirstKey(SimpleString defaultGroupFirstKey) {
        this.defaultGroupFirstKey = defaultGroupFirstKey;
        return this;
    }

    public AddressSettings setDefaultGroupBuckets(int defaultGroupBuckets) {
        this.defaultGroupBuckets = defaultGroupBuckets;
        return this;
    }

    public long getDefaultRingSize() {
        return this.defaultRingSize != null ? this.defaultRingSize : -1L;
    }

    public AddressSettings setDefaultRingSize(long defaultRingSize) {
        this.defaultRingSize = defaultRingSize;
        return this;
    }

    public long getRetroactiveMessageCount() {
        return this.retroactiveMessageCount != null ? this.retroactiveMessageCount : 0L;
    }

    public AddressSettings setRetroactiveMessageCount(long defaultRetroactiveMessageCount) {
        this.retroactiveMessageCount = defaultRetroactiveMessageCount;
        return this;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics != null ? this.enableMetrics : true;
    }

    public AddressSettings setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return this;
    }

    public int getManagementMessageAttributeSizeLimit() {
        return this.managementMessageAttributeSizeLimit != null ? this.managementMessageAttributeSizeLimit : 256;
    }

    public AddressSettings setManagementMessageAttributeSizeLimit(int managementMessageAttributeSizeLimit) {
        this.managementMessageAttributeSizeLimit = managementMessageAttributeSizeLimit;
        return this;
    }

    public boolean isEnableIngressTimestamp() {
        return this.enableIngressTimestamp != null ? this.enableIngressTimestamp : false;
    }

    public AddressSettings setEnableIngressTimestamp(boolean enableIngressTimestamp) {
        this.enableIngressTimestamp = enableIngressTimestamp;
        return this;
    }

    public Integer getIDCacheSize() {
        return this.idCacheSize;
    }

    public AddressSettings setIDCacheSize(Integer idCacheSize) {
        this.idCacheSize = idCacheSize;
        return this;
    }

    public Integer getInitialQueueBufferSize() {
        return this.initialQueueBufferSize;
    }

    public AddressSettings setInitialQueueBufferSize(Integer initialQueueBufferSize) {
        this.initialQueueBufferSize = initialQueueBufferSize;
        return this;
    }

    @Override
    public void merge(AddressSettings merged) {
        metaBean.forEach((type, name, setter, getter, gate) -> {
            if (getter.apply(this) == null) {
                setter.accept(this, getter.apply(merged));
            }
        });
    }

    @Override
    public AddressSettings mergeCopy(AddressSettings merged) {
        AddressSettings target = new AddressSettings();
        metaBean.forEach((type, name, setter, getter, gate) -> {
            Object sourceValue = getter.apply(this);
            if (sourceValue != null) {
                setter.accept(target, sourceValue);
            } else {
                setter.accept(target, getter.apply(merged));
            }
        });
        return target;
    }

    public void decode(ActiveMQBuffer buffer) {
        int original = buffer.readerIndex();
        try {
            this.decode(buffer, false);
        }
        catch (Throwable e) {
            buffer.readerIndex(original);
            this.decode(buffer, true);
        }
    }

    public void decode(ActiveMQBuffer buffer, boolean tryCompatible) {
        Integer slowConsumerMeasurementUnitEnumValue;
        SimpleString policyStr = buffer.readNullableSimpleString();
        this.addressFullMessagePolicy = policyStr != null ? AddressFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        this.maxSizeBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        Long pageSizeLong = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.pageSizeBytes = pageSizeLong == null ? null : Integer.valueOf(pageSizeLong.intValue());
        this.pageCacheMaxSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.dropMessagesWhenFull = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.maxDeliveryAttempts = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.messageCounterHistoryDayLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.redeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.redeliveryMultiplier = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        this.maxRedeliveryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.deadLetterAddress = buffer.readNullableSimpleString();
        this.expiryAddress = buffer.readNullableSimpleString();
        this.expiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultLastValueQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.redistributionDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.sendToDLAOnNoRoute = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.slowConsumerThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.slowConsumerCheckPeriod = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        policyStr = buffer.readNullableSimpleString();
        this.slowConsumerPolicy = policyStr != null ? SlowConsumerPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteJmsTopics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoCreateQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteQueues = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.autoCreateAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.autoDeleteAddresses = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
        this.configDeleteAddresses = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        this.managementBrowsePageSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxSizeBytesRejectThreshold = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        this.defaultMaxConsumers = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.defaultPurgeOnNoConsumers = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        this.defaultQueueRoutingType = RoutingType.getType((byte)buffer.readByte());
        this.defaultAddressRoutingType = RoutingType.getType((byte)buffer.readByte());
        if (buffer.readableBytes() > 0) {
            this.defaultExclusiveQueue = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumersBeforeDispatch = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultDelayBeforeDispatch = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultConsumerWindowSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultLastValueKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.defaultNonDestructive = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteAddressesDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalance = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupBuckets = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteCreatedQueues = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultRingSize = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.redeliveryCollisionAvoidanceFactor = BufferHelper.readNullableDouble((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.retroactiveMessageCount = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateDeadLetterResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.deadLetterQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.autoCreateExpiryResources = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueuePrefix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.expiryQueueSuffix = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.minExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxExpiryDelay = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.enableMetrics = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.defaultGroupRebalancePauseDispatch = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.managementMessageAttributeSizeLimit = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0 && (slowConsumerMeasurementUnitEnumValue = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer)) != null) {
            this.slowConsumerThresholdMeasurementUnit = SlowConsumerThresholdMeasurementUnit.valueOf(slowConsumerMeasurementUnitEnumValue);
        }
        if (buffer.readableBytes() > 0) {
            this.enableIngressTimestamp = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            policyStr = tryCompatible ? null : buffer.readNullableSimpleString();
            this.configDeleteDiverts = policyStr != null ? DeletionPolicy.valueOf(policyStr.toString()) : null;
        }
        if (buffer.readableBytes() > 0) {
            this.maxSizeMessages = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxReadPageBytes = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.maxReadPageMessages = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.pageLimitBytes = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.pageLimitMessages = BufferHelper.readNullableLong((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            policyStr = buffer.readNullableSimpleString();
            this.pageFullMessagePolicy = policyStr != null ? PageFullMessagePolicy.valueOf((String)policyStr.toString()) : null;
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteQueuesSkipUsageCheck = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.autoDeleteAddressesSkipUsageCheck = BufferHelper.readNullableBoolean((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.idCacheSize = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.prefetchPageBytes = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.prefetchPageMessages = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        }
    }

    public int getEncodeSize() {
        throw new UnsupportedOperationException("Encode of AddressSettings is no longer supported, please use JSON method and PersistAddressSettingJSON");
    }

    public void encode(ActiveMQBuffer buffer) {
        throw new UnsupportedOperationException("Encode of AddressSettings is no longer supported, please use JSON method and PersistAddressSettingJSON");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressSettings that = (AddressSettings)o;
        if (this.addressFullMessagePolicy != that.addressFullMessagePolicy) {
            return false;
        }
        if (!Objects.equals(this.maxSizeBytes, that.maxSizeBytes)) {
            return false;
        }
        if (!Objects.equals(this.maxReadPageBytes, that.maxReadPageBytes)) {
            return false;
        }
        if (!Objects.equals(this.maxReadPageMessages, that.maxReadPageMessages)) {
            return false;
        }
        if (!Objects.equals(this.prefetchPageBytes, that.prefetchPageBytes)) {
            return false;
        }
        if (!Objects.equals(this.prefetchPageMessages, that.prefetchPageMessages)) {
            return false;
        }
        if (!Objects.equals(this.pageLimitBytes, that.pageLimitBytes)) {
            return false;
        }
        if (!Objects.equals(this.pageLimitMessages, that.pageLimitMessages)) {
            return false;
        }
        if (this.pageFullMessagePolicy != that.pageFullMessagePolicy) {
            return false;
        }
        if (!Objects.equals(this.maxSizeMessages, that.maxSizeMessages)) {
            return false;
        }
        if (!Objects.equals(this.pageSizeBytes, that.pageSizeBytes)) {
            return false;
        }
        if (!Objects.equals(this.pageCacheMaxSize, that.pageCacheMaxSize)) {
            return false;
        }
        if (!Objects.equals(this.dropMessagesWhenFull, that.dropMessagesWhenFull)) {
            return false;
        }
        if (!Objects.equals(this.maxDeliveryAttempts, that.maxDeliveryAttempts)) {
            return false;
        }
        if (!Objects.equals(this.messageCounterHistoryDayLimit, that.messageCounterHistoryDayLimit)) {
            return false;
        }
        if (!Objects.equals(this.redeliveryDelay, that.redeliveryDelay)) {
            return false;
        }
        if (!Objects.equals(this.redeliveryMultiplier, that.redeliveryMultiplier)) {
            return false;
        }
        if (!Objects.equals(this.redeliveryCollisionAvoidanceFactor, that.redeliveryCollisionAvoidanceFactor)) {
            return false;
        }
        if (!Objects.equals(this.maxRedeliveryDelay, that.maxRedeliveryDelay)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterAddress, that.deadLetterAddress)) {
            return false;
        }
        if (!Objects.equals(this.expiryAddress, that.expiryAddress)) {
            return false;
        }
        if (!Objects.equals(this.expiryDelay, that.expiryDelay)) {
            return false;
        }
        if (!Objects.equals(this.minExpiryDelay, that.minExpiryDelay)) {
            return false;
        }
        if (!Objects.equals(this.maxExpiryDelay, that.maxExpiryDelay)) {
            return false;
        }
        if (!Objects.equals(this.noExpiry, that.noExpiry)) {
            return false;
        }
        if (!Objects.equals(this.defaultLastValueQueue, that.defaultLastValueQueue)) {
            return false;
        }
        if (!Objects.equals(this.defaultLastValueKey, that.defaultLastValueKey)) {
            return false;
        }
        if (!Objects.equals(this.defaultNonDestructive, that.defaultNonDestructive)) {
            return false;
        }
        if (!Objects.equals(this.defaultExclusiveQueue, that.defaultExclusiveQueue)) {
            return false;
        }
        if (!Objects.equals(this.defaultGroupRebalance, that.defaultGroupRebalance)) {
            return false;
        }
        if (!Objects.equals(this.defaultGroupRebalancePauseDispatch, that.defaultGroupRebalancePauseDispatch)) {
            return false;
        }
        if (!Objects.equals(this.defaultGroupBuckets, that.defaultGroupBuckets)) {
            return false;
        }
        if (!Objects.equals(this.defaultGroupFirstKey, that.defaultGroupFirstKey)) {
            return false;
        }
        if (!Objects.equals(this.redistributionDelay, that.redistributionDelay)) {
            return false;
        }
        if (!Objects.equals(this.sendToDLAOnNoRoute, that.sendToDLAOnNoRoute)) {
            return false;
        }
        if (!Objects.equals(this.slowConsumerThreshold, that.slowConsumerThreshold)) {
            return false;
        }
        if (this.slowConsumerThresholdMeasurementUnit != that.slowConsumerThresholdMeasurementUnit) {
            return false;
        }
        if (!Objects.equals(this.slowConsumerCheckPeriod, that.slowConsumerCheckPeriod)) {
            return false;
        }
        if (this.slowConsumerPolicy != that.slowConsumerPolicy) {
            return false;
        }
        if (!Objects.equals(this.autoCreateJmsQueues, that.autoCreateJmsQueues)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteJmsQueues, that.autoDeleteJmsQueues)) {
            return false;
        }
        if (!Objects.equals(this.autoCreateJmsTopics, that.autoCreateJmsTopics)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteJmsTopics, that.autoDeleteJmsTopics)) {
            return false;
        }
        if (!Objects.equals(this.autoCreateQueues, that.autoCreateQueues)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteQueues, that.autoDeleteQueues)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteCreatedQueues, that.autoDeleteCreatedQueues)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteQueuesDelay, that.autoDeleteQueuesDelay)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteQueuesSkipUsageCheck, that.autoDeleteQueuesSkipUsageCheck)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteQueuesMessageCount, that.autoDeleteQueuesMessageCount)) {
            return false;
        }
        if (!Objects.equals(this.defaultRingSize, that.defaultRingSize)) {
            return false;
        }
        if (!Objects.equals(this.retroactiveMessageCount, that.retroactiveMessageCount)) {
            return false;
        }
        if (this.configDeleteQueues != that.configDeleteQueues) {
            return false;
        }
        if (!Objects.equals(this.autoCreateAddresses, that.autoCreateAddresses)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteAddresses, that.autoDeleteAddresses)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteAddressesDelay, that.autoDeleteAddressesDelay)) {
            return false;
        }
        if (!Objects.equals(this.autoDeleteAddressesSkipUsageCheck, that.autoDeleteAddressesSkipUsageCheck)) {
            return false;
        }
        if (this.configDeleteAddresses != that.configDeleteAddresses) {
            return false;
        }
        if (this.configDeleteDiverts != that.configDeleteDiverts) {
            return false;
        }
        if (!Objects.equals(this.managementBrowsePageSize, that.managementBrowsePageSize)) {
            return false;
        }
        if (!Objects.equals(this.maxSizeBytesRejectThreshold, that.maxSizeBytesRejectThreshold)) {
            return false;
        }
        if (!Objects.equals(this.defaultMaxConsumers, that.defaultMaxConsumers)) {
            return false;
        }
        if (!Objects.equals(this.defaultPurgeOnNoConsumers, that.defaultPurgeOnNoConsumers)) {
            return false;
        }
        if (!Objects.equals(this.defaultConsumersBeforeDispatch, that.defaultConsumersBeforeDispatch)) {
            return false;
        }
        if (!Objects.equals(this.defaultDelayBeforeDispatch, that.defaultDelayBeforeDispatch)) {
            return false;
        }
        if (this.defaultQueueRoutingType != that.defaultQueueRoutingType) {
            return false;
        }
        if (this.defaultAddressRoutingType != that.defaultAddressRoutingType) {
            return false;
        }
        if (!Objects.equals(this.defaultConsumerWindowSize, that.defaultConsumerWindowSize)) {
            return false;
        }
        if (!Objects.equals(this.autoCreateDeadLetterResources, that.autoCreateDeadLetterResources)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterQueuePrefix, that.deadLetterQueuePrefix)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterQueueSuffix, that.deadLetterQueueSuffix)) {
            return false;
        }
        if (!Objects.equals(this.autoCreateExpiryResources, that.autoCreateExpiryResources)) {
            return false;
        }
        if (!Objects.equals(this.expiryQueuePrefix, that.expiryQueuePrefix)) {
            return false;
        }
        if (!Objects.equals(this.expiryQueueSuffix, that.expiryQueueSuffix)) {
            return false;
        }
        if (!Objects.equals(this.enableMetrics, that.enableMetrics)) {
            return false;
        }
        if (!Objects.equals(this.managementMessageAttributeSizeLimit, that.managementMessageAttributeSizeLimit)) {
            return false;
        }
        if (!Objects.equals(this.enableIngressTimestamp, that.enableIngressTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.idCacheSize, that.idCacheSize)) {
            return false;
        }
        if (!Objects.equals(this.initialQueueBufferSize, that.initialQueueBufferSize)) {
            return false;
        }
        return Objects.equals(this.queuePrefetch, that.queuePrefetch);
    }

    public int hashCode() {
        int result = this.addressFullMessagePolicy != null ? this.addressFullMessagePolicy.hashCode() : 0;
        result = 31 * result + (this.maxSizeBytes != null ? this.maxSizeBytes.hashCode() : 0);
        result = 31 * result + (this.maxReadPageBytes != null ? this.maxReadPageBytes.hashCode() : 0);
        result = 31 * result + (this.maxReadPageMessages != null ? this.maxReadPageMessages.hashCode() : 0);
        result = 31 * result + (this.prefetchPageBytes != null ? this.prefetchPageBytes.hashCode() : 0);
        result = 31 * result + (this.prefetchPageMessages != null ? this.prefetchPageMessages.hashCode() : 0);
        result = 31 * result + (this.pageLimitBytes != null ? this.pageLimitBytes.hashCode() : 0);
        result = 31 * result + (this.pageLimitMessages != null ? this.pageLimitMessages.hashCode() : 0);
        result = 31 * result + (this.pageFullMessagePolicy != null ? this.pageFullMessagePolicy.hashCode() : 0);
        result = 31 * result + (this.maxSizeMessages != null ? this.maxSizeMessages.hashCode() : 0);
        result = 31 * result + (this.pageSizeBytes != null ? this.pageSizeBytes.hashCode() : 0);
        result = 31 * result + (this.pageCacheMaxSize != null ? this.pageCacheMaxSize.hashCode() : 0);
        result = 31 * result + (this.dropMessagesWhenFull != null ? this.dropMessagesWhenFull.hashCode() : 0);
        result = 31 * result + (this.maxDeliveryAttempts != null ? this.maxDeliveryAttempts.hashCode() : 0);
        result = 31 * result + (this.messageCounterHistoryDayLimit != null ? this.messageCounterHistoryDayLimit.hashCode() : 0);
        result = 31 * result + (this.redeliveryDelay != null ? this.redeliveryDelay.hashCode() : 0);
        result = 31 * result + (this.redeliveryMultiplier != null ? this.redeliveryMultiplier.hashCode() : 0);
        result = 31 * result + (this.redeliveryCollisionAvoidanceFactor != null ? this.redeliveryCollisionAvoidanceFactor.hashCode() : 0);
        result = 31 * result + (this.maxRedeliveryDelay != null ? this.maxRedeliveryDelay.hashCode() : 0);
        result = 31 * result + (this.deadLetterAddress != null ? this.deadLetterAddress.hashCode() : 0);
        result = 31 * result + (this.expiryAddress != null ? this.expiryAddress.hashCode() : 0);
        result = 31 * result + (this.expiryDelay != null ? this.expiryDelay.hashCode() : 0);
        result = 31 * result + (this.minExpiryDelay != null ? this.minExpiryDelay.hashCode() : 0);
        result = 31 * result + (this.maxExpiryDelay != null ? this.maxExpiryDelay.hashCode() : 0);
        result = 31 * result + (this.noExpiry != null ? this.noExpiry.hashCode() : 0);
        result = 31 * result + (this.defaultLastValueQueue != null ? this.defaultLastValueQueue.hashCode() : 0);
        result = 31 * result + (this.defaultLastValueKey != null ? this.defaultLastValueKey.hashCode() : 0);
        result = 31 * result + (this.defaultNonDestructive != null ? this.defaultNonDestructive.hashCode() : 0);
        result = 31 * result + (this.defaultExclusiveQueue != null ? this.defaultExclusiveQueue.hashCode() : 0);
        result = 31 * result + (this.defaultGroupRebalance != null ? this.defaultGroupRebalance.hashCode() : 0);
        result = 31 * result + (this.defaultGroupRebalancePauseDispatch != null ? this.defaultGroupRebalancePauseDispatch.hashCode() : 0);
        result = 31 * result + (this.defaultGroupBuckets != null ? this.defaultGroupBuckets.hashCode() : 0);
        result = 31 * result + (this.defaultGroupFirstKey != null ? this.defaultGroupFirstKey.hashCode() : 0);
        result = 31 * result + (this.redistributionDelay != null ? this.redistributionDelay.hashCode() : 0);
        result = 31 * result + (this.sendToDLAOnNoRoute != null ? this.sendToDLAOnNoRoute.hashCode() : 0);
        result = 31 * result + (this.slowConsumerThreshold != null ? this.slowConsumerThreshold.hashCode() : 0);
        result = 31 * result + (this.slowConsumerThresholdMeasurementUnit != null ? this.slowConsumerThresholdMeasurementUnit.hashCode() : 0);
        result = 31 * result + (this.slowConsumerCheckPeriod != null ? this.slowConsumerCheckPeriod.hashCode() : 0);
        result = 31 * result + (this.slowConsumerPolicy != null ? this.slowConsumerPolicy.hashCode() : 0);
        result = 31 * result + (this.autoCreateJmsQueues != null ? this.autoCreateJmsQueues.hashCode() : 0);
        result = 31 * result + (this.autoDeleteJmsQueues != null ? this.autoDeleteJmsQueues.hashCode() : 0);
        result = 31 * result + (this.autoCreateJmsTopics != null ? this.autoCreateJmsTopics.hashCode() : 0);
        result = 31 * result + (this.autoDeleteJmsTopics != null ? this.autoDeleteJmsTopics.hashCode() : 0);
        result = 31 * result + (this.autoCreateQueues != null ? this.autoCreateQueues.hashCode() : 0);
        result = 31 * result + (this.autoDeleteQueues != null ? this.autoDeleteQueues.hashCode() : 0);
        result = 31 * result + (this.autoDeleteCreatedQueues != null ? this.autoDeleteCreatedQueues.hashCode() : 0);
        result = 31 * result + (this.autoDeleteQueuesDelay != null ? this.autoDeleteQueuesDelay.hashCode() : 0);
        result = 31 * result + (this.autoDeleteQueuesSkipUsageCheck != null ? this.autoDeleteQueuesSkipUsageCheck.hashCode() : 0);
        result = 31 * result + (this.autoDeleteQueuesMessageCount != null ? this.autoDeleteQueuesMessageCount.hashCode() : 0);
        result = 31 * result + (this.defaultRingSize != null ? this.defaultRingSize.hashCode() : 0);
        result = 31 * result + (this.retroactiveMessageCount != null ? this.retroactiveMessageCount.hashCode() : 0);
        result = 31 * result + (this.configDeleteQueues != null ? this.configDeleteQueues.hashCode() : 0);
        result = 31 * result + (this.autoCreateAddresses != null ? this.autoCreateAddresses.hashCode() : 0);
        result = 31 * result + (this.autoDeleteAddresses != null ? this.autoDeleteAddresses.hashCode() : 0);
        result = 31 * result + (this.autoDeleteAddressesDelay != null ? this.autoDeleteAddressesDelay.hashCode() : 0);
        result = 31 * result + (this.autoDeleteAddressesSkipUsageCheck != null ? this.autoDeleteAddressesSkipUsageCheck.hashCode() : 0);
        result = 31 * result + (this.configDeleteAddresses != null ? this.configDeleteAddresses.hashCode() : 0);
        result = 31 * result + (this.configDeleteDiverts != null ? this.configDeleteDiverts.hashCode() : 0);
        result = 31 * result + (this.managementBrowsePageSize != null ? this.managementBrowsePageSize.hashCode() : 0);
        result = 31 * result + (this.maxSizeBytesRejectThreshold != null ? this.maxSizeBytesRejectThreshold.hashCode() : 0);
        result = 31 * result + (this.defaultMaxConsumers != null ? this.defaultMaxConsumers.hashCode() : 0);
        result = 31 * result + (this.defaultPurgeOnNoConsumers != null ? this.defaultPurgeOnNoConsumers.hashCode() : 0);
        result = 31 * result + (this.defaultConsumersBeforeDispatch != null ? this.defaultConsumersBeforeDispatch.hashCode() : 0);
        result = 31 * result + (this.defaultDelayBeforeDispatch != null ? this.defaultDelayBeforeDispatch.hashCode() : 0);
        result = 31 * result + (this.defaultQueueRoutingType != null ? this.defaultQueueRoutingType.hashCode() : 0);
        result = 31 * result + (this.defaultAddressRoutingType != null ? this.defaultAddressRoutingType.hashCode() : 0);
        result = 31 * result + (this.defaultConsumerWindowSize != null ? this.defaultConsumerWindowSize.hashCode() : 0);
        result = 31 * result + (this.autoCreateDeadLetterResources != null ? this.autoCreateDeadLetterResources.hashCode() : 0);
        result = 31 * result + (this.deadLetterQueuePrefix != null ? this.deadLetterQueuePrefix.hashCode() : 0);
        result = 31 * result + (this.deadLetterQueueSuffix != null ? this.deadLetterQueueSuffix.hashCode() : 0);
        result = 31 * result + (this.autoCreateExpiryResources != null ? this.autoCreateExpiryResources.hashCode() : 0);
        result = 31 * result + (this.expiryQueuePrefix != null ? this.expiryQueuePrefix.hashCode() : 0);
        result = 31 * result + (this.expiryQueueSuffix != null ? this.expiryQueueSuffix.hashCode() : 0);
        result = 31 * result + (this.enableMetrics != null ? this.enableMetrics.hashCode() : 0);
        result = 31 * result + (this.managementMessageAttributeSizeLimit != null ? this.managementMessageAttributeSizeLimit.hashCode() : 0);
        result = 31 * result + (this.enableIngressTimestamp != null ? this.enableIngressTimestamp.hashCode() : 0);
        result = 31 * result + (this.idCacheSize != null ? this.idCacheSize.hashCode() : 0);
        result = 31 * result + (this.queuePrefetch != null ? this.queuePrefetch.hashCode() : 0);
        result = 31 * result + (this.initialQueueBufferSize != null ? this.initialQueueBufferSize.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AddressSettings{addressFullMessagePolicy=" + String.valueOf(this.addressFullMessagePolicy) + ", maxSizeBytes=" + this.maxSizeBytes + ", maxReadPageBytes=" + this.maxReadPageBytes + ", maxReadPageMessages=" + this.maxReadPageMessages + ", prefetchPageBytes=" + this.prefetchPageBytes + ", prefetchPageMessages=" + this.prefetchPageMessages + ", pageLimitBytes=" + this.pageLimitBytes + ", pageLimitMessages=" + this.pageLimitMessages + ", pageFullMessagePolicy=" + String.valueOf(this.pageFullMessagePolicy) + ", maxSizeMessages=" + this.maxSizeMessages + ", pageSizeBytes=" + this.pageSizeBytes + ", pageMaxCache=" + this.pageCacheMaxSize + ", dropMessagesWhenFull=" + this.dropMessagesWhenFull + ", maxDeliveryAttempts=" + this.maxDeliveryAttempts + ", messageCounterHistoryDayLimit=" + this.messageCounterHistoryDayLimit + ", redeliveryDelay=" + this.redeliveryDelay + ", redeliveryMultiplier=" + this.redeliveryMultiplier + ", redeliveryCollisionAvoidanceFactor=" + this.redeliveryCollisionAvoidanceFactor + ", maxRedeliveryDelay=" + this.maxRedeliveryDelay + ", deadLetterAddress=" + String.valueOf(this.deadLetterAddress) + ", expiryAddress=" + String.valueOf(this.expiryAddress) + ", expiryDelay=" + this.expiryDelay + ", minExpiryDelay=" + this.minExpiryDelay + ", maxExpiryDelay=" + this.maxExpiryDelay + ", noExpiry=" + this.noExpiry + ", defaultLastValueQueue=" + this.defaultLastValueQueue + ", defaultLastValueKey=" + String.valueOf(this.defaultLastValueKey) + ", defaultNonDestructive=" + this.defaultNonDestructive + ", defaultExclusiveQueue=" + this.defaultExclusiveQueue + ", defaultGroupRebalance=" + this.defaultGroupRebalance + ", defaultGroupRebalancePauseDispatch=" + this.defaultGroupRebalancePauseDispatch + ", defaultGroupBuckets=" + this.defaultGroupBuckets + ", defaultGroupFirstKey=" + String.valueOf(this.defaultGroupFirstKey) + ", redistributionDelay=" + this.redistributionDelay + ", sendToDLAOnNoRoute=" + this.sendToDLAOnNoRoute + ", slowConsumerThreshold=" + this.slowConsumerThreshold + ", slowConsumerThresholdMeasurementUnit=" + String.valueOf((Object)this.slowConsumerThresholdMeasurementUnit) + ", slowConsumerCheckPeriod=" + this.slowConsumerCheckPeriod + ", slowConsumerPolicy=" + String.valueOf((Object)this.slowConsumerPolicy) + ", autoCreateJmsQueues=" + this.autoCreateJmsQueues + ", autoDeleteJmsQueues=" + this.autoDeleteJmsQueues + ", autoCreateJmsTopics=" + this.autoCreateJmsTopics + ", autoDeleteJmsTopics=" + this.autoDeleteJmsTopics + ", autoCreateQueues=" + this.autoCreateQueues + ", autoDeleteQueues=" + this.autoDeleteQueues + ", autoDeleteCreatedQueues=" + this.autoDeleteCreatedQueues + ", autoDeleteQueuesDelay=" + this.autoDeleteQueuesDelay + ", autoDeleteQueuesSkipUsageCheck=" + this.autoDeleteQueuesSkipUsageCheck + ", autoDeleteQueuesMessageCount=" + this.autoDeleteQueuesMessageCount + ", defaultRingSize=" + this.defaultRingSize + ", retroactiveMessageCount=" + this.retroactiveMessageCount + ", configDeleteQueues=" + String.valueOf((Object)this.configDeleteQueues) + ", autoCreateAddresses=" + this.autoCreateAddresses + ", autoDeleteAddresses=" + this.autoDeleteAddresses + ", autoDeleteAddressesDelay=" + this.autoDeleteAddressesDelay + ", autoDeleteAddressesSkipUsageCheck=" + this.autoDeleteAddressesSkipUsageCheck + ", configDeleteAddresses=" + String.valueOf((Object)this.configDeleteAddresses) + ", configDeleteDiverts=" + String.valueOf((Object)this.configDeleteDiverts) + ", managementBrowsePageSize=" + this.managementBrowsePageSize + ", maxSizeBytesRejectThreshold=" + this.maxSizeBytesRejectThreshold + ", defaultMaxConsumers=" + this.defaultMaxConsumers + ", defaultPurgeOnNoConsumers=" + this.defaultPurgeOnNoConsumers + ", defaultConsumersBeforeDispatch=" + this.defaultConsumersBeforeDispatch + ", defaultDelayBeforeDispatch=" + this.defaultDelayBeforeDispatch + ", defaultQueueRoutingType=" + String.valueOf(this.defaultQueueRoutingType) + ", defaultAddressRoutingType=" + String.valueOf(this.defaultAddressRoutingType) + ", defaultConsumerWindowSize=" + this.defaultConsumerWindowSize + ", autoCreateDeadLetterResources=" + this.autoCreateDeadLetterResources + ", deadLetterQueuePrefix=" + String.valueOf(this.deadLetterQueuePrefix) + ", deadLetterQueueSuffix=" + String.valueOf(this.deadLetterQueueSuffix) + ", autoCreateExpiryResources=" + this.autoCreateExpiryResources + ", expiryQueuePrefix=" + String.valueOf(this.expiryQueuePrefix) + ", expiryQueueSuffix=" + String.valueOf(this.expiryQueueSuffix) + ", enableMetrics=" + this.enableMetrics + ", managementMessageAttributeSizeLimit=" + this.managementMessageAttributeSizeLimit + ", enableIngressTimestamp=" + this.enableIngressTimestamp + ", idCacheSize=" + this.idCacheSize + ", queuePrefetch=" + this.queuePrefetch + ", initialQueueBufferSize=" + this.initialQueueBufferSize + "}";
    }

    static {
        metaBean.add(AddressFullMessagePolicy.class, "addressFullMessagePolicy", (t, p) -> {
            t.addressFullMessagePolicy = p;
        }, t -> t.addressFullMessagePolicy);
        metaBean.add(Long.class, "maxSizeBytes", (t, p) -> {
            t.maxSizeBytes = p;
        }, t -> t.maxSizeBytes);
        metaBean.add(Integer.class, "maxReadPageBytes", (t, p) -> {
            t.maxReadPageBytes = p;
        }, t -> t.maxReadPageBytes);
        metaBean.add(Integer.class, "maxReadPageMessages", (t, p) -> {
            t.maxReadPageMessages = p;
        }, t -> t.maxReadPageMessages);
        metaBean.add(Integer.class, "prefetchPageBytes", (t, p) -> {
            t.prefetchPageBytes = p;
        }, t -> t.prefetchPageBytes);
        metaBean.add(Integer.class, "prefetchPageMessages", (t, p) -> {
            t.prefetchPageMessages = p;
        }, t -> t.prefetchPageMessages);
        metaBean.add(Long.class, "pageLimitBytes", (t, p) -> {
            t.pageLimitBytes = p;
        }, t -> t.pageLimitBytes);
        metaBean.add(Long.class, "pageLimitMessages", (t, p) -> {
            t.pageLimitMessages = p;
        }, t -> t.pageLimitMessages);
        metaBean.add(PageFullMessagePolicy.class, "pageFullMessagePolicy", (t, p) -> {
            t.pageFullMessagePolicy = p;
        }, t -> t.pageFullMessagePolicy);
        metaBean.add(Long.class, "maxSizeMessages", (t, p) -> {
            t.maxSizeMessages = p;
        }, t -> t.maxSizeMessages);
        metaBean.add(Integer.class, "pageSizeBytes", (t, p) -> {
            t.pageSizeBytes = p;
        }, t -> t.pageSizeBytes);
        metaBean.add(Integer.class, "pageCacheMaxSize", (t, p) -> {
            t.pageCacheMaxSize = p;
        }, t -> t.pageCacheMaxSize);
        metaBean.add(Boolean.class, "dropMessagesWhenFull", (t, p) -> {
            t.dropMessagesWhenFull = p;
        }, t -> t.dropMessagesWhenFull);
        metaBean.add(Integer.class, "maxDeliveryAttempts", (t, p) -> {
            t.maxDeliveryAttempts = p;
        }, t -> t.maxDeliveryAttempts);
        metaBean.add(Integer.class, "messageCounterHistoryDayLimit", (t, p) -> {
            t.messageCounterHistoryDayLimit = p;
        }, t -> t.messageCounterHistoryDayLimit);
        metaBean.add(Long.class, "redeliveryDelay", (t, p) -> {
            t.redeliveryDelay = p;
        }, t -> t.redeliveryDelay);
        metaBean.add(Double.class, "redeliveryMultiplier", (t, p) -> {
            t.redeliveryMultiplier = p;
        }, t -> t.redeliveryMultiplier);
        metaBean.add(Double.class, "redeliveryCollisionAvoidanceFactor", (t, p) -> {
            t.redeliveryCollisionAvoidanceFactor = p;
        }, t -> t.redeliveryCollisionAvoidanceFactor);
        metaBean.add(Long.class, "maxRedeliveryDelay", (t, p) -> {
            t.maxRedeliveryDelay = p;
        }, t -> t.maxRedeliveryDelay);
        metaBean.add(SimpleString.class, "deadLetterAddress", (t, p) -> {
            t.deadLetterAddress = p;
        }, t -> t.deadLetterAddress);
        metaBean.add(SimpleString.class, "expiryAddress", (t, p) -> {
            t.expiryAddress = p;
        }, t -> t.expiryAddress);
        metaBean.add(Long.class, "expiryDelay", (t, p) -> {
            t.expiryDelay = p;
        }, t -> t.expiryDelay);
        metaBean.add(Long.class, "minExpiryDelay", (t, p) -> {
            t.minExpiryDelay = p;
        }, t -> t.minExpiryDelay);
        metaBean.add(Long.class, "maxExpiryDelay", (t, p) -> {
            t.maxExpiryDelay = p;
        }, t -> t.maxExpiryDelay);
        metaBean.add(Boolean.class, "noExpiry", (t, p) -> {
            t.noExpiry = p;
        }, t -> t.noExpiry);
        metaBean.add(Boolean.class, "defaultLastValueQueue", (t, p) -> {
            t.defaultLastValueQueue = p;
        }, t -> t.defaultLastValueQueue);
        metaBean.add(SimpleString.class, "defaultLastValueKey", (t, p) -> {
            t.defaultLastValueKey = p;
        }, t -> t.defaultLastValueKey);
        metaBean.add(Boolean.class, "defaultNonDestructive", (t, p) -> {
            t.defaultNonDestructive = p;
        }, t -> t.defaultNonDestructive);
        metaBean.add(Boolean.class, "defaultExclusiveQueue", (t, p) -> {
            t.defaultExclusiveQueue = p;
        }, t -> t.defaultExclusiveQueue);
        metaBean.add(Boolean.class, "defaultGroupRebalance", (t, p) -> {
            t.defaultGroupRebalance = p;
        }, t -> t.defaultGroupRebalance);
        metaBean.add(Boolean.class, "defaultGroupRebalancePauseDispatch", (t, p) -> {
            t.defaultGroupRebalancePauseDispatch = p;
        }, t -> t.defaultGroupRebalancePauseDispatch);
        metaBean.add(Integer.class, "defaultGroupBuckets", (t, p) -> {
            t.defaultGroupBuckets = p;
        }, t -> t.defaultGroupBuckets);
        metaBean.add(SimpleString.class, "defaultGroupFirstKey", (t, p) -> {
            t.defaultGroupFirstKey = p;
        }, t -> t.defaultGroupFirstKey);
        metaBean.add(Long.class, "redistributionDelay", (t, p) -> {
            t.redistributionDelay = p;
        }, t -> t.redistributionDelay);
        metaBean.add(Boolean.class, "sendToDLAOnNoRoute", (t, p) -> {
            t.sendToDLAOnNoRoute = p;
        }, t -> t.sendToDLAOnNoRoute);
        metaBean.add(Long.class, "slowConsumerThreshold", (t, p) -> {
            t.slowConsumerThreshold = p;
        }, t -> t.slowConsumerThreshold);
        metaBean.add(SlowConsumerThresholdMeasurementUnit.class, "slowConsumerThresholdMeasurementUnit", (t, p) -> {
            t.slowConsumerThresholdMeasurementUnit = p;
        }, t -> t.slowConsumerThresholdMeasurementUnit);
        metaBean.add(Long.class, "slowConsumerCheckPeriod", (t, p) -> {
            t.slowConsumerCheckPeriod = p;
        }, t -> t.slowConsumerCheckPeriod);
        metaBean.add(SlowConsumerPolicy.class, "slowConsumerPolicy", (t, p) -> {
            t.slowConsumerPolicy = p;
        }, t -> t.slowConsumerPolicy);
        metaBean.add(Boolean.class, "autoCreateJmsQueues", (t, p) -> {
            t.autoCreateJmsQueues = (Boolean)p;
        }, t -> t.autoCreateJmsQueues, t -> t.autoCreateJmsQueues != null);
        metaBean.add(Boolean.class, "autoDeleteJmsQueues", (t, p) -> {
            t.autoDeleteJmsQueues = (Boolean)p;
        }, t -> t.autoDeleteJmsQueues, t -> t.autoDeleteJmsQueues != null);
        metaBean.add(Boolean.class, "autoCreateJmsTopics", (t, p) -> {
            t.autoCreateJmsTopics = (Boolean)p;
        }, t -> t.autoCreateJmsTopics, t -> t.autoCreateJmsTopics != null);
        metaBean.add(Boolean.class, "autoDeleteJmsTopics", (t, p) -> {
            t.autoDeleteJmsTopics = (Boolean)p;
        }, t -> t.autoDeleteJmsTopics, t -> t.autoDeleteJmsTopics != null);
        metaBean.add(Boolean.class, "autoCreateQueues", (t, p) -> {
            t.autoCreateQueues = p;
        }, t -> t.autoCreateQueues);
        metaBean.add(Boolean.class, "autoDeleteQueues", (t, p) -> {
            t.autoDeleteQueues = p;
        }, t -> t.autoDeleteQueues);
        metaBean.add(Boolean.class, "autoDeleteCreatedQueues", (t, p) -> {
            t.autoDeleteCreatedQueues = p;
        }, t -> t.autoDeleteCreatedQueues);
        metaBean.add(Long.class, "autoDeleteQueuesDelay", (t, p) -> {
            t.autoDeleteQueuesDelay = p;
        }, t -> t.autoDeleteQueuesDelay);
        metaBean.add(Boolean.class, "autoDeleteQueuesSkipUsageCheck", (t, p) -> {
            t.autoDeleteQueuesSkipUsageCheck = p;
        }, t -> t.autoDeleteQueuesSkipUsageCheck);
        metaBean.add(Long.class, "autoDeleteQueuesMessageCount", (t, p) -> {
            t.autoDeleteQueuesMessageCount = p;
        }, t -> t.autoDeleteQueuesMessageCount);
        metaBean.add(Long.class, "defaultRingSize", (t, p) -> {
            t.defaultRingSize = p;
        }, t -> t.defaultRingSize);
        metaBean.add(Long.class, "retroactiveMessageCount", (t, p) -> {
            t.retroactiveMessageCount = p;
        }, t -> t.retroactiveMessageCount);
        metaBean.add(DeletionPolicy.class, "configDeleteQueues", (t, p) -> {
            t.configDeleteQueues = p;
        }, t -> t.configDeleteQueues);
        metaBean.add(Boolean.class, "autoCreateAddresses", (t, p) -> {
            t.autoCreateAddresses = p;
        }, t -> t.autoCreateAddresses);
        metaBean.add(Boolean.class, "autoDeleteAddresses", (t, p) -> {
            t.autoDeleteAddresses = p;
        }, t -> t.autoDeleteAddresses);
        metaBean.add(Long.class, "autoDeleteAddressesDelay", (t, p) -> {
            t.autoDeleteAddressesDelay = p;
        }, t -> t.autoDeleteAddressesDelay);
        metaBean.add(Boolean.class, "autoDeleteAddressesSkipUsageCheck", (t, p) -> {
            t.autoDeleteAddressesSkipUsageCheck = p;
        }, t -> t.autoDeleteAddressesSkipUsageCheck);
        metaBean.add(DeletionPolicy.class, "configDeleteAddresses", (t, p) -> {
            t.configDeleteAddresses = p;
        }, t -> t.configDeleteAddresses);
        metaBean.add(DeletionPolicy.class, "configDeleteDiverts", (t, p) -> {
            t.configDeleteDiverts = p;
        }, t -> t.configDeleteDiverts);
        metaBean.add(Integer.class, "managementBrowsePageSize", (t, p) -> {
            t.managementBrowsePageSize = p;
        }, t -> t.managementBrowsePageSize);
        metaBean.add(Long.class, "maxSizeBytesRejectThreshold", (t, p) -> {
            t.maxSizeBytesRejectThreshold = p;
        }, t -> t.maxSizeBytesRejectThreshold);
        metaBean.add(Integer.class, "defaultMaxConsumers", (t, p) -> {
            t.defaultMaxConsumers = p;
        }, t -> t.defaultMaxConsumers);
        metaBean.add(Boolean.class, "defaultPurgeOnNoConsumers", (t, p) -> {
            t.defaultPurgeOnNoConsumers = p;
        }, t -> t.defaultPurgeOnNoConsumers);
        metaBean.add(Integer.class, "defaultConsumersBeforeDispatch", (t, p) -> {
            t.defaultConsumersBeforeDispatch = p;
        }, t -> t.defaultConsumersBeforeDispatch);
        metaBean.add(Long.class, "defaultDelayBeforeDispatch", (t, p) -> {
            t.defaultDelayBeforeDispatch = p;
        }, t -> t.defaultDelayBeforeDispatch);
        metaBean.add(RoutingType.class, "defaultQueueRoutingType", (t, p) -> {
            t.defaultQueueRoutingType = p;
        }, t -> t.defaultQueueRoutingType);
        metaBean.add(RoutingType.class, "defaultAddressRoutingType", (t, p) -> {
            t.defaultAddressRoutingType = p;
        }, t -> t.defaultAddressRoutingType);
        metaBean.add(Integer.class, "defaultConsumerWindowSize", (t, p) -> {
            t.defaultConsumerWindowSize = p;
        }, t -> t.defaultConsumerWindowSize);
        metaBean.add(Boolean.class, "autoCreateDeadLetterResources", (t, p) -> {
            t.autoCreateDeadLetterResources = p;
        }, t -> t.autoCreateDeadLetterResources);
        metaBean.add(SimpleString.class, "deadLetterQueuePrefix", (t, p) -> {
            t.deadLetterQueuePrefix = p;
        }, t -> t.deadLetterQueuePrefix);
        metaBean.add(SimpleString.class, "deadLetterQueueSuffix", (t, p) -> {
            t.deadLetterQueueSuffix = p;
        }, t -> t.deadLetterQueueSuffix);
        metaBean.add(Boolean.class, "autoCreateExpiryResources", (t, p) -> {
            t.autoCreateExpiryResources = p;
        }, t -> t.autoCreateExpiryResources);
        metaBean.add(SimpleString.class, "expiryQueuePrefix", (t, p) -> {
            t.expiryQueuePrefix = p;
        }, t -> t.expiryQueuePrefix);
        metaBean.add(SimpleString.class, "expiryQueueSuffix", (t, p) -> {
            t.expiryQueueSuffix = p;
        }, t -> t.expiryQueueSuffix);
        metaBean.add(Boolean.class, "enableMetrics", (t, p) -> {
            t.enableMetrics = p;
        }, t -> t.enableMetrics);
        metaBean.add(Integer.class, "managementMessageAttributeSizeLimit", (t, p) -> {
            t.managementMessageAttributeSizeLimit = p;
        }, t -> t.managementMessageAttributeSizeLimit);
        metaBean.add(Boolean.class, "enableIngressTimestamp", (t, p) -> {
            t.enableIngressTimestamp = p;
        }, t -> t.enableIngressTimestamp);
        metaBean.add(Integer.class, "idCacheSize", (t, p) -> {
            t.idCacheSize = p;
        }, t -> t.idCacheSize);
        metaBean.add(Integer.class, "queuePrefetch", (t, p) -> {
            t.queuePrefetch = p;
        }, t -> t.queuePrefetch);
        metaBean.add(Integer.class, "initialQueueBufferSize", (t, p) -> {
            t.initialQueueBufferSize = p;
        }, t -> t.initialQueueBufferSize);
    }
}

