/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml;

import javax.xml.namespace.QName;
import org.apache.cxf.aegis.xml.MessageWriter;

public abstract class AbstractMessageWriter
implements MessageWriter {
    private boolean xsiTypeWritten;

    @Override
    public void writeXsiType(QName type) {
        String value;
        if (this.xsiTypeWritten) {
            return;
        }
        this.xsiTypeWritten = true;
        String prefix = this.getPrefixForNamespace(type.getNamespaceURI(), type.getPrefix());
        if (prefix != null && prefix.length() > 0) {
            StringBuilder sb = new StringBuilder(prefix.length() + 1 + type.getLocalPart().length());
            sb.append(prefix);
            sb.append(':');
            sb.append(type.getLocalPart());
            value = sb.toString();
        } else {
            value = type.getLocalPart();
        }
        this.getAttributeWriter("type", "http://www.w3.org/2001/XMLSchema-instance").writeValue(value);
    }

    @Override
    public void writeXsiNil() {
        MessageWriter attWriter = this.getAttributeWriter("nil", "http://www.w3.org/2001/XMLSchema-instance");
        attWriter.writeValue("true");
        attWriter.close();
    }

    @Override
    public void writeValueAsInt(Integer i) {
        this.writeValue(i.toString());
    }

    @Override
    public void writeValueAsByte(Byte b) {
        this.writeValue(b.toString());
    }

    @Override
    public void writeValueAsDouble(Double d) {
        this.writeValue(d.toString());
    }

    @Override
    public void writeValueAsCharacter(Character char1) {
        this.writeValue(char1.toString());
    }

    @Override
    public void writeValueAsLong(Long l) {
        this.writeValue(l.toString());
    }

    @Override
    public void writeValueAsFloat(Float f) {
        this.writeValue(f.toString());
    }

    @Override
    public void writeValueAsBoolean(boolean b) {
        this.writeValue(b ? "true" : "false");
    }

    @Override
    public void writeValueAsShort(Short s) {
        this.writeValue(s.toString());
    }
}

