/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public final class ParameterizedCollectionType
implements ParameterizedType {
    private final Class<?> collectionMemberClass;
    private final Type[] typeArgs;

    public ParameterizedCollectionType(Class<?> collectionMemberClass) {
        this.collectionMemberClass = collectionMemberClass;
        this.typeArgs = new Type[]{collectionMemberClass};
    }

    public ParameterizedCollectionType(Type pt) {
        this.collectionMemberClass = InjectionUtils.getRawType(pt);
        this.typeArgs = new Type[]{pt};
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArgs;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    @Override
    public Type getRawType() {
        return Collection.class;
    }

    public String toString() {
        return "java.util.Collection<" + this.collectionMemberClass.getName() + ">";
    }
}

