/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.rat.ConfigurationException;
import org.apache.rat.config.exclusion.plexus.MatchPattern;
import org.apache.rat.config.exclusion.plexus.MatchPatterns;
import org.apache.rat.document.DocumentName;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;

public final class DocumentNameMatcher {
    private final Predicate<DocumentName> predicate;
    private final String name;
    private final boolean isCollection;
    public static final DocumentNameMatcher MATCHES_ALL = new DocumentNameMatcher("TRUE", x -> true);
    public static final DocumentNameMatcher MATCHES_NONE = new DocumentNameMatcher("FALSE", x -> false);

    public DocumentNameMatcher(String name, Predicate<DocumentName> predicate) {
        this.name = name;
        this.predicate = predicate;
        this.isCollection = predicate instanceof CompoundPredicate;
    }

    public DocumentNameMatcher(String name, DocumentNameMatcher delegate) {
        this(name, delegate::matches);
    }

    public DocumentNameMatcher(String name, MatchPatterns patterns, DocumentName basedir) {
        this(name, new MatchPatternsPredicate(basedir, patterns));
    }

    private static char[][] tokenize(String name, String dirSeparator) {
        String[] tokenizedName = MatchPattern.tokenizePathToString(name, dirSeparator);
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i = 0; i < tokenizedName.length; ++i) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
        }
        return tokenizedNameChar;
    }

    public DocumentNameMatcher(String name, final MatchPatterns matchers) {
        this(name, new CompoundPredicate(){

            @Override
            public Iterable<DocumentNameMatcher> getMatchers() {
                ArrayList<DocumentNameMatcher> result = new ArrayList<DocumentNameMatcher>();
                matchers.patterns().forEach(p -> result.add(new DocumentNameMatcher(p.source(), new Predicate<DocumentName>(){
                    private final MatchPatterns patterns;
                    {
                        this.patterns = MatchPatterns.from("/", p.source());
                    }

                    @Override
                    public boolean test(DocumentName documentName) {
                        return this.patterns.matches(documentName.getName(), documentName.isCaseSensitive());
                    }
                })));
                return result;
            }

            @Override
            public boolean test(DocumentName documentName) {
                return matchers.matches(documentName.getName(), documentName.isCaseSensitive());
            }
        });
    }

    public DocumentNameMatcher(String name, FileFilter fileFilter) {
        this(name, new FileFilterPredicate(fileFilter));
    }

    public DocumentNameMatcher(FileFilter fileFilter) {
        this(fileFilter.toString(), fileFilter);
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Predicate<DocumentName> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return this.name;
    }

    public boolean logDecompositionWhileMatching(DocumentName candidate) {
        boolean result = this.matches(candidate);
        Log log = DefaultLog.getInstance();
        Log.Level level = log.getLevel();
        log.log(level, String.format("FILTER TEST for %s -> %s", candidate, result));
        List<DecomposeData> data = this.decompose(candidate);
        log.log(level, "Decomposition for " + candidate);
        data.forEach(s -> log.log(level, s));
        return result;
    }

    public List<DecomposeData> decompose(DocumentName candidate) {
        ArrayList<DecomposeData> result = new ArrayList<DecomposeData>();
        this.decompose(0, this, candidate, result);
        return result;
    }

    private void decompose(int level, DocumentNameMatcher matcher, DocumentName candidate, List<DecomposeData> result) {
        Predicate<DocumentName> pred = matcher.getPredicate();
        result.add(new DecomposeData(level, matcher, candidate, pred.test(candidate)));
    }

    public boolean matches(DocumentName documentName) {
        return this.predicate.test(documentName);
    }

    public static DocumentNameMatcher not(DocumentNameMatcher nameMatcher) {
        if (nameMatcher == MATCHES_ALL) {
            return MATCHES_NONE;
        }
        if (nameMatcher == MATCHES_NONE) {
            return MATCHES_ALL;
        }
        return new DocumentNameMatcher(String.format("not(%s)", nameMatcher), new NotPredicate(nameMatcher));
    }

    private static String join(Collection<DocumentNameMatcher> matchers) {
        ArrayList children = new ArrayList();
        matchers.forEach(s -> children.add(s.toString()));
        return String.join((CharSequence)", ", children);
    }

    private static Optional<DocumentNameMatcher> standardCollectionCheck(Collection<DocumentNameMatcher> matchers, DocumentNameMatcher override) {
        if (matchers.isEmpty()) {
            throw new ConfigurationException("Empty matcher collection");
        }
        if (matchers.size() == 1) {
            return Optional.of(matchers.iterator().next());
        }
        if (matchers.contains(override)) {
            return Optional.of(override);
        }
        return Optional.empty();
    }

    public static DocumentNameMatcher or(Collection<DocumentNameMatcher> matchers) {
        Optional<DocumentNameMatcher> opt = DocumentNameMatcher.standardCollectionCheck(matchers, MATCHES_ALL);
        if (opt.isPresent()) {
            return opt.get();
        }
        LinkedHashSet<DocumentNameMatcher> workingSet = new LinkedHashSet<DocumentNameMatcher>();
        for (DocumentNameMatcher matcher : matchers) {
            if (matcher.predicate instanceof Or) {
                ((Or)matcher.predicate).getMatchers().forEach(workingSet::add);
                continue;
            }
            workingSet.add(matcher);
        }
        return DocumentNameMatcher.standardCollectionCheck(matchers, MATCHES_ALL).orElseGet(() -> new DocumentNameMatcher(String.format("or(%s)", DocumentNameMatcher.join(workingSet)), new Or(workingSet)));
    }

    public static DocumentNameMatcher or(DocumentNameMatcher ... matchers) {
        return DocumentNameMatcher.or(Arrays.asList(matchers));
    }

    public static DocumentNameMatcher and(Collection<DocumentNameMatcher> matchers) {
        Optional<DocumentNameMatcher> opt = DocumentNameMatcher.standardCollectionCheck(matchers, MATCHES_NONE);
        if (opt.isPresent()) {
            return opt.get();
        }
        LinkedHashSet<DocumentNameMatcher> workingSet = new LinkedHashSet<DocumentNameMatcher>();
        for (DocumentNameMatcher matcher : matchers) {
            if (matcher.predicate instanceof And) {
                ((And)matcher.predicate).getMatchers().forEach(workingSet::add);
                continue;
            }
            workingSet.add(matcher);
        }
        opt = DocumentNameMatcher.standardCollectionCheck(matchers, MATCHES_NONE);
        return opt.orElseGet(() -> new DocumentNameMatcher(String.format("and(%s)", DocumentNameMatcher.join(workingSet)), new And(workingSet)));
    }

    public static DocumentNameMatcher matcherSet(final DocumentNameMatcher includes, final DocumentNameMatcher excludes) {
        if (excludes == MATCHES_NONE) {
            return MATCHES_ALL;
        }
        if (includes == MATCHES_NONE) {
            return DocumentNameMatcher.not(excludes);
        }
        if (includes == MATCHES_ALL) {
            return MATCHES_ALL;
        }
        List<DocumentNameMatcher> workingSet = Arrays.asList(includes, excludes);
        return new DocumentNameMatcher(String.format("matcherSet(%s)", DocumentNameMatcher.join(workingSet)), new DefaultCompoundPredicate(workingSet){

            @Override
            public boolean test(DocumentName documentName) {
                if (includes.matches(documentName)) {
                    return true;
                }
                return !excludes.matches(documentName);
            }
        });
    }

    public static DocumentNameMatcher and(DocumentNameMatcher ... matchers) {
        return DocumentNameMatcher.and(Arrays.asList(matchers));
    }

    static interface CompoundPredicate
    extends Predicate<DocumentName> {
        public Iterable<DocumentNameMatcher> getMatchers();
    }

    public static final class MatchPatternsPredicate
    implements Predicate<DocumentName> {
        private final DocumentName basedir;
        private final MatchPatterns patterns;

        private MatchPatternsPredicate(DocumentName basedir, MatchPatterns patterns) {
            this.basedir = basedir;
            this.patterns = patterns;
        }

        @Override
        public boolean test(DocumentName documentName) {
            return this.patterns.matches(documentName.getName(), DocumentNameMatcher.tokenize(documentName.getName(), this.basedir.getDirectorySeparator()), this.basedir.isCaseSensitive());
        }

        public String toString() {
            return this.patterns.toString();
        }
    }

    public static final class FileFilterPredicate
    implements Predicate<DocumentName> {
        private final FileFilter fileFilter;

        private FileFilterPredicate(FileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public boolean test(DocumentName documentName) {
            return this.fileFilter.accept(new File(documentName.getName()));
        }

        public String toString() {
            return this.fileFilter.toString();
        }
    }

    public static final class DecomposeData {
        private final int level;
        private final DocumentNameMatcher matcher;
        private final boolean result;
        private final DocumentName candidate;

        private DecomposeData(int level, DocumentNameMatcher matcher, DocumentName candidate, boolean result) {
            this.level = level;
            this.matcher = matcher;
            this.result = result;
            this.candidate = candidate;
        }

        public String toString() {
            String fill = this.createFill(this.level);
            return String.format("%s%s: >>%s<< %s%n%s", fill, this.matcher.toString(), this.result, this.level == 0 ? this.candidate.getName() : "", this.matcher.predicate instanceof CompoundPredicate ? this.decompose(this.level + 1, (CompoundPredicate)this.matcher.predicate, this.candidate) : String.format("%s%s >>%s<<", this.createFill(this.level + 1), this.matcher.predicate.toString(), this.matcher.predicate.test(this.candidate)));
        }

        private String createFill(int level) {
            char[] chars = new char[level * 2];
            Arrays.fill(chars, ' ');
            return new String(chars);
        }

        private String decompose(int level, CompoundPredicate predicate, DocumentName candidate) {
            ArrayList result = new ArrayList();
            for (DocumentNameMatcher nameMatcher : predicate.getMatchers()) {
                nameMatcher.decompose(level, nameMatcher, candidate, result);
            }
            StringBuilder sb = new StringBuilder();
            result.forEach(x -> sb.append(x).append(System.lineSeparator()));
            return sb.toString();
        }
    }

    public static final class NotPredicate
    implements Predicate<DocumentName> {
        private final DocumentNameMatcher nameMatcher;

        private NotPredicate(DocumentNameMatcher nameMatcher) {
            this.nameMatcher = nameMatcher;
        }

        @Override
        public boolean test(DocumentName documentName) {
            return !this.nameMatcher.matches(documentName);
        }

        public String toString() {
            return this.nameMatcher.predicate.toString();
        }
    }

    static class Or
    extends DefaultCompoundPredicate {
        Or(Iterable<DocumentNameMatcher> matchers) {
            super(matchers);
        }

        @Override
        public boolean test(DocumentName documentName) {
            for (DocumentNameMatcher matcher : this.getMatchers()) {
                if (!matcher.matches(documentName)) continue;
                return true;
            }
            return false;
        }
    }

    static class And
    extends DefaultCompoundPredicate {
        And(Iterable<DocumentNameMatcher> matchers) {
            super(matchers);
        }

        @Override
        public boolean test(DocumentName documentName) {
            for (DocumentNameMatcher matcher : this.getMatchers()) {
                if (matcher.matches(documentName)) continue;
                return false;
            }
            return true;
        }
    }

    static abstract class DefaultCompoundPredicate
    implements CompoundPredicate {
        private final Iterable<DocumentNameMatcher> matchers;

        protected DefaultCompoundPredicate(Iterable<DocumentNameMatcher> matchers) {
            this.matchers = matchers;
        }

        @Override
        public Iterable<DocumentNameMatcher> getMatchers() {
            return this.matchers;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getName()).append(": ").append(System.lineSeparator());
            for (DocumentNameMatcher matcher : this.matchers) {
                builder.append(matcher.predicate.toString()).append(System.lineSeparator());
            }
            return builder.toString();
        }
    }
}

