/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.distribution;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.distribution.AbstractIntegerDistribution;
import org.apache.commons.math4.legacy.distribution.EnumeratedDistribution;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MathArithmeticException;
import org.apache.commons.math4.legacy.exception.NotANumberException;
import org.apache.commons.math4.legacy.exception.NotFiniteNumberException;
import org.apache.commons.math4.legacy.exception.NotPositiveException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class EnumeratedIntegerDistribution
extends AbstractIntegerDistribution {
    protected final EnumeratedDistribution<Integer> innerDistribution;

    public EnumeratedIntegerDistribution(int[] singletons, double[] probabilities) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(singletons, probabilities));
    }

    public EnumeratedIntegerDistribution(int[] data) {
        LinkedHashMap<Integer, Integer> dataMap = new LinkedHashMap<Integer, Integer>();
        for (int value : data) {
            dataMap.merge(value, 1, Integer::sum);
        }
        int massPoints = dataMap.size();
        double denom = data.length;
        int[] values = new int[massPoints];
        double[] probabilities = new double[massPoints];
        int index = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            values[index] = (Integer)entry.getKey();
            probabilities[index] = (double)((Integer)entry.getValue()).intValue() / denom;
            ++index;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedIntegerDistribution.createDistribution(values, probabilities));
    }

    private static List<Pair<Integer, Double>> createDistribution(int[] singletons, double[] probabilities) {
        if (singletons.length != probabilities.length) {
            throw new DimensionMismatchException(probabilities.length, singletons.length);
        }
        ArrayList<Pair<Integer, Double>> samples = new ArrayList<Pair<Integer, Double>>(singletons.length);
        for (int i = 0; i < singletons.length; ++i) {
            samples.add((Pair<Integer, Double>)new Pair((Object)singletons[i], (Object)probabilities[i]));
        }
        return samples;
    }

    public double probability(int x) {
        return this.innerDistribution.probability(x);
    }

    public double cumulativeProbability(int x) {
        double probability = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if ((Integer)sample.getKey() > x) continue;
            probability += ((Double)sample.getValue()).doubleValue();
        }
        return probability;
    }

    public double getMean() {
        double mean = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean += (Double)sample.getValue() * (double)((Integer)sample.getKey()).intValue();
        }
        return mean;
    }

    public double getVariance() {
        double mean = 0.0;
        double meanOfSquares = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean += (Double)sample.getValue() * (double)((Integer)sample.getKey()).intValue();
            meanOfSquares += (Double)sample.getValue() * (double)((Integer)sample.getKey()).intValue() * (double)((Integer)sample.getKey()).intValue();
        }
        return meanOfSquares - mean * mean;
    }

    public int getSupportLowerBound() {
        int min = Integer.MAX_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if ((Integer)sample.getKey() >= min || !((Double)sample.getValue() > 0.0)) continue;
            min = (Integer)sample.getKey();
        }
        return min;
    }

    public int getSupportUpperBound() {
        int max = Integer.MIN_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if ((Integer)sample.getKey() <= max || !((Double)sample.getValue() > 0.0)) continue;
            max = (Integer)sample.getKey();
        }
        return max;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return this.innerDistribution.createSampler(rng)::sample;
    }
}

