/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializerFactory;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.SquareNeighbourhood;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.junit.Assert;
import org.junit.Test;

public class NeuronSquareMesh2DTest {
    final FeatureInitializer init = FeatureInitializerFactory.uniform((double)0.0, (double)2.0);

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinimalNetworkSize1() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        new NeuronSquareMesh2D(1, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinimalNetworkSize2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        new NeuronSquareMesh2D(2, false, 0, false, SquareNeighbourhood.VON_NEUMANN, initArray);
    }

    @Test
    public void testGetFeaturesSize() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init, this.init, this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Assert.assertEquals((long)3L, (long)net.getFeaturesSize());
    }

    @Test
    public void test2x2Network() {
        Collection neighbours;
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        for (long id : new long[]{0L, 3L}) {
            neighbours = net.getNeighbours(net.getNeuron(id));
            for (long nId : new long[]{1L, 2L}) {
                Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
            }
            Assert.assertEquals((long)2L, (long)neighbours.size());
        }
        for (long id : new long[]{1L, 2L}) {
            neighbours = net.getNeighbours(net.getNeuron(id));
            for (long nId : new long[]{0L, 3L}) {
                Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
            }
            Assert.assertEquals((long)2L, (long)neighbours.size());
        }
    }

    @Test
    public void test2x2Network2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 2, false, SquareNeighbourhood.MOORE, initArray).getNetwork();
        for (long id : new long[]{0L, 1L, 2L, 3L}) {
            Collection neighbours = net.getNeighbours(net.getNeuron(id));
            for (long nId : new long[]{0L, 1L, 2L, 3L}) {
                if (id == nId) continue;
                Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
            }
        }
    }

    @Test
    public void test3x2CylinderNetwork() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L, 2L, 3L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L, 4L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{0L, 1L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{0L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(4L));
        for (long nId : new long[]{1L, 3L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(5L));
        for (long nId : new long[]{2L, 3L, 4L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
    }

    @Test
    public void test3x2CylinderNetwork2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(2, false, 3, true, SquareNeighbourhood.MOORE, initArray).getNetwork();
        for (long id : new long[]{0L, 1L, 2L, 3L, 4L, 5L}) {
            Collection neighbours = net.getNeighbours(net.getNeuron(id));
            for (long nId : new long[]{0L, 1L, 2L, 3L, 4L, 5L}) {
                if (id == nId) continue;
                Assert.assertTrue((String)("id=" + id + " nId=" + nId), (boolean)neighbours.contains(net.getNeuron(nId)));
            }
        }
    }

    @Test
    public void test3x3TorusNetwork() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(3, true, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L, 2L, 3L, 6L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L, 4L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{0L, 1L, 5L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{0L, 4L, 5L, 6L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(4L));
        for (long nId : new long[]{1L, 3L, 5L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(5L));
        for (long nId : new long[]{2L, 3L, 4L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(6L));
        for (long nId : new long[]{0L, 3L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(7L));
        for (long nId : new long[]{1L, 4L, 6L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(8L));
        for (long nId : new long[]{2L, 5L, 6L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
    }

    @Test
    public void test3x3TorusNetwork2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(3, true, 3, true, SquareNeighbourhood.MOORE, initArray).getNetwork();
        for (long id : new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}) {
            Collection neighbours = net.getNeighbours(net.getNeuron(id));
            for (long nId : new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L}) {
                if (id == nId) continue;
                Assert.assertTrue((String)("id=" + id + " nId=" + nId), (boolean)neighbours.contains(net.getNeuron(nId)));
            }
        }
    }

    @Test
    public void test3x3CylinderNetwork() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(3, false, 3, true, SquareNeighbourhood.MOORE, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L, 2L, 3L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L, 3L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{0L, 1L, 3L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{0L, 1L, 2L, 4L, 5L, 6L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(4L));
        for (long nId : new long[]{0L, 1L, 2L, 3L, 5L, 6L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(5L));
        for (long nId : new long[]{0L, 1L, 2L, 3L, 4L, 6L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(6L));
        for (long nId : new long[]{3L, 4L, 5L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(7L));
        for (long nId : new long[]{3L, 4L, 5L, 6L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(8L));
        for (long nId : new long[]{3L, 4L, 5L, 6L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
    }

    @Test
    public void test3x3CylinderNetwork2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(3, false, 3, false, SquareNeighbourhood.MOORE, initArray).getNetwork();
        Collection neighbours = net.getNeighbours(net.getNeuron(0L));
        for (long nId : new long[]{1L, 3L, 4L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(1L));
        for (long nId : new long[]{0L, 2L, 3L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(2L));
        for (long nId : new long[]{1L, 4L, 5L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(3L));
        for (long nId : new long[]{0L, 1L, 4L, 6L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(4L));
        for (long nId : new long[]{0L, 1L, 2L, 3L, 5L, 6L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(5L));
        for (long nId : new long[]{1L, 2L, 4L, 7L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(6L));
        for (long nId : new long[]{3L, 4L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(7L));
        for (long nId : new long[]{3L, 4L, 5L, 6L, 8L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)5L, (long)neighbours.size());
        neighbours = net.getNeighbours(net.getNeuron(8L));
        for (long nId : new long[]{4L, 5L, 7L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)3L, (long)neighbours.size());
    }

    @Test
    public void testConcentricNeighbourhood() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(5, true, 5, true, SquareNeighbourhood.VON_NEUMANN, initArray).getNetwork();
        HashSet<Neuron> exclude = new HashSet<Neuron>();
        Collection neighbours = net.getNeighbours(net.getNeuron(12L));
        for (long nId : new long[]{7L, 11L, 13L, 17L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)4L, (long)neighbours.size());
        exclude.add(net.getNeuron(12L));
        exclude.addAll(neighbours);
        neighbours = net.getNeighbours((Iterable)neighbours, exclude);
        for (long nId : new long[]{6L, 8L, 16L, 18L, 2L, 10L, 14L, 22L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
    }

    @Test
    public void testConcentricNeighbourhood2() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        Network net = new NeuronSquareMesh2D(5, true, 5, true, SquareNeighbourhood.MOORE, initArray).getNetwork();
        HashSet<Neuron> exclude = new HashSet<Neuron>();
        Collection neighbours = net.getNeighbours(net.getNeuron(8L));
        for (long nId : new long[]{2L, 3L, 4L, 7L, 9L, 12L, 13L, 14L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)8L, (long)neighbours.size());
        exclude.add(net.getNeuron(8L));
        exclude.addAll(neighbours);
        neighbours = net.getNeighbours((Iterable)neighbours, exclude);
        for (long nId : new long[]{1L, 6L, 11L, 16L, 17L, 18L, 19L, 15L, 10L, 5L, 0L, 20L, 24L, 23L, 22L, 21L}) {
            Assert.assertTrue((boolean)neighbours.contains(net.getNeuron(nId)));
        }
        Assert.assertEquals((long)16L, (long)neighbours.size());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D out = new NeuronSquareMesh2D(4, false, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(out);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        NeuronSquareMesh2D in = (NeuronSquareMesh2D)ois.readObject();
        for (Neuron nOut : out.getNetwork()) {
            Neuron nIn = in.getNetwork().getNeuron(nOut.getIdentifier());
            double[] outF = nOut.getFeatures();
            double[] inF = nIn.getFeatures();
            Assert.assertEquals((long)outF.length, (long)inF.length);
            for (int i = 0; i < outF.length; ++i) {
                Assert.assertEquals((double)outF[i], (double)inF[i], (double)0.0);
            }
            Collection outNeighbours = out.getNetwork().getNeighbours(nOut);
            Collection inNeighbours = in.getNetwork().getNeighbours(nIn);
            Assert.assertEquals((long)outNeighbours.size(), (long)inNeighbours.size());
            for (Neuron oN : outNeighbours) {
                Assert.assertTrue((boolean)inNeighbours.contains(in.getNetwork().getNeuron(oN.getIdentifier())));
            }
        }
    }

    @Test
    public void testGetNeuron() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D net = new NeuronSquareMesh2D(2, false, 2, true, SquareNeighbourhood.VON_NEUMANN, initArray);
        Assert.assertEquals((long)0L, (long)net.getNeuron(0, 0).getIdentifier());
        Assert.assertEquals((long)1L, (long)net.getNeuron(0, 1).getIdentifier());
        Assert.assertEquals((long)2L, (long)net.getNeuron(1, 0).getIdentifier());
        Assert.assertEquals((long)3L, (long)net.getNeuron(1, 1).getIdentifier());
        try {
            net.getNeuron(2, 0);
            Assert.fail((String)"exception expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            net.getNeuron(0, 2);
            Assert.fail((String)"exception expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            net.getNeuron(-1, 0);
            Assert.fail((String)"exception expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            net.getNeuron(0, -1);
            Assert.fail((String)"exception expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNeuronAlongDirection() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D net = new NeuronSquareMesh2D(3, false, 3, false, SquareNeighbourhood.VON_NEUMANN, initArray);
        Assert.assertEquals((long)0L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)1L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)2L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)3L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.CENTER).getIdentifier());
        Assert.assertEquals((long)4L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.CENTER).getIdentifier());
        Assert.assertEquals((long)5L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER).getIdentifier());
        Assert.assertEquals((long)6L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
        Assert.assertEquals((long)7L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
        Assert.assertEquals((long)8L, (long)net.getNeuron(1, 1, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
        Assert.assertNull((Object)net.getNeuron(0, 1, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.UP));
        Assert.assertNull((Object)net.getNeuron(1, 0, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.CENTER));
        Assert.assertNull((Object)net.getNeuron(2, 1, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN));
        Assert.assertNull((Object)net.getNeuron(1, 2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER));
    }

    @Test
    public void testGetNeuronAlongDirectionWrappedMap() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D net = new NeuronSquareMesh2D(3, true, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray);
        Assert.assertEquals((long)3L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
        Assert.assertEquals((long)2L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.CENTER).getIdentifier());
        Assert.assertEquals((long)7L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)8L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)6L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.CENTER, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)5L, (long)net.getNeuron(0, 0, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
        Assert.assertEquals((long)1L, (long)net.getNeuron(1, 2, NeuronSquareMesh2D.HorizontalDirection.LEFT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)0L, (long)net.getNeuron(1, 2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.UP).getIdentifier());
        Assert.assertEquals((long)3L, (long)net.getNeuron(1, 2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.CENTER).getIdentifier());
        Assert.assertEquals((long)6L, (long)net.getNeuron(1, 2, NeuronSquareMesh2D.HorizontalDirection.RIGHT, NeuronSquareMesh2D.VerticalDirection.DOWN).getIdentifier());
    }

    @Test
    public void testIterator() {
        FeatureInitializer[] initArray = new FeatureInitializer[]{this.init};
        NeuronSquareMesh2D map = new NeuronSquareMesh2D(3, true, 3, true, SquareNeighbourhood.VON_NEUMANN, initArray);
        HashSet<Neuron> fromMap = new HashSet<Neuron>();
        for (Neuron n : map) {
            fromMap.add(n);
        }
        Network net = map.getNetwork();
        HashSet<Neuron> fromNet = new HashSet<Neuron>();
        for (Neuron n : net) {
            fromNet.add(n);
        }
        for (Neuron n : fromMap) {
            Assert.assertTrue((boolean)fromNet.contains(n));
        }
        for (Neuron n : fromNet) {
            Assert.assertTrue((boolean)fromMap.contains(n));
        }
    }
}

