/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractXMLModelTest
extends AbstractJXPathTest {
    protected JXPathContext context;

    protected void assertXMLSignature(JXPathContext context, String path, String signature, boolean elements, boolean attributes, boolean text, boolean pi) {
        Object node = context.getPointer(path).getNode();
        String sig = this.getXMLSignature(node, elements, attributes, text, pi);
        Assertions.assertEquals((Object)signature, (Object)sig, (String)"XML Signature mismatch: ");
    }

    protected JXPathContext createContext() {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer());
        context.setFactory(this.getAbstractFactory());
        context.registerNamespace("product", "productNS");
        return context;
    }

    protected DocumentContainer createDocumentContainer() {
        return new DocumentContainer(AbstractJXPathTest.class.getResource("Vendor.xml"), this.getModel());
    }

    protected abstract AbstractFactory getAbstractFactory();

    protected abstract String getModel();

    protected abstract String getXMLSignature(Object var1, boolean var2, boolean var3, boolean var4, boolean var5);

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            DocumentContainer docCtr = this.createDocumentContainer();
            this.context = this.createContext();
            Variables vars = this.context.getVariables();
            vars.declareVariable("document", docCtr.getValue());
            vars.declareVariable("container", (Object)docCtr);
            vars.declareVariable("element", this.context.getPointer("vendor/location/address/street").getNode());
        }
    }

    @Test
    public void testAxisAncestor() {
        this.assertXPathValue(this.context, "vendor/product/price:sale/saleEnds/ancestor::price:sale/saleEnds", "never");
        this.assertXPathValue(this.context, "vendor/product/price:sale/saleEnds/ancestor::price:*/saleEnds", "never");
    }

    @Test
    public void testAxisAncestorOrSelf() {
        this.assertXPathValue(this.context, "vendor/product/price:sale/ancestor-or-self::price:sale/saleEnds", "never");
    }

    @Test
    public void testAxisAttribute() {
        this.assertXPathValue(this.context, "vendor/location/@id", "100");
        this.assertXPathPointer(this.context, "vendor/location/@id", "/vendor[1]/location[1]/@id");
        this.assertXPathValueIterator(this.context, "vendor/location/@id", AbstractXMLModelTest.list("100", "101"));
        this.assertXPathValue(this.context, "vendor/product/price:amount/@price:discount", "10%");
        this.assertXPathValue(this.context, "namespace-uri(vendor/product/price:amount/@price:discount)", "priceNS");
        this.assertXPathValue(this.context, "local-name(vendor/product/price:amount/@price:discount)", "discount");
        this.assertXPathValue(this.context, "name(vendor/product/price:amount/@price:discount)", "price:discount");
        this.assertXPathValue(this.context, "vendor/product/price:amount/@discount", "20%");
        this.assertXPathValue(this.context, "namespace-uri(vendor/product/price:amount/@discount)", "");
        this.assertXPathValue(this.context, "local-name(vendor/product/price:amount/@discount)", "discount");
        this.assertXPathValue(this.context, "name(vendor/product/price:amount/@discount)", "discount");
        this.assertXPathValueIterator(this.context, "vendor/product/price:amount/@price:*", AbstractXMLModelTest.list("10%"));
        this.assertXPathValueIterator(this.context, "vendor/location[1]/@*", AbstractXMLModelTest.set("100", "", "local"));
        this.assertXPathValueIterator(this.context, "vendor/product/price:amount/@*", AbstractXMLModelTest.set("10%", "20%"));
        this.assertXPathValueIterator(this.context, "vendor/product/price:amount/attribute::node()", AbstractXMLModelTest.set("10%", "20%"));
        this.assertXPathValueIterator(this.context, "vendor/product/price:amount/@*[namespace-uri() = '']", AbstractXMLModelTest.list("20%"));
        this.assertXPathValue(this.context, "vendor/location/@manager", "");
        this.assertXPathValueLenient(this.context, "vendor/location/@missing", null);
        this.assertXPathValueLenient(this.context, "vendor/location/@miss:missing", null);
        this.assertXPathValue(this.context, "vendor/location[@id='101']//street", "Tangerine Drive");
        this.assertXPathValueIterator(this.context, "/vendor/location[1]/@*[name()!= 'manager']", AbstractXMLModelTest.list("100", "local"));
    }

    @Test
    public void testAxisChild() {
        this.assertXPathValue(this.context, "vendor/location/address/street", "Orchard Road");
        this.assertXPathValue(this.context, "vendor/location/address/city", "Fruit Market");
        this.assertXPathValue(this.context, "local-name(vendor/product/price:amount)", "amount");
        this.assertXPathValue(this.context, "local-name(vendor/location)", "location");
        this.assertXPathValue(this.context, "name(vendor/product/price:amount)", "value:amount");
        this.assertXPathValue(this.context, "name(vendor/location)", "location");
        this.assertXPathValue(this.context, "namespace-uri(vendor/product/price:amount)", "priceNS");
        this.assertXPathValue(this.context, "vendor/product/prix", "934.99");
        this.assertXPathValue(this.context, "/vendor/contact[@name='jim']", "Jim");
        Assertions.assertThrows(JXPathException.class, () -> {
            this.context.setLenient(false);
            this.context.getValue("/vendor/contact[@name='jane']");
        }, (String)"No such value: /vendor/contact[@name='jim']");
        Assertions.assertThrows(JXPathException.class, () -> {
            this.context.setLenient(false);
            this.context.getValue("/vendor/contact[@name='jane']/*");
        }, (String)"No such value: /vendor/contact[@name='jane']/*");
        this.assertXPathValue(this.context, "count(vendor/product/price:*)", 2.0);
        this.assertXPathValue(this.context, "count(vendor/product/*)", 4.0);
        this.assertXPathValue(this.context, "vendor/product/price:amount", "45.95");
        this.context.registerNamespace("x", "temp");
        this.assertXPathValue(this.context, "vendor/x:pos//number", "109");
    }

    @Test
    public void testAxisChildIndexPredicate() {
        this.assertXPathValue(this.context, "vendor/location[2]/address/street", "Tangerine Drive");
    }

    @Test
    public void testAxisDescendant() {
        this.assertXPathValue(this.context, "//street", "Orchard Road");
        this.assertXPathValue(this.context, "count(//price:*)", 2.0);
        this.assertXPathValueIterator(this.context, "vendor//saleEnds", AbstractXMLModelTest.list("never"));
        this.assertXPathValueIterator(this.context, "vendor//promotion", AbstractXMLModelTest.list(""));
        this.assertXPathValueIterator(this.context, "vendor//saleEnds[../@stores = 'all']", AbstractXMLModelTest.list("never"));
        this.assertXPathValueIterator(this.context, "vendor//promotion[../@stores = 'all']", AbstractXMLModelTest.list(""));
    }

    @Test
    public void testAxisFollowing() {
        this.assertXPathValueIterator(this.context, "vendor/contact/following::location//street", AbstractXMLModelTest.list("Orchard Road", "Tangerine Drive"));
        this.assertXPathValue(this.context, "//location/following::price:sale/saleEnds", "never");
        this.assertXPathPointer(this.context, "//location[2]/following::node()[2]", "/vendor[1]/product[1]");
    }

    @Test
    public void testAxisFollowingSibling() {
        this.assertXPathValue(this.context, "vendor/location[.//employeeCount = 10]/following-sibling::location//street", "Tangerine Drive");
        this.assertXPathPointer(this.context, "vendor/location[.//employeeCount = 10]/following-sibling::location//street", "/vendor[1]/location[2]/address[1]/street[1]");
    }

    @Test
    public void testAxisNamespace() {
        this.assertXPathValueAndPointer(this.context, "vendor/product/prix/namespace::price", "priceNS", "/vendor[1]/product[1]/prix[1]/namespace::price");
        this.assertXPathValue(this.context, "count(vendor/product/namespace::*)", 3.0);
        this.assertXPathValue(this.context, "name(vendor/product/prix/namespace::price)", "price");
        this.assertXPathValue(this.context, "local-name(vendor/product/prix/namespace::price)", "price");
    }

    @Test
    public void testAxisParent() {
        this.assertXPathPointer(this.context, "//street/..", "/vendor[1]/location[1]/address[1]");
        this.assertXPathPointerIterator(this.context, "//street/..", AbstractXMLModelTest.list("/vendor[1]/location[2]/address[1]", "/vendor[1]/location[1]/address[1]"));
        this.assertXPathValue(this.context, "vendor/product/price:sale/saleEnds/parent::price:*/saleEnds", "never");
    }

    @Test
    public void testAxisPreceding() {
        this.assertXPathPointer(this.context, "//location[2]/preceding-sibling::location//street", "/vendor[1]/location[1]/address[1]/street[1]");
        this.assertXPathPointer(this.context, "//location[2]/preceding::*[1]", "/vendor[1]/location[1]/employeeCount[1]");
        this.assertXPathPointer(this.context, "//location[2]/preceding::node()[3]", "/vendor[1]/location[1]/employeeCount[1]/text()[1]");
        this.assertXPathPointer(this.context, "//location[2]/preceding::node()[4]", "/vendor[1]/location[1]/employeeCount[1]");
    }

    @Test
    public void testAxisPrecedingSibling() {
        this.assertXPathPointer(this.context, "//location[2]/preceding-sibling::location//street", "/vendor[1]/location[1]/address[1]/street[1]");
    }

    @Test
    public void testAxisSelf() {
        this.assertXPathValue(this.context, "//price:sale/self::price:sale/saleEnds", "never");
        this.assertXPathValueLenient(this.context, "//price:sale/self::x/saleEnds", null);
    }

    @Test
    public void testBooleanFunction() {
        this.assertXPathValue(this.context, "boolean(vendor//saleEnds[../@stores = 'all'])", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(vendor//promotion[../@stores = 'all'])", Boolean.TRUE);
        this.assertXPathValue(this.context, "boolean(vendor//promotion[../@stores = 'some'])", Boolean.FALSE);
    }

    @Test
    public void testContainer() {
        this.assertXPathValue(this.context, "$container/vendor//street", "Orchard Road");
        this.assertXPathValue(this.context, "$container//street", "Orchard Road");
        this.assertXPathPointer(this.context, "$container//street", "$container/vendor[1]/location[1]/address[1]/street[1]");
        this.assertXPathValue(this.context, "number(vendor/location/employeeCount)", 10.0);
    }

    @Test
    public void testCreatePath() {
        this.assertXPathCreatePath(this.context, "/vendor[1]/location[3]", "", "/vendor[1]/location[3]");
        this.assertXPathCreatePath(this.context, "/vendor[1]/location[3]/address/street", "", "/vendor[1]/location[3]/address[1]/street[1]");
        this.assertXPathCreatePath(this.context, "/vendor[1]/location[2]/@manager", "", "/vendor[1]/location[2]/@manager");
        this.assertXPathCreatePath(this.context, "/vendor[1]/location[1]/@name", "local", "/vendor[1]/location[1]/@name");
        this.assertXPathCreatePathAndSetValue(this.context, "/vendor[1]/location[4]/@manager", "", "/vendor[1]/location[4]/@manager");
        this.context.registerNamespace("price", "priceNS");
        this.assertXPathCreatePath(this.context, "/vendor[1]/price:foo/price:bar", "", "/vendor[1]/price:foo[1]/price:bar[1]");
    }

    @Test
    public void testCreatePathAndSetValue() {
        this.assertXPathCreatePathAndSetValue(this.context, "vendor/location[3]", "", "/vendor[1]/location[3]");
        this.assertXPathCreatePathAndSetValue(this.context, "vendor/location[3]/address/street", "Lemon Circle", "/vendor[1]/location[3]/address[1]/street[1]");
        this.assertXPathCreatePathAndSetValue(this.context, "vendor/location[2]/@manager", "John Doe", "/vendor[1]/location[2]/@manager");
        this.assertXPathCreatePathAndSetValue(this.context, "vendor/location[1]/@manager", "John Doe", "/vendor[1]/location[1]/@manager");
        this.assertXPathCreatePathAndSetValue(this.context, "/vendor[1]/location[4]/@manager", "James Dow", "/vendor[1]/location[4]/@manager");
        this.assertXPathCreatePathAndSetValue(this.context, "vendor/product/product:name/attribute::price:language", "English", "/vendor[1]/product[1]/product:name[1]/@price:language");
        this.context.registerNamespace("price", "priceNS");
        this.assertXPathCreatePathAndSetValue(this.context, "/vendor[1]/price:foo/price:bar", "123.20", "/vendor[1]/price:foo[1]/price:bar[1]");
    }

    @Test
    public void testDocument() {
        this.assertXPathValue(this.context, "$document/vendor/location[1]//street", "Orchard Road");
        this.assertXPathPointer(this.context, "$document/vendor/location[1]//street", "$document/vendor[1]/location[1]/address[1]/street[1]");
        this.assertXPathValue(this.context, "$document/vendor//street", "Orchard Road");
    }

    @Test
    public void testDocumentOrder() {
        this.assertDocumentOrder(this.context, "vendor/location", "vendor/location/address/street", -1);
        this.assertDocumentOrder(this.context, "vendor/location[@id = '100']", "vendor/location[@id = '101']", -1);
        this.assertDocumentOrder(this.context, "vendor//price:amount", "vendor/location", 1);
    }

    @Test
    public void testElementInVariable() {
        this.assertXPathValue(this.context, "$element", "Orchard Road");
    }

    @Test
    public void testFunctionsLastAndPosition() {
        this.assertXPathPointer(this.context, "vendor//location[last()]", "/vendor[1]/location[2]");
    }

    @Test
    public void testID() {
        this.context.setIdentityManager((context, id) -> {
            NodePointer ptr = (NodePointer)context.getPointer("/");
            ptr = ptr.getValuePointer();
            return ptr.getPointerByID(context, id);
        });
        this.assertXPathValueAndPointer(this.context, "id(101)//street", "Tangerine Drive", "id('101')/address[1]/street[1]");
        this.assertXPathPointerLenient(this.context, "id(105)/address/street", "id(105)/address/street");
    }

    @Test
    public void testLang() {
        this.assertXPathValue(this.context, "//product/prix/@xml:lang", "fr");
        this.assertXPathValue(this.context, "//product/prix[lang('fr')]", "934.99");
        this.assertXPathValue(this.context, "//product/price:sale[lang('en')]/saleEnds", "never");
    }

    @Test
    public void testNamespaceMapping() {
        this.context.registerNamespace("rate", "priceNS");
        this.context.registerNamespace("goods", "productNS");
        Assertions.assertEquals((Object)"priceNS", (Object)this.context.getNamespaceURI("price"), (String)"Context node namespace resolution");
        Assertions.assertEquals((Object)"priceNS", (Object)this.context.getNamespaceURI("rate"), (String)"Registered namespace resolution");
        this.assertXPathValue(this.context, "count(vendor/product/rate:*)", 2.0);
        this.assertXPathValue(this.context, "vendor[1]/product[1]/rate:amount[1]/@rate:discount", "10%");
        this.assertXPathValue(this.context, "vendor[1]/product[1]/rate:amount[1]/@price:discount", "10%");
        this.assertXPathValue(this.context, "vendor[1]/product[1]/price:amount[1]/@rate:discount", "10%");
        this.assertXPathValue(this.context, "vendor[1]/product[1]/price:amount[1]/@price:discount", "10%");
        this.assertXPathValueAndPointer(this.context, "//product:name", "Box of oranges", "/vendor[1]/product[1]/goods:name[1]");
        JXPathContext childCtx = JXPathContext.newContext((JXPathContext)this.context, (Object)this.context.getContextBean());
        this.assertXPathValueAndPointer(childCtx, "//product:name", "Box of oranges", "/vendor[1]/product[1]/goods:name[1]");
        JXPathContext relativeCtx = this.context.getRelativeContext(this.context.getPointer("/vendor"));
        this.assertXPathValueAndPointer(relativeCtx, "product/product:name", "Box of oranges", "/vendor[1]/product[1]/goods:name[1]");
    }

    @Test
    public void testNodes() {
        Pointer pointer = this.context.getPointer("/vendor[1]/contact[1]");
        Assertions.assertNotEquals((Object)pointer.getNode(), (Object)pointer.getValue());
    }

    @Test
    public void testNodeTypeComment() {
        this.assertXPathValue(this.context, "//product/comment()", "We are not buying this product, ever");
    }

    @Test
    public void testNodeTypeProcessingInstruction() {
        this.assertXPathValue(this.context, "//product/processing-instruction()", "do not show anybody");
        this.assertXPathValue(this.context, "//product/processing-instruction('report')", "average only");
        this.assertXPathPointer(this.context, "//product/processing-instruction('report')", "/vendor[1]/product[1]/processing-instruction('report')[1]");
        this.assertXPathValue(this.context, "name(//product/processing-instruction()[1])", "security");
    }

    @Test
    public void testNodeTypeText() {
        this.assertXPathValue(this.context, "//product/text()[. != '']", "We love this product.");
        this.assertXPathPointer(this.context, "//product/text()", "/vendor[1]/product[1]/text()[1]");
    }

    @Test
    public void testRemovePath() {
        this.context.removePath("vendor/location[@id = '101']//street/text()");
        Assertions.assertEquals((Object)"", (Object)this.context.getValue("vendor/location[@id = '101']//street"), (String)"Remove DOM text");
        this.context.removePath("vendor/location[@id = '101']//street");
        Assertions.assertEquals((Object)0.0, (Object)this.context.getValue("count(vendor/location[@id = '101']//street)"), (String)"Remove DOM element");
        this.context.removePath("vendor/location[@id = '100']/@name");
        Assertions.assertEquals((Object)0.0, (Object)this.context.getValue("count(vendor/location[@id = '100']/@name)"), (String)"Remove DOM attribute");
    }

    @Test
    public void testSetValue() {
        this.assertXPathSetValue(this.context, "vendor/location[@id = '100']", "New Text");
        this.assertXMLSignature(this.context, "vendor/location[@id = '100']", "<E>New Text</E>", false, false, true, false);
        this.assertXPathSetValue(this.context, "vendor/location[@id = '101']", "Replacement Text");
        this.assertXMLSignature(this.context, "vendor/location[@id = '101']", "<E>Replacement Text</E>", false, false, true, false);
    }

    @Test
    public void testTypeConversions() {
        this.assertXPathValue(this.context, "vendor/location/employeeCount + 1", 11.0);
        this.assertXPathValue(this.context, "vendor/location/employeeCount and true()", Boolean.TRUE);
    }

    @Test
    public void testUnion() {
        this.assertXPathValue(this.context, "/vendor[1]/contact[1] | /vendor[1]/contact[4]", "John");
        this.assertXPathValue(this.context, "/vendor[1]/contact[4] | /vendor[1]/contact[1]", "John");
    }
}

