/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.TestMixedModelBean;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.compiler.VariableFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class VariableTest
extends AbstractJXPathTest {
    private JXPathContext context;

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            this.context = JXPathContext.newContext((Object)new TestMixedModelBean());
            this.context.setFactory((AbstractFactory)new VariableFactory());
            Variables vars = this.context.getVariables();
            vars.declareVariable("a", (Object)1.0);
            vars.declareVariable("b", (Object)1.0);
            vars.declareVariable("c", null);
            vars.declareVariable("d", (Object)new String[]{"a", "b"});
            vars.declareVariable("integer", (Object)1);
            vars.declareVariable("nan", (Object)Double.NaN);
            vars.declareVariable("x", null);
        }
    }

    @Test
    public void testCreateAndSetValuePathDeclareVariableSetCollectionElement() {
        this.assertXPathCreatePathAndSetValue(this.context, "$stringArray[2]", "Value2", "$stringArray[2]");
        Assertions.assertEquals((Object)"Value1", (Object)this.context.getValue("$stringArray[1]"), (String)"Created <$stringArray[1]>");
    }

    @Test
    public void testCreatePathAndSetValueDeclareVariable() {
        this.assertXPathCreatePathAndSetValue(this.context, "$string", "Value", "$string");
    }

    @Test
    public void testCreatePathAndSetValueDeclareVariableSetProperty() {
        this.assertXPathCreatePathAndSetValue(this.context, "$test/boolean", Boolean.TRUE, "$test/boolean");
    }

    @Test
    public void testCreatePathAndSetValueDeclVarSetCollectionElementProperty() {
        this.assertXPathCreatePathAndSetValue(this.context, "$testArray[2]/boolean", Boolean.TRUE, "$testArray[2]/boolean");
    }

    @Test
    public void testCreatePathAndSetValueExpandCollection() {
        this.context.getVariables().declareVariable("array", (Object)new String[]{"Value1"});
        this.assertXPathCreatePathAndSetValue(this.context, "$array[2]", "Value2", "$array[2]");
        Assertions.assertEquals((Object)"Value1", (Object)this.context.getValue("$array[1]"), (String)"Created <$array[1]>");
    }

    @Test
    public void testCreatePathDeclareVariable() {
        this.assertXPathCreatePath(this.context, "$string", null, "$string");
    }

    @Test
    public void testCreatePathDeclareVariableSetCollectionElement() {
        this.assertXPathCreatePath(this.context, "$stringArray[2]", "", "$stringArray[2]");
        Assertions.assertEquals((Object)"Value1", (Object)this.context.getValue("$stringArray[1]"), (String)"Created <$stringArray[1]>");
    }

    @Test
    public void testCreatePathDeclareVariableSetCollectionElementProperty() {
        this.assertXPathCreatePath(this.context, "$testArray[2]/boolean", Boolean.FALSE, "$testArray[2]/boolean");
    }

    @Test
    public void testCreatePathDeclareVariableSetProperty() {
        this.assertXPathCreatePath(this.context, "$test/boolean", Boolean.FALSE, "$test/boolean");
    }

    @Test
    public void testCreatePathExpandCollection() {
        this.context.getVariables().declareVariable("array", (Object)new String[]{"Value1"});
        this.assertXPathCreatePath(this.context, "$array[2]", "", "$array[2]");
        Assertions.assertEquals((Object)"Value1", (Object)this.context.getValue("$array[1]"), (String)"Created <$array[1]>");
    }

    @Test
    public void testInvalidVariableName() {
        Assertions.assertThrows(Exception.class, () -> this.context.getValue("$none"), (String)"Evaluating '$none', expected exception - did not get it");
        Assertions.assertThrows(Exception.class, () -> this.context.setValue("$none", (Object)1), (String)"Setting '$none = 1', expected exception - did not get it");
    }

    @Test
    public void testIterateVariable() throws Exception {
        this.assertXPathValueIterator(this.context, "$d", VariableTest.list("a", "b"));
        this.assertXPathValue(this.context, "$d = 'a'", Boolean.TRUE);
        this.assertXPathValue(this.context, "$d = 'b'", Boolean.TRUE);
    }

    @Test
    public void testNestedContext() {
        JXPathContext nestedContext = JXPathContext.newContext((JXPathContext)this.context, null);
        this.assertXPathValue(nestedContext, "$a", 1.0);
    }

    @Test
    public void testRemovePathArrayElement() {
        this.context.getVariables().declareVariable("temp", (Object)new String[]{"temp1", "temp2"});
        this.context.removePath("$temp[1]");
        Assertions.assertEquals((Object)"temp2", (Object)this.context.getValue("$temp[1]"), (String)"Remove array element");
    }

    @Test
    public void testRemovePathCollectionElement() {
        this.context.getVariables().declareVariable("temp", (Object)VariableTest.list("temp1", "temp2"));
        this.context.removePath("$temp[1]");
        Assertions.assertEquals((Object)"temp2", (Object)this.context.getValue("$temp[1]"), (String)"Remove collection element");
    }

    @Test
    public void testRemovePathUndeclareVariable() {
        this.context.getVariables().declareVariable("temp", (Object)"temp");
        this.context.removePath("$temp");
        Assertions.assertFalse((boolean)this.context.getVariables().isDeclaredVariable("temp"), (String)"Undeclare variable");
    }

    @Test
    public void testSetValue() {
        this.assertXPathSetValue(this.context, "$x", 1);
    }

    @Test
    public void testUnionOfVariableAndNode() throws Exception {
        this.assertXPathValue(this.context, "count($a | /document/vendor/location)", 3.0);
        this.assertXPathValue(this.context, "count($a | /list)", 7.0);
    }

    @Test
    public void testVariables() {
        this.assertXPathValueAndPointer(this.context, "$a", 1.0, "$a");
    }

    @Test
    public void testVariablesInExpressions() {
        this.assertXPathValue(this.context, "$a = $b", Boolean.TRUE);
        this.assertXPathValue(this.context, "$a = $nan", Boolean.FALSE);
        this.assertXPathValue(this.context, "$a + 1", 2.0);
        this.assertXPathValue(this.context, "$c", null);
        this.assertXPathValue(this.context, "$d[2]", "b");
    }
}

