/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.converters.AbstractLocaleConverterTest;
import org.apache.commons.beanutils2.locale.converters.IntegerLocaleConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IntegerLocaleConverterTest
extends AbstractLocaleConverterTest<Integer> {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.defaultValue = Integer.valueOf("999");
        this.expectedValue = Integer.valueOf(this.expectedIntegerValue);
    }

    @Test
    public void testConstructor_2() {
        this.converter = IntegerLocaleConverter.builder().get();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_3() {
        this.converter = ((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_4() {
        this.converter = ((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(this.localizedLocale)).get();
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_5() {
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(this.localizedLocale)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_6() {
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.defaultIntegerPattern)).get();
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_7() {
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.localizedIntegerPattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_8() {
        this.converter = ((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setDefault((Object)((Integer)this.defaultValue))).get();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructor_9() {
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setDefault((Object)((Integer)this.defaultValue))).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructorMain() {
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setDefault((Object)((Integer)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.localizedIntegerPattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, "(A)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedIntegerValue, this.localizedIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultIntegerValue, Integer.valueOf("1"));
        this.convertValueWithPattern(this.converter, "(B)", this.localizedIntegerValue, this.defaultIntegerPattern, Integer.valueOf("1"));
        this.converter = ((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setDefault((Object)((Integer)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.defaultIntegerPattern)).setLocalizedPattern(false)).get();
        this.convertValueNoPattern(this.converter, "(C)", this.localizedIntegerValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedIntegerValue, this.defaultIntegerPattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    @Test
    public void testNumber() {
        this.converter = ((IntegerLocaleConverter.Builder)IntegerLocaleConverter.builder().setLocale(this.localizedLocale)).get();
        Integer value = 1234;
        Assertions.assertEquals((Object)value, (Object)this.converter.convert((Object)value), (String)"Convert Integer");
        Assertions.assertEquals((Object)value, (Object)this.converter.convert((Object)value), (String)"Convert Long");
    }

    @Test
    public void testToPrimitiveType() {
        this.converter = IntegerLocaleConverter.builder().get();
        Integer value = 20131028;
        Class<Integer> target = Integer.TYPE;
        int result = (Integer)this.converter.convert(target, (Object)value.toString());
        Assertions.assertEquals((int)value, (int)result, (String)"Wrong result");
    }
}

