/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.WeakHashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PrimitiveBean;
import org.apache.commons.beanutils.locale.LocaleBeanUtils;
import org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtils;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.logging.LogFactory;

public class LocaleBeanificationTestCase
extends TestCase {
    public static final int MAX_GC_ITERATIONS = 50;

    public static Test suite() {
        return new TestSuite(LocaleBeanificationTestCase.class);
    }

    public LocaleBeanificationTestCase(String name) {
        super(name);
    }

    public void setUp() {
        LocaleConvertUtils.deregister();
    }

    public void tearDown() {
    }

    public void testBeanUtilsBeanSetInstance() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        LocaleBeanUtilsBean beanOne = new LocaleBeanUtilsBean();
        LocaleBeanUtilsBean beanTwo = new LocaleBeanUtilsBean();
        class SetInstanceTesterThread
        extends Thread {
            private final Signal signal;
            private final LocaleBeanUtilsBean bean;

            SetInstanceTesterThread(Signal signal, LocaleBeanUtilsBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)this.bean);
                this.signal.setSignal(21);
                this.signal.setBean(LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
            }

            @Override
            public String toString() {
                return "SetInstanceTesterThread";
            }
        }
        SetInstanceTesterThread thread = new SetInstanceTesterThread(signal, beanTwo);
        thread.setContextClassLoader(new TestClassLoader());
        LocaleBeanUtilsBean.setInstance((LocaleBeanUtilsBean)beanOne);
        LocaleBeanificationTestCase.assertEquals((String)"Start thread gets right instance", (Object)beanOne, (Object)LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
        thread.start();
        thread.join();
        LocaleBeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)21, (int)signal.getSignal());
        LocaleBeanificationTestCase.assertEquals((String)"Second thread preserves value", (Object)beanOne, (Object)LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
        LocaleBeanificationTestCase.assertEquals((String)"Second thread gets value it set", (Object)beanTwo, (Object)signal.getBean());
    }

    public void testContextClassloaderIndependence() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        LocaleBeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        LocaleBeanificationTestCase.assertEquals((String)"Wrong property value (1)", (int)1, (int)bean.getInt());
        LocaleConvertUtils.register((LocaleConverter)new LocaleConverter(){

            public <T> T convert(Class<T> type, Object value) {
                return ConvertUtils.primitiveToWrapper(type).cast(5);
            }

            public <T> T convert(Class<T> type, Object value, String pattern) {
                return ConvertUtils.primitiveToWrapper(type).cast(5);
            }
        }, Integer.TYPE, (Locale)Locale.getDefault());
        LocaleBeanUtils.setProperty((Object)bean, (String)"int", (Object)"1");
        LocaleBeanificationTestCase.assertEquals((String)"Wrong property value(2)", (int)5, (int)bean.getInt());
        Signal signal = new Signal();
        signal.setSignal(1);
        class TestIndependenceThread
        extends Thread {
            private final Signal signal;
            private final PrimitiveBean bean;

            TestIndependenceThread(Signal signal, PrimitiveBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                try {
                    this.signal.setSignal(3);
                    LocaleConvertUtils.register((LocaleConverter)new LocaleConverter(){

                        public <T> T convert(Class<T> type, Object value) {
                            return ConvertUtils.primitiveToWrapper(type).cast(9);
                        }

                        public <T> T convert(Class<T> type, Object value, String pattern) {
                            return ConvertUtils.primitiveToWrapper(type).cast(9);
                        }
                    }, Integer.TYPE, (Locale)Locale.getDefault());
                    LocaleBeanUtils.setProperty((Object)this.bean, (String)"int", (Object)"1");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.signal.setException(e);
                }
            }

            @Override
            public String toString() {
                return "TestIndependenceThread";
            }
        }
        TestIndependenceThread thread = new TestIndependenceThread(signal, bean);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        LocaleBeanificationTestCase.assertNull((String)("Exception thrown by test thread:" + signal.getException()), (Object)signal.getException());
        LocaleBeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)3, (int)signal.getSignal());
        LocaleBeanificationTestCase.assertEquals((String)"Wrong property value(3)", (int)9, (int)bean.getInt());
    }

    public void testContextClassLoaderLocal() throws Exception {
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)1776);
        LocaleBeanificationTestCase.assertEquals((String)"Start thread sets value", (Object)new Integer(1776), (Object)ccll.get());
        Signal signal = new Signal();
        signal.setSignal(1);
        class CCLLTesterThread
        extends Thread {
            private final Signal signal;
            private final ContextClassLoaderLocal<Integer> ccll;

            CCLLTesterThread(Signal signal, ContextClassLoaderLocal<Integer> ccll) {
                this.signal = signal;
                this.ccll = ccll;
            }

            @Override
            public void run() {
                this.ccll.set((Object)new Integer(1789));
                this.signal.setSignal(2);
                this.signal.setMarkerObject(this.ccll.get());
            }

            @Override
            public String toString() {
                return "CCLLTesterThread";
            }
        }
        CCLLTesterThread thread = new CCLLTesterThread(signal, (ContextClassLoaderLocal<Integer>)ccll);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        LocaleBeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)2, (int)signal.getSignal());
        LocaleBeanificationTestCase.assertEquals((String)"Second thread preserves value", (Object)new Integer(1776), (Object)ccll.get());
        LocaleBeanificationTestCase.assertEquals((String)"Second thread gets value it set", (Object)new Integer(1789), (Object)signal.getMarkerObject());
    }

    public void testContextClassLoaderUnset() throws Exception {
        LocaleBeanUtilsBean beanOne = new LocaleBeanUtilsBean();
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)beanOne);
        LocaleBeanificationTestCase.assertEquals((String)"Start thread gets right instance", (Object)beanOne, (Object)ccll.get());
        ccll.unset();
        LocaleBeanificationTestCase.assertTrue((String)"Unset works", (!beanOne.equals(ccll.get()) ? 1 : 0) != 0);
    }

    public void testGetByContextClassLoader() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        class GetBeanUtilsBeanThread
        extends Thread {
            private final Signal signal;

            GetBeanUtilsBeanThread(Signal signal) {
                this.signal = signal;
            }

            @Override
            public void run() {
                this.signal.setSignal(2);
                this.signal.setBean(LocaleBeanUtilsBean.getLocaleBeanUtilsInstance());
                this.signal.setConvertUtils(LocaleConvertUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread(signal);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        LocaleBeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)2, (int)signal.getSignal());
        LocaleBeanificationTestCase.assertTrue((String)"Different LocaleBeanUtilsBean instances per context classloader", (BeanUtilsBean.getInstance() != signal.getBean() ? 1 : 0) != 0);
        LocaleBeanificationTestCase.assertTrue((String)"Different LocaleConvertUtilsBean instances per context classloader", (LocaleConvertUtilsBean.getInstance() != signal.getConvertUtils() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocaleAwareConverterInConvertUtils() throws Exception {
        try {
            Long data;
            try {
                data = (Long)ConvertUtils.convert((String)"777", Long.class);
                LocaleBeanificationTestCase.assertEquals((String)"Standard format long converted ok", (long)777L, (long)data);
            }
            catch (ConversionException ex) {
                LocaleBeanificationTestCase.fail((String)"Unable to convert non-locale-aware number 777");
            }
            try {
                data = (Long)ConvertUtils.convert((String)"1.000.000", Long.class);
                LocaleBeanificationTestCase.assertEquals((String)"Standard format behaved as expected", (long)0L, (long)data);
            }
            catch (ConversionException ex) {
                LocaleBeanificationTestCase.fail((String)"Unexpected exception from standard Long converter.");
            }
            try {
                Locale germanLocale = Locale.GERMAN;
                LongLocaleConverter longLocaleConverter = new LongLocaleConverter(germanLocale);
                ConvertUtils.register((Converter)longLocaleConverter, Long.class);
                Long data2 = (Long)ConvertUtils.convert((String)"1.000.000", Long.class);
                LocaleBeanificationTestCase.assertEquals((String)"German-format long converted ok", (long)1000000L, (long)data2);
            }
            catch (ConversionException ex) {
                LocaleBeanificationTestCase.fail((String)"Unable to convert german-format number");
            }
        }
        finally {
            ConvertUtils.deregister();
        }
    }

    public void testMemoryLeak() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader);
        LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
        class GetBeanUtilsBeanThread
        extends Thread {
            LocaleBeanUtilsBean beanUtils;
            LocaleConvertUtilsBean convertUtils;

            GetBeanUtilsBeanThread() {
            }

            @Override
            public void run() {
                this.beanUtils = LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
                this.convertUtils = LocaleConvertUtilsBean.getInstance();
                LogFactory.releaseAll();
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread();
        WeakReference<GetBeanUtilsBeanThread> threadWeakReference = new WeakReference<GetBeanUtilsBeanThread>(thread);
        thread.setContextClassLoader(loader);
        thread.start();
        thread.join();
        WeakReference<LocaleBeanUtilsBean> beanUtilsReference = new WeakReference<LocaleBeanUtilsBean>(thread.beanUtils);
        WeakReference<LocaleConvertUtilsBean> convertUtilsReference = new WeakReference<LocaleConvertUtilsBean>(thread.convertUtils);
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early (1)", loaderReference.get());
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early (2)", beanUtilsReference.get());
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early (4)", convertUtilsReference.get());
        loader = null;
        thread.setContextClassLoader(null);
        thread = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            LocaleBeanUtilsBean.getLocaleBeanUtilsInstance();
            System.gc();
            if (iterations++ > 50) {
                LocaleBeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            if (loaderReference.get() == null && beanUtilsReference.get() == null && convertUtilsReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    public void testMemoryLeak2() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader, queue);
        Integer test = new Integer(1);
        WeakReference<Integer> testReference = new WeakReference<Integer>(test, queue);
        WeakHashMap<TestClassLoader, Integer> map = new WeakHashMap<TestClassLoader, Integer>();
        map.put(loader, test);
        LocaleBeanificationTestCase.assertEquals((String)"In map", (Object)test, map.get(loader));
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early (1)", loaderReference.get());
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early (2)", testReference.get());
        loader = null;
        test = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                LocaleBeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            map.isEmpty();
            if (loaderReference.get() == null && testReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    public void testMemoryTestMethodology() throws Exception {
        ClassLoader loader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){};
        WeakReference<2> reference = new WeakReference<2>(loader);
        Class<?> myClass = loader.loadClass("org.apache.commons.beanutils.BetaBean");
        LocaleBeanificationTestCase.assertNotNull((String)"Weak reference released early", reference.get());
        loader = null;
        myClass = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                LocaleBeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            if (reference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    class Signal {
        private Exception e;
        private int signal;
        private LocaleBeanUtilsBean bean;
        private LocaleConvertUtilsBean convertUtils;
        private Object marker;

        Signal() {
        }

        public LocaleBeanUtilsBean getBean() {
            return this.bean;
        }

        public LocaleConvertUtilsBean getConvertUtils() {
            return this.convertUtils;
        }

        public Exception getException() {
            return this.e;
        }

        public Object getMarkerObject() {
            return this.marker;
        }

        public int getSignal() {
            return this.signal;
        }

        public void setBean(LocaleBeanUtilsBean bean) {
            this.bean = bean;
        }

        public void setConvertUtils(LocaleConvertUtilsBean convertUtils) {
            this.convertUtils = convertUtils;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public void setMarkerObject(Object marker) {
            this.marker = marker;
        }

        public void setSignal(int signal) {
            this.signal = signal;
        }
    }

    class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public String toString() {
            return "TestClassLoader";
        }
    }
}

