/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MappedPropertyChildBean;
import org.apache.commons.beanutils.MappedPropertyChildInterface;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MappedPropertyTestBean;
import org.apache.commons.beanutils.MappedPropertyTestInterface;

public class MappedPropertyTestCase
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)MappedPropertyTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(MappedPropertyTestCase.class);
    }

    public MappedPropertyTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() {
    }

    public void testAnyArgsProperty() {
        String property = "anyMapped";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("anyMapped", clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'anyMapped' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testBooleanMapped() {
        String property = "mappedBoolean";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedBoolean", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mappedBoolean' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testChildInterfaceMapped() {
        String property = "mapproperty";
        Class<MappedPropertyChildInterface> clazz = MappedPropertyChildInterface.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mapproperty' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testDifferentTypes() {
        String property = "differentTypes";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("differentTypes", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'differentTypes' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testFound() {
        String property = "mapproperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mapproperty' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInterfaceMapped() {
        String property = "mapproperty";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mapproperty' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInterfaceNotFound() {
        String property = "XXXXXX";
        Class<MappedPropertyTestInterface> clazz = MappedPropertyTestInterface.class;
        try {
            new MappedPropertyDescriptor("XXXXXX", clazz);
            MappedPropertyTestCase.fail((String)("Property 'XXXXXX' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidGetter() {
        String property = "invalidGetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("invalidGetter", clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'invalidGetter' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testInvalidSetter() {
        String property = "invalidSetter";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("invalidSetter", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'invalidSetter' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testMapGetter() {
        MappedPropertyTestBean bean = new MappedPropertyTestBean();
        try {
            String testValue = "test value";
            String testKey = "testKey";
            BeanUtils.setProperty((Object)bean, (String)"myMap(testKey)", (Object)"test value");
            MappedPropertyTestCase.assertEquals((String)"Map getter", (Object)"test value", (Object)bean.getMyMap().get("testKey"));
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Test set mapped property failed: " + ex));
        }
    }

    public void testMappedGetterOnly() {
        String property = "mappedGetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedGetterOnly", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNull((String)"Setter is found", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mappedGetterOnly' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testMappedSetterOnly() {
        String property = "mappedSetterOnly";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedSetterOnly", clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mappedSetterOnly' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testNotFound() {
        String property = "xxxxxxx";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            new MappedPropertyDescriptor("xxxxxxx", clazz);
            MappedPropertyTestCase.fail((String)("Property 'xxxxxxx' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPrimitiveArgsProperty() {
        String property = "mappedPrimitive";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mappedPrimitive", clazz);
            MappedPropertyTestCase.assertNull((String)"Getter is found", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mappedPrimitive' Not Found in " + clazz.getName() + ": " + ex));
        }
    }

    public void testProtected() {
        String property = "protectedProperty";
        Class<MappedPropertyTestBean> clazz = MappedPropertyTestBean.class;
        try {
            new MappedPropertyDescriptor("protectedProperty", clazz);
            MappedPropertyTestCase.fail((String)("Property 'protectedProperty' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testProtectedParentMethod() {
        String property = "protectedMapped";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        try {
            new MappedPropertyDescriptor("protectedMapped", clazz);
            MappedPropertyTestCase.fail((String)("Property 'protectedMapped' found in " + clazz.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPublicParentMethod() {
        String property = "mapproperty";
        Class<MappedPropertyChildBean> clazz = MappedPropertyChildBean.class;
        try {
            MappedPropertyDescriptor desc = new MappedPropertyDescriptor("mapproperty", clazz);
            MappedPropertyTestCase.assertNotNull((String)"Getter is missing", (Object)desc.getMappedReadMethod());
            MappedPropertyTestCase.assertNotNull((String)"Setter is missing", (Object)desc.getMappedWriteMethod());
        }
        catch (Exception ex) {
            MappedPropertyTestCase.fail((String)("Property 'mapproperty' Not Found in " + clazz.getName() + ": " + ex));
        }
    }
}

