/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.testdomain.model.good;

import org.springframework.lang.Nullable;

import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.Nature;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.Property;

import lombok.Getter;
import lombok.Setter;

public interface ProperGenericInterface<T> {

    T getValue();
    void setValue(T prop);

    T sampleAction(final T value);

    // -- IMPL

    @DomainObject(nature = Nature.VIEW_MODEL)
    public static class Impl
    implements ProperGenericInterface<String> {

        @Property
        @Getter @Setter
        private String value = "aValue";

        @Action
        @Override
        public String sampleAction(@Parameter @Nullable final String value) {
            return value;
        }

    }

}
