/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUtil {
    private static long seed;
    private static boolean seedSet;

    public static long getRandomSeed() {
        if (!seedSet) {
            String configured = System.getProperty("test.seed");
            seed = configured != null ? Long.valueOf(configured) : System.currentTimeMillis();
            System.err.println("test.seed=" + seed);
            seedSet = true;
        }
        return seed;
    }

    public static void resetRandomSeed() {
        seedSet = false;
    }

    public static Random createRandom() {
        return new Random(TestUtil.getRandomSeed());
    }

    public static ByteBuffer randomBytes(Random random) {
        byte[] bytes = new byte[TestUtil.randomLength(random)];
        random.nextBytes(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public static String randomString(Random random) {
        int length = TestUtil.randomLength(random);
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(97 + random.nextInt(25));
        }
        return new String(chars);
    }

    public static int randomLength(Random random) {
        int n = random.nextInt();
        if (n < 0) {
            n = -n;
        }
        return n & ((n & 0xF0000) != 0 ? 15 : ((n & 0xFF0000) != 0 ? 255 : ((n & 0xFFF0000) != 0 ? 4095 : 65535)));
    }

    @Test
    void randomLength() {
        long total = 0L;
        int count = 0x100000;
        int min2 = Short.MAX_VALUE;
        int max = 0;
        Random r = TestUtil.createRandom();
        for (int i = 0; i < count; ++i) {
            int length = TestUtil.randomLength(r);
            if (min2 > length) {
                min2 = length;
            }
            if (max < length) {
                max = length;
            }
            total += (long)length;
        }
        Assertions.assertEquals((int)0, (int)min2);
        Assertions.assertTrue((max > 32768 ? 1 : 0) != 0);
        float average = (float)total / (float)count;
        Assertions.assertTrue((average > 16.0f ? 1 : 0) != 0);
        Assertions.assertTrue((average < 64.0f ? 1 : 0) != 0);
    }
}

