/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Artist;
import org.musicbrainz.mmd2.ArtistList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class ArtistWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        ArtistList artistList = of.createArtistList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(artistList.getArtist(), results);
        artistList.setCount(BigInteger.valueOf(results.getTotalHits()));
        artistList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setArtistList(artistList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Artist artist = (Artist)MMDSerializer.unserialize((String)doc.get((IndexField)ArtistIndexField.ARTIST_STORE), Artist.class);
        artist.setScore(Integer.valueOf(result.getNormalizedScore()));
        list.add(artist);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getArtistList().getArtist().size() > 0) {
            for (Artist artist : metadata.getArtistList().getArtist()) {
                if (artist.getAliasList() == null) continue;
                for (Alias alias : artist.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) continue;
                    alias.setPrimary("true");
                }
            }
        }
    }
}

