import { CA } from './ca';
import { Provider } from './identity';
import { TLog } from './tlog';
import * as sigstore from './types/sigstore';
import type { KeySelector } from './verify';
interface CAOptions {
    fulcioURL?: string;
}
interface TLogOptions {
    rekorURL?: string;
}
export interface IdentityProviderOptions {
    identityToken?: string;
    oidcIssuer?: string;
    oidcClientID?: string;
    oidcClientSecret?: string;
    oidcRedirectURL?: string;
}
export interface TUFOptions {
    tufMirrorURL?: string;
    tufRootPath?: string;
    tufCachePath?: string;
}
export type SignOptions = CAOptions & TLogOptions & IdentityProviderOptions;
export type VerifyOptions = {
    ctLogThreshold?: number;
    tlogThreshold?: number;
    certificateIssuer?: string;
    certificateIdentityEmail?: string;
    certificateIdentityURI?: string;
    certificateOIDs?: Record<string, string>;
    keySelector?: KeySelector;
} & TLogOptions & TUFOptions;
export declare const DEFAULT_FULCIO_URL = "https://fulcio.sigstore.dev";
export declare const DEFAULT_REKOR_URL = "https://rekor.sigstore.dev";
export declare function createCAClient(options: {
    fulcioURL?: string;
}): CA;
export declare function createTLogClient(options: {
    rekorURL?: string;
}): TLog;
export declare function artifactVerificationOptions(options: VerifyOptions): sigstore.RequiredArtifactVerificationOptions;
export declare function identityProviders(options: IdentityProviderOptions): Provider[];
export {};
