aproba
======

A rediculously light-weight function argument validator

```
var validate = require("aproba")

function myfunc(a, b, c) {
  // `a` must be a string, `b` a number, `c` a function
  validate('SNF', arguments) // [a,b,c] is also valid
}

myfunc('test', 23, function () {}) // ok
myfunc(123, 23, function () {}) // type error
myfunc('test', 23) // missing arg error
myfunc('test', 23, function () {}, true) // too many args error

```

Valid types are:

type | description
---- | -----------
*    | matches any type
A    | instanceof Array OR an arguments object
S    | typeof == string
N    | typeof == number
F    | typeof == function
O    | typeof == object and not type A and not type E
B    | typeof == boolean
E    | instanceof Error OR null

Validation failures throw one of three exception types, distinguished by a
`code` property of `EMISSINGARG`, `EINVALIDTYPE` or `ETOOMANYARGS`.

If an error argument is found and is not null then the remaining arguments will not be validated.

### Why this exists

I wanted a very simple argument validator. It needed to do two things:

1. Be more concise and easier to use than assertions

2. Not encourage an infinite bikeshed of DSLs

This is why types are specified by a single character and there's no such
thing as an optional argument.

This is not intended to validate user data. This is specifically about
asserting the interface of your functions.

If you need greater validation, I encourage you to write them by hand or
look elsewhere.
