// This file implements the IInitializeWithFile Interface and Gateway for Python.
// Generated by makegw.py
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propsys.h"
#include "PyPROPVARIANT.h"
#include "PyIInitializeWithFile.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIInitializeWithFile::PyIInitializeWithFile(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIInitializeWithFile::~PyIInitializeWithFile() {}

/* static */ IInitializeWithFile *PyIInitializeWithFile::GetI(PyObject *self)
{
    return (IInitializeWithFile *)PyIUnknown::GetI(self);
}

// @pymethod |PyIInitializeWithFile|Initialize|Passes a file path to a property handler on startup
PyObject *PyIInitializeWithFile::Initialize(PyObject *self, PyObject *args)
{
    IInitializeWithFile *pIIWF = GetI(self);
    if (pIIWF == NULL)
        return NULL;
    TmpWCHAR path;
    PyObject *obpath;
    // @pyparm str|FilePath||Full path to the file whose properties are to be accessed
    // @pyparm int|Mode||Indicates if properties can be written, STGM_READ or STGM_READWRITE
    DWORD grfMode;
    if (!PyArg_ParseTuple(args, "Ok:Initialize", &obpath, &grfMode))
        return NULL;
    if (!PyWinObject_AsWCHAR(obpath, &path, FALSE))
        return NULL;

    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIIWF->Initialize(path, grfMode);
    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIIWF, IID_IInitializeWithFile);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIInitializeWithFile|Initializes a property handler that requires a file path instead of a stream
static struct PyMethodDef PyIInitializeWithFile_methods[] = {
    {"Initialize", PyIInitializeWithFile::Initialize,
     1},  // @pymeth Initialize|Passes a file path to a property handler on startup
    {NULL}};

PyComTypeObject PyIInitializeWithFile::type("PyIInitializeWithFile", &PyIUnknown::type, sizeof(PyIInitializeWithFile),
                                            PyIInitializeWithFile_methods, GET_PYCOM_CTOR(PyIInitializeWithFile));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGInitializeWithFile::Initialize(LPCWSTR pszFilePath, DWORD grfMode)
{
    PY_GATEWAY_METHOD;
    PyObject *obpath = PyWinObject_FromWCHAR(pszFilePath);
    if (obpath == NULL)
        return MAKE_PYCOM_GATEWAY_FAILURE_CODE("Initialize");
    HRESULT hr = InvokeViaPolicy("Initialize", NULL, "Ok", obpath, grfMode);
    Py_DECREF(obpath);
    return hr;
}
