// This file implements the IDebugDocumentTextEvents Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "PyIDebugDocumentTextEvents.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIDebugDocumentTextEvents::PyIDebugDocumentTextEvents(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIDebugDocumentTextEvents::~PyIDebugDocumentTextEvents() {}

/* static */ IDebugDocumentTextEvents *PyIDebugDocumentTextEvents::GetI(PyObject *self)
{
    return (IDebugDocumentTextEvents *)PyIUnknown::GetI(self);
}

// @pymethod |PyIDebugDocumentTextEvents|onDestroy|Description of onDestroy.
PyObject *PyIDebugDocumentTextEvents::onDestroy(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":onDestroy"))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onDestroy();
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextEvents|onInsertText|Description of onInsertText.
PyObject *PyIDebugDocumentTextEvents::onInsertText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToInsert||Description for cNumToInsert
    ULONG cCharacterPosition;
    ULONG cNumToInsert;
    if (!PyArg_ParseTuple(args, "ii:onInsertText", &cCharacterPosition, &cNumToInsert))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onInsertText(cCharacterPosition, cNumToInsert);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextEvents|onRemoveText|Description of onRemoveText.
PyObject *PyIDebugDocumentTextEvents::onRemoveText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToRemove||Description for cNumToRemove
    ULONG cCharacterPosition;
    ULONG cNumToRemove;
    if (!PyArg_ParseTuple(args, "ii:onRemoveText", &cCharacterPosition, &cNumToRemove))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onRemoveText(cCharacterPosition, cNumToRemove);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextEvents|onReplaceText|Description of onReplaceText.
PyObject *PyIDebugDocumentTextEvents::onReplaceText(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToReplace||Description for cNumToReplace
    ULONG cCharacterPosition;
    ULONG cNumToReplace;
    if (!PyArg_ParseTuple(args, "ii:onReplaceText", &cCharacterPosition, &cNumToReplace))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onReplaceText(cCharacterPosition, cNumToReplace);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextEvents|onUpdateTextAttributes|Description of onUpdateTextAttributes.
PyObject *PyIDebugDocumentTextEvents::onUpdateTextAttributes(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    // @pyparm int|cCharacterPosition||Description for cCharacterPosition
    // @pyparm int|cNumToUpdate||Description for cNumToUpdate
    ULONG cCharacterPosition;
    ULONG cNumToUpdate;
    if (!PyArg_ParseTuple(args, "ii:onUpdateTextAttributes", &cCharacterPosition, &cNumToUpdate))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onUpdateTextAttributes(cCharacterPosition, cNumToUpdate);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @pymethod |PyIDebugDocumentTextEvents|onUpdateDocumentAttributes|Description of onUpdateDocumentAttributes.
PyObject *PyIDebugDocumentTextEvents::onUpdateDocumentAttributes(PyObject *self, PyObject *args)
{
    IDebugDocumentTextEvents *pIDDTE = GetI(self);
    if (pIDDTE == NULL)
        return NULL;
    // @pyparm int|textdocattr||Description for textdocattr
    TEXT_DOC_ATTR textdocattr;
    if (!PyArg_ParseTuple(args, "i:onUpdateDocumentAttributes", &textdocattr))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIDDTE->onUpdateDocumentAttributes(textdocattr);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return OleSetOleError(hr);
    Py_INCREF(Py_None);
    return Py_None;
}

// @object PyIDebugDocumentTextEvents|Description of the interface
static struct PyMethodDef PyIDebugDocumentTextEvents_methods[] = {
    {"onDestroy", PyIDebugDocumentTextEvents::onDestroy, 1},        // @pymeth onDestroy|Description of onDestroy
    {"onInsertText", PyIDebugDocumentTextEvents::onInsertText, 1},  // @pymeth onInsertText|Description of onInsertText
    {"onRemoveText", PyIDebugDocumentTextEvents::onRemoveText, 1},  // @pymeth onRemoveText|Description of onRemoveText
    {"onReplaceText", PyIDebugDocumentTextEvents::onReplaceText,
     1},  // @pymeth onReplaceText|Description of onReplaceText
    {"onUpdateTextAttributes", PyIDebugDocumentTextEvents::onUpdateTextAttributes,
     1},  // @pymeth onUpdateTextAttributes|Description of onUpdateTextAttributes
    {"onUpdateDocumentAttributes", PyIDebugDocumentTextEvents::onUpdateDocumentAttributes,
     1},  // @pymeth onUpdateDocumentAttributes|Description of onUpdateDocumentAttributes
    {NULL}};

PyComTypeObject PyIDebugDocumentTextEvents::type("PyIDebugDocumentTextEvents", &PyIUnknown::type,
                                                 sizeof(PyIDebugDocumentTextEvents), PyIDebugDocumentTextEvents_methods,
                                                 GET_PYCOM_CTOR(PyIDebugDocumentTextEvents));
// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP PyGDebugDocumentTextEvents::onDestroy(void)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onDestroy", NULL);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextEvents::onInsertText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToInsert)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onInsertText", NULL, "ii", cCharacterPosition, cNumToInsert);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextEvents::onRemoveText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToRemove)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onRemoveText", NULL, "ii", cCharacterPosition, cNumToRemove);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextEvents::onReplaceText(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToReplace)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onReplaceText", NULL, "ii", cCharacterPosition, cNumToReplace);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextEvents::onUpdateTextAttributes(
    /* [in] */ ULONG cCharacterPosition,
    /* [in] */ ULONG cNumToUpdate)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onUpdateTextAttributes", NULL, "ii", cCharacterPosition, cNumToUpdate);
    return hr;
}

STDMETHODIMP PyGDebugDocumentTextEvents::onUpdateDocumentAttributes(
    /* [in] */ TEXT_DOC_ATTR textdocattr)
{
    PY_GATEWAY_METHOD;
    HRESULT hr = InvokeViaPolicy("onUpdateDocumentAttributes", NULL, "i", textdocattr);
    return hr;
}
