/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.InteriorNodeCursor;
import com.sun.electric.database.geometry.btree.LeafNodeCursor;
import com.sun.electric.database.geometry.btree.NodeCursor;
import com.sun.electric.database.geometry.btree.unboxed.AssociativeCommutativeOperation;
import com.sun.electric.database.geometry.btree.unboxed.AssociativeOperation;
import com.sun.electric.database.geometry.btree.unboxed.InvertibleOperation;
import com.sun.electric.database.geometry.btree.unboxed.Pair;
import com.sun.electric.database.geometry.btree.unboxed.Unboxed;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedComparable;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedFunction;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.io.PrintStream;
import java.io.Serializable;

public class BTree<K extends Serializable & Comparable, V extends Serializable, S extends Serializable> {
    final CachingPageStorage ps;
    final UnboxedComparable<K> uk;
    final Summary<K, V, S> summary;
    final Unboxed<V> uv;
    final UnboxedInt ui = UnboxedInt.instance;
    private LeafNodeCursor<K, V, S> leafNodeCursor;
    private InteriorNodeCursor<K, V, S> interiorNodeCursor1;
    private InteriorNodeCursor<K, V, S> interiorNodeCursor2;
    int rootpage;
    private final byte[] keybuf;
    private final byte[] keybuf2;
    private final byte[] sbuf;
    private final byte[] largestKey;
    private int largestKeyPage = -1;
    private int size = 0;
    private final byte[] monbuf;
    static long insertionFastPath = 0L;
    static long insertionSlowPath = 0L;
    static long splitEven = 0L;
    static long splitUnEven = 0L;

    public BTree(CachingPageStorage ps, UnboxedComparable<K> uk, Unboxed<V> uv, Summary<K, V, S> summary) {
        if (summary != null && !(summary instanceof AssociativeCommutativeOperation)) {
            throw new RuntimeException("Only commutative summary operations are supported (allows one-pass insertion)");
        }
        this.summary = summary;
        this.ps = ps;
        this.uk = uk;
        this.uv = uv;
        this.leafNodeCursor = new LeafNodeCursor(this);
        this.interiorNodeCursor1 = new InteriorNodeCursor(this);
        this.interiorNodeCursor2 = new InteriorNodeCursor(this);
        this.rootpage = ps.createPage();
        this.keybuf = new byte[uk.getSize()];
        this.keybuf2 = new byte[uk.getSize()];
        this.sbuf = summary == null ? null : new byte[summary.getSize()];
        this.largestKey = new byte[uk.getSize()];
        this.leafNodeCursor.initBuf(ps.getPage(this.rootpage, false), this.rootpage, true);
        this.leafNodeCursor.writeBack();
        this.monbuf = this.summary == null ? null : new byte[this.summary.getSize()];
    }

    public int getNumFromKeys(K min, K max) {
        if (min == null && max == null) {
            return this.size;
        }
        throw new RuntimeException("not implemented");
    }

    public int size() {
        return this.getNumFromKeys(null, null);
    }

    public V getValFromKey(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, null, Op.GET_VAL_FROM_KEY, 0));
    }

    public V getValFromKeyFloor(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, null, Op.GET_VAL_FROM_KEY_FLOOR, 0));
    }

    public V getValFromKeyCeiling(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, null, Op.GET_VAL_FROM_KEY_CEIL, 0));
    }

    public int getOrdFromKey(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, null, Op.GET_ORD_FROM_KEY, 0);
    }

    public int getOrdFromKeyFloor(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, null, Op.GET_ORD_FROM_KEY_FLOOR, 0);
    }

    public int getOrdFromKeyCeiling(K key) {
        this.uk.serialize(key, this.keybuf, 0);
        return (Integer)this.walk(this.keybuf, 0, null, null, Op.GET_ORD_FROM_KEY_CEIL, 0);
    }

    public V getKeyFromKeyNext(K key) {
        throw new RuntimeException("not implemented");
    }

    public V getKeyFromKeyPrev(K key) {
        throw new RuntimeException("not implemented");
    }

    public V getValFromOrd(int ord) {
        return (V)((Serializable)this.walk(null, 0, null, null, Op.GET_VAL_FROM_ORD, ord));
    }

    public K getKeyFromOrd(int ord) {
        return (K)((Serializable)this.walk(null, 0, null, null, Op.GET_KEY_FROM_ORD, ord));
    }

    public void insert(K key, V val) {
        this.uk.serialize(key, this.keybuf, 0);
        this.walk(this.keybuf, 0, null, val, Op.INSERT, 0);
        ++this.size;
    }

    public V replace(K key, V newval) {
        this.uk.serialize(key, this.keybuf, 0);
        return (V)((Serializable)this.walk(this.keybuf, 0, null, newval, Op.REPLACE, 0));
    }

    public V remove(K key) {
        return this.remove(key, null);
    }

    public V remove(K key, V val) {
        if (val == null && this.summary != null) {
            throw new RuntimeException("remove(key) and remove(key,null) may not be used on BTrees with summaries");
        }
        if (this.summary != null && !(this.summary instanceof InvertibleOperation)) {
            throw new RuntimeException("BTrees with non-InvertibleOperation summaries are insert-only");
        }
        this.uk.serialize(key, this.keybuf, 0);
        Serializable ret = (Serializable)this.walk(this.keybuf, 0, val, null, Op.REMOVE, 0);
        if (ret != null) {
            --this.size;
        }
        return (V)ret;
    }

    public V removeRange(K key1, K key2) {
        if (this.summary != null && !(this.summary instanceof InvertibleOperation)) {
            throw new RuntimeException("BTrees with non-InvertibleOperation summaries are insert-only");
        }
        throw new RuntimeException("not implemented");
    }

    public void clear() {
        this.size = 0;
        this.largestKeyPage = -1;
        throw new RuntimeException("not implemented");
    }

    public S getSummaryFromKeys(K min, K max) {
        if (min != null) {
            this.uk.serialize(min, this.keybuf, 0);
        }
        if (max != null) {
            this.uk.serialize(max, this.keybuf2, 0);
        }
        int ret = 0;
        ret = (Integer)this.walk(min == null ? null : this.keybuf, 0, null, null, Op.SUMMARIZE_LEFT, ret, max == null ? null : this.keybuf2, 0, this.sbuf, 0);
        ret = (Integer)this.walk(min == null ? null : this.keybuf, 0, null, null, Op.SUMMARIZE_RIGHT, ret, max == null ? null : this.keybuf2, 0, this.sbuf, 0);
        return ret == 0 ? null : (S)this.summary.deserialize(this.sbuf, 0);
    }

    private Object walk(byte[] key, int key_ofs, V oldval, V newval, Op op, int ord) {
        return this.walk(key, key_ofs, oldval, newval, op, ord, null, 0, null, 0);
    }

    private Object walk(byte[] key, int key_ofs, V oldval, V newval, Op op, int ord, byte[] key2, int key2_ofs, byte[] ret, int ret_ofs) {
        NodeCursor cur;
        InteriorNodeCursor parentNodeCursor;
        InteriorNodeCursor interiorNodeCursor;
        Object return_val;
        block73: {
            return_val = null;
            int pageid = this.rootpage;
            int idx = -1;
            int global_ord = 0;
            LeafNodeCursor<K, V, S> leafNodeCursor = this.leafNodeCursor;
            interiorNodeCursor = this.interiorNodeCursor1;
            parentNodeCursor = this.interiorNodeCursor2;
            cur = null;
            boolean summaryInitialized = ord != 0;
            boolean rightEdge = true;
            boolean cheat = false;
            int comp = 0;
            if (this.largestKeyPage != -1 && op == Op.INSERT) {
                leafNodeCursor.setBuf(this.ps.getPage(this.largestKeyPage, true));
                comp = this.uk.compare(key, key_ofs, this.largestKey, 0);
                if (comp >= 0 && !leafNodeCursor.isFull()) {
                    pageid = this.largestKeyPage;
                    parentNodeCursor.forgetCachedPage();
                    cheat = true;
                    cur = leafNodeCursor;
                }
            }
            while (true) {
                if (cur == null || cur.getCachedPage() == null || cur.getPageId() != pageid) {
                    CachingPageStorage.CachedPage cp = this.ps.getPage(pageid, true);
                    cur = LeafNodeCursor.isLeafNode(cp) ? leafNodeCursor : interiorNodeCursor;
                    cur.setBuf(cp);
                }
                assert (cheat || pageid == this.rootpage || cur.getParent() == parentNodeCursor.getPageId());
                if ((op == Op.INSERT || op == Op.REPLACE) && cur.isFull()) {
                    int splitPoint;
                    int old;
                    assert (cur != parentNodeCursor);
                    boolean splitting_last_or_root = false;
                    if (pageid == this.rootpage) {
                        parentNodeCursor.initRoot();
                        parentNodeCursor.setBucketPageId(0, pageid);
                        cur.setParent(parentNodeCursor.getPageId());
                        idx = 0;
                        old = this.size;
                        splitting_last_or_root = true;
                    } else {
                        assert (!parentNodeCursor.isFull());
                        splitting_last_or_root = idx >= parentNodeCursor.getNumBuckets() - 1;
                        int n = old = splitting_last_or_root ? -1 : parentNodeCursor.getNumValsBelowBucket(idx);
                    }
                    if (op == Op.INSERT && old != -1) {
                        --old;
                    }
                    int ofs = parentNodeCursor.insertNewBucketAt(idx + 1);
                    int oldpage = cur.getPageId();
                    int n = splitPoint = rightEdge ? cur.getNumBuckets() - 1 : cur.getMaxBuckets() / 2;
                    if (rightEdge) {
                        ++splitUnEven;
                    } else {
                        ++splitEven;
                    }
                    if (this.summary != null) {
                        cur.getSummary(0, this.monbuf, 0);
                        parentNodeCursor.setSummary(idx, this.monbuf, 0);
                        for (int i = 1; i < splitPoint; ++i) {
                            cur.getSummary(i, this.monbuf, 0);
                            parentNodeCursor.mergeSummaryCommutative(idx, this.monbuf, 0);
                        }
                    }
                    int num = cur.split(parentNodeCursor.getBuf(), ofs, splitPoint);
                    parentNodeCursor.setNumValsBelowBucket(idx, num);
                    int newpage = cur.getPageId();
                    if (this.largestKeyPage == oldpage) {
                        this.largestKeyPage = newpage;
                    }
                    parentNodeCursor.setBucketPageId(idx + 1, newpage);
                    cur.setParent(parentNodeCursor.getPageId());
                    if (!splitting_last_or_root) {
                        parentNodeCursor.setNumValsBelowBucket(idx + 1, old - num);
                    }
                    if (!(this.summary == null || parentNodeCursor.isRightMost() && idx + 1 >= parentNodeCursor.getNumBuckets() - 1)) {
                        cur.getSummary(0, this.monbuf, 0);
                        parentNodeCursor.setSummary(idx + 1, this.monbuf, 0);
                        for (int i = 1; i < cur.getNumBuckets() - (cur.isRightMost() ? 1 : 0); ++i) {
                            cur.getSummary(i, this.monbuf, 0);
                            parentNodeCursor.mergeSummaryCommutative(idx + 1, this.monbuf, 0);
                        }
                    }
                    cur.writeBack();
                    parentNodeCursor.writeBack();
                    pageid = this.rootpage;
                    cheat = false;
                    continue;
                }
                if (op == Op.SUMMARIZE_LEFT || op == Op.SUMMARIZE_RIGHT) {
                    int next;
                    int start = key == null ? 0 : cur.search(key, key_ofs);
                    --start;
                    start = Math.max(0, start);
                    int n = next = op == Op.SUMMARIZE_RIGHT ? -1 : start;
                    if (!cur.isLeafNode()) {
                        start = Math.max(1, start);
                    }
                    for (int i = start; i < cur.getNumBuckets(); ++i) {
                        int cmpRight;
                        int cmpLeft;
                        int n2 = cmpLeft = key == null ? -1 : cur.compare(key, key_ofs, i);
                        int n3 = key2 == null ? 1 : (cur.isLeafNode() ? (cur.compare(key2, key2_ofs, i + 1) < 0 ? -1 : 1) : (cmpRight = i == cur.getNumBuckets() - 1 ? -1 : cur.compare(key2, key2_ofs, i + 1)));
                        if (cmpLeft <= 0 && cmpRight > 0 && (cur.isLeafNode() || i < cur.getNumBuckets() - 1)) {
                            if (summaryInitialized) {
                                cur.getSummary(i, this.monbuf, 0);
                                this.summary.multiply(ret, ret_ofs, this.monbuf, 0, ret, ret_ofs);
                            } else {
                                cur.getSummary(i, ret, ret_ofs);
                                summaryInitialized = true;
                            }
                        }
                        if (cmpLeft > 0 && op == Op.SUMMARIZE_LEFT) {
                            next = i;
                        }
                        if (cmpRight >= 0) continue;
                        if (op != Op.SUMMARIZE_RIGHT) break;
                        next = i;
                        break;
                    }
                    if (next == -1) {
                        next = cur.getNumBuckets() - 1;
                    }
                    if (cur.isLeafNode()) {
                        return summaryInitialized ? 1 : 0;
                    }
                    pageid = ((InteriorNodeCursor)cur).getBucketPageId(next);
                    InteriorNodeCursor ic = (InteriorNodeCursor)cur;
                    interiorNodeCursor = parentNodeCursor;
                    parentNodeCursor = ic;
                    continue;
                }
                if (cheat) {
                    idx = leafNodeCursor.getNumBuckets() - 1;
                    comp = 1;
                } else if (!op.isGetFromOrd()) {
                    idx = cur.search(key, key_ofs);
                    comp = cur.compare(key, key_ofs, idx);
                } else if (!cur.isLeafNode()) {
                    int k;
                    for (idx = 0; idx < interiorNodeCursor.getNumBuckets() - 1 && ord >= (k = interiorNodeCursor.getNumValsBelowBucket(idx)); ord -= k, ++idx) {
                    }
                }
                if (cur.isLeafNode()) {
                    switch (op) {
                        case GET_VAL_FROM_ORD: {
                            return ord >= leafNodeCursor.getNumBuckets() ? null : leafNodeCursor.getVal(ord);
                        }
                        case GET_KEY_FROM_ORD: {
                            return ord >= leafNodeCursor.getNumBuckets() ? null : leafNodeCursor.getKey(ord);
                        }
                        case GET_VAL_FROM_KEY: {
                            return comp == 0 ? leafNodeCursor.getVal(idx) : null;
                        }
                        case GET_VAL_FROM_KEY_FLOOR: {
                            return leafNodeCursor.getVal(idx);
                        }
                        case GET_VAL_FROM_KEY_CEIL: {
                            throw new RuntimeException("not implemented");
                        }
                        case GET_ORD_FROM_KEY: {
                            return comp == 0 ? Integer.valueOf(idx + global_ord) : -1;
                        }
                        case GET_ORD_FROM_KEY_FLOOR: {
                            return idx + global_ord;
                        }
                        case GET_ORD_FROM_KEY_CEIL: {
                            return comp == 0 ? Integer.valueOf(idx + global_ord) : Integer.valueOf(idx + global_ord + 1);
                        }
                        case REMOVE: {
                            if (comp != 0) {
                                throw new RuntimeException("attempt to remove key which did not exist");
                            }
                            return_val = leafNodeCursor.getVal(idx);
                            leafNodeCursor.deleteVal(idx);
                            break block73;
                        }
                        case INSERT: {
                            if (comp == 0) {
                                throw new RuntimeException("attempt to re-insert a value at key " + leafNodeCursor.getKey(idx));
                            }
                            if (cheat) {
                                ++insertionFastPath;
                            } else {
                                ++insertionSlowPath;
                            }
                            if (this.largestKeyPage == -1 || cheat) {
                                System.arraycopy(key, key_ofs, this.largestKey, 0, this.largestKey.length);
                            }
                            if (this.largestKeyPage == -1) {
                                this.largestKeyPage = pageid;
                            }
                            leafNodeCursor.insertVal(idx + 1, key, key_ofs, newval);
                            break block73;
                        }
                        case REPLACE: {
                            if (comp != 0) {
                                throw new RuntimeException("attempt to replace a key that wasn't there");
                            }
                            if (cheat) {
                                ++insertionFastPath;
                            } else {
                                ++insertionSlowPath;
                            }
                            if (this.largestKeyPage == -1 || cheat) {
                                System.arraycopy(key, key_ofs, this.largestKey, 0, this.largestKey.length);
                            }
                            if (this.largestKeyPage == -1) {
                                this.largestKeyPage = pageid;
                            }
                            return_val = leafNodeCursor.setVal(idx, newval);
                            break block73;
                        }
                    }
                    continue;
                }
                switch (op) {
                    case REPLACE: {
                        break;
                    }
                    case REMOVE: {
                        if (idx >= interiorNodeCursor.getNumBuckets() - 1) break;
                        interiorNodeCursor.setNumValsBelowBucket(idx, interiorNodeCursor.getNumValsBelowBucket(idx) - 1);
                        interiorNodeCursor.writeBack();
                        break;
                    }
                    case INSERT: {
                        if (idx >= interiorNodeCursor.getNumBuckets() - 1) break;
                        interiorNodeCursor.setNumValsBelowBucket(idx, interiorNodeCursor.getNumValsBelowBucket(idx) + 1);
                        interiorNodeCursor.writeBack();
                        break;
                    }
                }
                if (op.isGetOrd()) {
                    for (int i = 0; i < idx; ++i) {
                        global_ord += interiorNodeCursor.getNumValsBelowBucket(i);
                    }
                }
                rightEdge &= idx == interiorNodeCursor.getNumBuckets() - 1;
                pageid = interiorNodeCursor.getBucketPageId(idx);
                InteriorNodeCursor ic = interiorNodeCursor;
                interiorNodeCursor = parentNodeCursor;
                parentNodeCursor = ic;
                if (!$assertionsDisabled && interiorNodeCursor == parentNodeCursor) break;
            }
            throw new AssertionError();
        }
        byte[] vbuf = new byte[this.uk.getSize() + this.uv.getSize()];
        while (cur.getParent() != cur.getPageId()) {
            parentNodeCursor.setBuf(this.ps.getPage(cur.getParent(), true));
            int slot = parentNodeCursor.getSlotByChildPageId(cur.getPageId());
            assert (slot != -1);
            if (this.summary != null && slot < parentNodeCursor.getNumBuckets() - 1) {
                switch (op) {
                    case REMOVE: 
                    case REPLACE: {
                        cur.getSummary(this.monbuf, 0);
                        parentNodeCursor.setSummary(slot, this.monbuf, 0);
                        parentNodeCursor.writeBack();
                        break;
                    }
                    case INSERT: {
                        System.arraycopy(key, 0, vbuf, 0, this.uk.getSize());
                        this.uv.serialize(newval, vbuf, this.uk.getSize());
                        this.summary.call(vbuf, 0, this.monbuf, 0);
                        parentNodeCursor.mergeSummaryCommutative(slot, this.monbuf, 0);
                        parentNodeCursor.writeBack();
                        break;
                    }
                }
            }
            InteriorNodeCursor ic = interiorNodeCursor;
            interiorNodeCursor = parentNodeCursor;
            parentNodeCursor = ic;
            cur = interiorNodeCursor;
        }
        return return_val;
    }

    public static void clearStats() {
        splitUnEven = 0L;
        splitEven = 0L;
        insertionFastPath = 0L;
        insertionSlowPath = 0L;
    }

    public static void dumpStats(PrintStream pw) {
        pw.println("BTree stats: insertion fastpath = " + insertionFastPath + "/" + (insertionFastPath + insertionSlowPath) + " = " + (int)((float)(insertionFastPath * 100L) / (float)(insertionFastPath + insertionSlowPath)) + "%");
        pw.println("             intelligent splits = " + splitUnEven + "/" + (splitUnEven + splitEven) + " = " + (int)((float)(splitUnEven * 100L) / (float)(splitUnEven + splitEven)) + "%");
    }

    public static interface Summary<K extends Serializable & Comparable, V extends Serializable, S extends Serializable>
    extends AssociativeOperation<S>,
    UnboxedFunction<Pair<K, V>, S> {
    }

    private static enum Op {
        GET_VAL_FROM_KEY,
        GET_VAL_FROM_KEY_FLOOR,
        GET_VAL_FROM_KEY_CEIL,
        GET_ORD_FROM_KEY,
        GET_ORD_FROM_KEY_FLOOR,
        GET_ORD_FROM_KEY_CEIL,
        GET_VAL_FROM_ORD,
        GET_KEY_FROM_ORD,
        GET_NEXT,
        GET_PREV,
        REMOVE,
        INSERT,
        REPLACE,
        SUMMARIZE_LEFT,
        SUMMARIZE_RIGHT;


        public boolean isGetFromOrd() {
            switch (this) {
                case GET_VAL_FROM_ORD: 
                case GET_KEY_FROM_ORD: {
                    return true;
                }
            }
            return false;
        }

        public boolean isGetOrd() {
            switch (this) {
                case GET_ORD_FROM_KEY: 
                case GET_ORD_FROM_KEY_FLOOR: 
                case GET_ORD_FROM_KEY_CEIL: {
                    return true;
                }
            }
            return false;
        }
    }
}

